/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datastore;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.extras.DiagramExtras;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.ensemble.canvas.DataStoreGO;
import com.elixirtech.ensemble.wizard.datastore.DataStorePageRegistry;
import com.elixirtech.ensemble.wizard.datastore.DataStoreTypePage;
import com.elixirtech.ensemble.wizard.datastore.ErrorStorePage;
import com.elixirtech.ensemble.wizard.datastore.INodeHolder;
import com.elixirtech.ensemble.wizard.datastore.TypePage;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.PageHolder;
import com.elixirtech.util.FileUtil;
import com.elixirtech.util.URLUtil;
import com.elixirtech.wizard.GOWizard;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DataStoreWizard
extends GOWizard
implements INodeHolder {
    private final DataStoreGO m_GO;
    private Set<String> m_OtherDataStoreNames;
    private DataStoreTypePage m_DataStoreTypePage;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DataStoreWizard.class);

    public DataStoreWizard(DataStoreGO dataStoreGO) {
        super("DataStoreWizard.TITLE");
        this.m_GO = dataStoreGO;
        this.buildPages();
    }

    protected DataStoreWizard(String string, DataStoreGO dataStoreGO) {
        super(string);
        this.m_GO = dataStoreGO;
        this.buildPages();
    }

    @Override
    public Node getNode() {
        return this.m_GO;
    }

    public DataStoreGO getGO() {
        return this.m_GO;
    }

    @Override
    public boolean canFinish() {
        return this.getContainer().getCurrentPage().isPageComplete();
    }

    @Override
    public boolean performFinish() {
        this.m_DataStoreTypePage.performFinish();
        TypePage typePage = (TypePage)this.m_DataStoreTypePage.getNextPage();
        if (typePage != null) {
            typePage.performFinish();
        }
        DiagramExtras.setDirty(true);
        return true;
    }

    protected void buildPages() {
        this.m_DataStoreTypePage = new DataStoreTypePage(this.m_GO);
        this.m_Pages.add(this.m_DataStoreTypePage);
        for (PageHolder pageHolder : DataStorePageRegistry.getPageHolders()) {
            try {
                this.m_Pages.add(pageHolder.getPage());
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't load page: " + pageHolder.getPageClassName()));
            }
        }
        this.m_Pages.add(new ErrorStorePage());
        Iterator<PageHolder> iterator = this.m_Pages.iterator();
        while (iterator.hasNext()) {
            ((IWizardPage)((Object)iterator.next())).setWizard(this);
        }
    }

    protected static String ensureURL(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        if (URLUtil.isURL(string)) {
            return string;
        }
        if (string.indexOf("$") >= 0) {
            return string;
        }
        File file = new File(string);
        return FileUtil.asURL(file);
    }

    protected boolean isNameOk(String string) {
        if (this.m_OtherDataStoreNames == null) {
            this.buildDataStoreNames();
        }
        return !this.m_OtherDataStoreNames.contains(string);
    }

    private void buildDataStoreNames() {
        this.m_OtherDataStoreNames = new HashSet<String>();
        Diagram diagram = this.m_GO.getDiagram();
        for (GO gO : diagram.getChildGOs()) {
            if (gO == this.m_GO || !(gO instanceof DataStoreGO)) continue;
            this.m_OtherDataStoreNames.add(((DataStoreGO)gO).getText());
        }
    }
}

