/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datastore;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.repository.RepositorySaveWizard;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.datastore.DataStoreWizard;
import com.elixirtech.ensemble.wizard.datastore.INodeHolder;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextField;

public class ErrorStorePage
extends RelativeLayoutWizardPage {
    public static final String PageName = "ErrorStore";
    private JTextField m_ErrorURL;

    public ErrorStorePage() {
        super(PageName, null);
        this.m_Layout = new ArchLayout();
        this.m_Component.setLayout(this.m_Layout);
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DataStore.ErrorStorePage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        Node node = ((INodeHolder)((Object)this.m_Wizard)).getNode();
        this.m_ErrorURL = SwingFactory.newTextField("url");
        String string = node.getUserProperty("JDBC_ErrorStoreURL");
        if (string != null) {
            this.m_ErrorURL.setText(string);
        }
        this.m_Component.add(SwingFactory.newLabel("url-label"));
        this.m_Component.add(this.m_ErrorURL);
        JButton jButton = SwingFactory.newDotsButton("dots", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ErrorStorePage.this.openChooser();
            }
        });
        this.m_Component.add(jButton);
        I18N.ENSEMBLE_MAP.injectComponents("DataStore.ErrorStorePage.", this.m_Component);
        this.positionComponents();
    }

    public void openChooser() {
        FileObject fileObject = null;
        Repository repository = (Repository)Elixir.get(Repository.class);
        String string = this.m_ErrorURL.getText();
        if (string.startsWith("repository:")) {
            string = string.substring(11);
            fileObject = (FileObject)repository.getFile(string).get();
        }
        String string2 = I18N.ENSEMBLE.getString("DataStore.ErrorStorePage.title");
        RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
        FileType fileType = (FileType)repositoryExplorer.getFileType("text/x-datasource").get();
        RepositorySaveWizard repositorySaveWizard = new RepositorySaveWizard(string2, fileObject);
        repositorySaveWizard.setSelectionPath(string);
        I18N.ENSEMBLE_MAP.injectObject(null, repositorySaveWizard.getPage(), "ErrorStore.SaveWizard");
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.showWizard(repositorySaveWizard);
        if (repositorySaveWizard.isFinished()) {
            this.m_ErrorURL.setText("repository:" + repositorySaveWizard.getSelectionPath());
        }
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    public void performFinish() {
        INodeHolder iNodeHolder = (INodeHolder)((Object)this.m_Wizard);
        Node node = iNodeHolder.getNode();
        node.setUserProperty("JDBC_ErrorStoreURL", DataStoreWizard.ensureURL(this.m_ErrorURL.getText()));
    }

    private void positionComponents() {
        this.m_Layout.stickLeft("url-label");
        this.m_Layout.vCenter("url-label", "url");
        this.m_Layout.putRight("url", "url-label", 10);
        this.m_Layout.stickTop("url");
        this.m_Layout.putLeft("url", "dots");
        this.m_Layout.stickRight("dots");
        this.m_Layout.stickTop("dots");
        this.m_Layout.setHeight("dots", "url");
    }
}

