/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datastore;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.datastore.CheckFileAccess;
import com.elixirtech.ensemble.wizard.datastore.DataStoreWizard;
import com.elixirtech.ensemble.wizard.datastore.INodeHolder;
import com.elixirtech.ensemble.wizard.datastore.TypePage;
import com.elixirtech.ui.FileSaveDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.FileUtil;
import com.elixirtech.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;

public class JSONPage
extends TypePage
implements ActionListener {
    private JTextField m_URL;
    private JButton m_Dots1;

    public JSONPage() {
        super("JSON File");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DataStore.JSONPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        Node node = ((INodeHolder)((Object)this.m_Wizard)).getNode();
        this.m_URL = SwingFactory.newTextField("url");
        this.m_Dots1 = SwingFactory.newDotsButton("dots1", this);
        if (node != null) {
            this.m_URL.setText(node.getUserProperty("display"));
        }
        this.m_URL.getDocument().addDocumentListener(new FieldWatcher(iWizard));
        this.m_Component.add(SwingFactory.newLabel("url-label"));
        this.m_Component.add(this.m_URL);
        this.m_Component.add(this.m_Dots1);
        I18N.ENSEMBLE_MAP.injectComponents("DataStore.JSONPage.", this.m_Component);
        this.positionComponents();
    }

    private void positionComponents() {
        this.m_Layout.stickLeft("url-label");
        this.m_Layout.vCenter("url-label", "url");
        this.m_Layout.putRight("url", "url-label", 10);
        this.m_Layout.stickTop("url");
        this.m_Layout.putLeft("url", "dots1");
        this.m_Layout.stickRight("dots1");
        this.m_Layout.stickTop("dots1");
        this.m_Layout.setHeight("dots1", "url");
    }

    @Override
    public boolean isPageComplete() {
        boolean bl = true;
        this.setError(null);
        if (StringUtil.isEmpty(this.m_URL.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.URL_REQUIRED"));
            bl = false;
        } else if (!CheckFileAccess.isOk(this.m_URL.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.INVALID_FILE_LOCATION"));
            bl = false;
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    @Override
    public void performFinish() {
        INodeHolder iNodeHolder = (INodeHolder)((Object)this.m_Wizard);
        Node node = iNodeHolder.getNode();
        node.setUserProperty("display", this.m_URL.getText());
        node.setUserProperty("JSON_URL", DataStoreWizard.ensureURL(this.m_URL.getText()));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        FileSaveDialog fileSaveDialog = new FileSaveDialog();
        fileSaveDialog.removeChoosableFileFilter(fileSaveDialog.getAcceptAllFileFilter());
        fileSaveDialog.setFilter("json", I18N.ENSEMBLE.getString("DataStore.JSONPage.JSONFiles"));
        if (fileSaveDialog.showSaveDialog(this.m_Component) == 0) {
            this.m_URL.setText(FileUtil.asURL(fileSaveDialog.getSelectedFile()));
        }
    }
}

