/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datastore;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.datastore.INodeHolder;
import com.elixirtech.ensemble.wizard.datastore.TypePage;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.BeanTableModel;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.util.StringUtil;
import com.elixirtech.util.collections.BeanMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class JavaPage
extends TypePage {
    private JTextField m_ClassName;
    private BeanTableModel m_Model;
    private JTable m_Table;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JavaPage.class);

    public JavaPage() {
        super("Custom Java DataStore");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DataStore.JavaPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        Node node = ((INodeHolder)((Object)this.m_Wizard)).getNode();
        this.m_Model = new BeanTableModel();
        this.m_Table = SwingFactory.newTable();
        this.m_Table.setModel(this.m_Model);
        this.m_ClassName = this.addField("cls", SwingFactory.newLabel("cls-label"));
        if (node != null) {
            this.m_ClassName.setText(node.getUserProperty("Java_ClassName"));
        }
        this.m_ClassName.getDocument().addDocumentListener(new FieldWatcher(this.m_Wizard));
        this.m_Component.add(SwingFactory.newScrollPane("table", this.m_Table));
        I18N.ENSEMBLE_MAP.injectComponents("DataStore.JavaPage.", this.m_Component);
        this.stickTop("cls");
        this.putRight("cls", "cls-label", 10);
        this.putBelow("table", "cls", 5);
        this.stickLeft("table");
        this.stickRight("table");
        this.stickBottom("table");
        this.isPageComplete();
        if (node != null) {
            BeanMap beanMap = this.m_Model.getBeanMap();
            Iterator<String> iterator = beanMap.keyIterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = iterator.next();
                if ("Java_ClassName".equals(string2) || (string = node.getUserProperty("Java_" + string2)) == null || !this.m_Model.isWritable(string2)) continue;
                try {
                    beanMap.put(string2, (Object)string);
                }
                catch (Exception exception) {
                    m_Log.warn((Object)("Can't initialize property " + string2 + " of " + this.m_ClassName.getText()));
                }
            }
        }
    }

    @Override
    public void performFinish() {
        TableCellEditor tableCellEditor = this.m_Table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
            this.m_Table.removeEditor();
        }
        INodeHolder iNodeHolder = (INodeHolder)((Object)this.m_Wizard);
        Node node = iNodeHolder.getNode();
        JavaPage.removeOldProperties(node);
        node.setUserProperty("Java_ClassName", this.m_ClassName.getText());
        Map<Object, Object> map = this.m_Model.getMap();
        for (Object object : map.keySet()) {
            if (!this.m_Model.isWritable((String)object)) continue;
            Object object2 = map.get(object);
            object = "Java_" + (String)object;
            if (object2 == null || object2 instanceof String) {
                node.setUserProperty((String)object, (String)object2);
                continue;
            }
            if (object2 instanceof DataStore) continue;
            node.setUserProperty((String)object, String.valueOf(object2));
        }
    }

    private static void removeOldProperties(Node node) {
        Map map = node.getUserProperties();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(map.keySet());
        for (String string : arrayList) {
            if (!string.startsWith("Java_")) continue;
            node.removeUserProperty(string);
        }
    }

    @Override
    public boolean isPageComplete() {
        IWizardContainer iWizardContainer;
        boolean bl = true;
        this.setError(null);
        String string = this.m_ClassName.getText();
        if (StringUtil.isEmpty(string)) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.JavaPage.CLASS_NAME_REQUIRED"));
            bl = false;
        } else {
            try {
                this.initBean(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.setError(I18N.ENSEMBLE.getString("DataStore.JavaPage.CLASS_NOT_FOUND"));
                bl = false;
            }
            catch (InstantiationException instantiationException) {
                this.setError(I18N.ENSEMBLE.getString("DataStore.JavaPage.CLASS_CANT_BE_CONSTRUCTED"));
                bl = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.setError(I18N.ENSEMBLE.getString("DataStore.JavaPage.CONSTRUCTOR_NOT_VISIBLE"));
                bl = false;
            }
            catch (ClassCastException classCastException) {
                this.setError(I18N.ENSEMBLE.getString("DataStore.JavaPage.DOESNT_IMPLEMENT_DATALISTENER"));
                bl = false;
            }
            catch (Exception exception) {
                this.setError(Bundle.ARCH.getString("Error") + ": " + exception.getLocalizedMessage());
                bl = false;
            }
        }
        if (this.m_Wizard != null && (iWizardContainer = this.m_Wizard.getContainer()) != null) {
            iWizardContainer.updateMessage();
        }
        return bl;
    }

    protected void initBean(String string) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = Class.forName(string, true, classLoader);
        Object obj = clazz.newInstance();
        DataListener dataListener = (DataListener)obj;
        this.m_Model.setBean(dataListener);
    }
}

