/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datastore;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.datastore.INodeHolder;
import com.elixirtech.ensemble.wizard.datastore.TypePage;
import com.elixirtech.remote.MongoConnectionPool;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class MongoDBPage
extends TypePage {
    private JComboBox<String> m_Pool;
    private JTextField m_Collection;

    public MongoDBPage() {
        super("MongoDB");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DataStore.MongoDBPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        Node node = ((INodeHolder)((Object)this.m_Wizard)).getNode();
        this.m_Pool = new JComboBox();
        this.m_Pool.setName("pool");
        this.m_Collection = SwingFactory.newTextField("collection");
        if (node != null) {
            this.m_Pool.setSelectedItem(node.getUserProperty("MongoDB_Pool"));
            this.m_Collection.setText(node.getUserProperty("MongoDB_Collection"));
        }
        FieldWatcher fieldWatcher = new FieldWatcher(iWizard);
        this.m_Pool.addItemListener(fieldWatcher);
        this.m_Collection.getDocument().addDocumentListener(fieldWatcher);
        this.m_Component.add(SwingFactory.newLabel("pool-label"));
        this.m_Component.add(SwingFactory.newLabel("collection-label"));
        this.m_Component.add(this.m_Pool);
        this.m_Component.add(this.m_Collection);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (String string : MongoConnectionPool.getPoolNamesJ()) {
            defaultComboBoxModel.addElement(string);
        }
        this.m_Pool.setModel(defaultComboBoxModel);
        I18N.ENSEMBLE_MAP.injectComponents("DataStore.MongoDBPage.", this.m_Component);
        this.positionComponents();
    }

    @Override
    public boolean isPageComplete() {
        boolean bl = true;
        this.setError(null);
        if (StringUtil.isEmpty((String)this.m_Collection.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.COLLECTION_REQUIRED"));
            bl = false;
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    private void positionComponents() {
        this.stickLeft("pool-label");
        this.vCenter("pool-label", "pool");
        this.putRight("pool", "pool-label,collection-label", 10);
        this.stickTop("pool");
        this.stickRight("pool");
        this.stickLeft("collection-label");
        this.vCenter("collection-label", "collection");
        this.alignBelow("collection", "pool");
        this.stickRight("collection");
    }

    @Override
    public void performFinish() {
        INodeHolder iNodeHolder = (INodeHolder)((Object)this.m_Wizard);
        Node node = iNodeHolder.getNode();
        node.setUserProperty("MongoDB_Pool", this.m_Pool.getSelectedItem().toString());
        node.setUserProperty("MongoDB_Collection", this.m_Collection.getText());
    }
}

