/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datastore;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.ds.DSUtil2;
import com.elixirtech.ensemble.wizard.datastore.CheckFileAccess;
import com.elixirtech.ensemble.wizard.datastore.DataStoreWizard;
import com.elixirtech.ensemble.wizard.datastore.INodeHolder;
import com.elixirtech.ensemble.wizard.datastore.TypePage;
import com.elixirtech.ui.FileSaveDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.FileUtil;
import com.elixirtech.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TextPage
extends TypePage
implements ActionListener {
    private JTextField m_Filename = SwingFactory.newTextField("name");
    private JButton m_Dots = SwingFactory.newDotsButton("dots", this);
    private JCheckBox m_Append = SwingFactory.newCheckBox("append");
    private JTextArea m_StartData = new JTextArea();
    private JTextArea m_StartGroup = new JTextArea();
    private JTextArea m_Record = new JTextArea();
    private JTextArea m_EndGroup = new JTextArea();
    private JTextArea m_EndData = new JTextArea();

    public TextPage() {
        super("Text File");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DataStore.TextPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        Node node = ((INodeHolder)((Object)this.m_Wizard)).getNode();
        this.m_Dots.setEnabled(!iWizard.isReadOnly() && !DSUtil2.isRemote());
        this.m_Component.add(SwingFactory.newLabel("name-label"));
        this.m_Component.add(this.m_Filename);
        this.m_Component.add(this.m_Dots);
        this.m_Component.add(this.m_Append);
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.m_Component.add("tabs", jTabbedPane);
        this.m_Layout.stickTop("name");
        this.m_Layout.stickLeft("name-label");
        this.m_Layout.vCenter("name-label", "name");
        this.m_Layout.vCenter("dots", "name");
        this.m_Layout.vCenter("append", "name");
        this.m_Layout.putRight("name", "name-label", 10);
        this.m_Layout.stickRight("append");
        this.m_Layout.putLeft("dots", "append", -5);
        this.m_Layout.putLeft("name", "dots");
        this.m_Layout.setHeight("dots", "name");
        this.m_Layout.putBelow("tabs", "name");
        this.m_Layout.stickLeft("tabs");
        this.m_Layout.stickRight("tabs");
        this.m_Layout.stickBottom("tabs");
        this.addTab(jTabbedPane, "DataStore.TextPage.StartData", this.m_StartData);
        this.addTab(jTabbedPane, "DataStore.TextPage.StartGroup", this.m_StartGroup);
        this.addTab(jTabbedPane, "DataStore.TextPage.ProcessRecord", this.m_Record);
        this.addTab(jTabbedPane, "DataStore.TextPage.EndGroup", this.m_EndGroup);
        this.addTab(jTabbedPane, "DataStore.TextPage.EndData", this.m_EndData);
        I18N.ENSEMBLE_MAP.injectComponents("DataStore.TextPage.", this.m_Component);
        if (node != null) {
            this.initComponents(node);
        }
        this.m_Filename.getDocument().addDocumentListener(new FieldWatcher(iWizard));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        FileSaveDialog fileSaveDialog = new FileSaveDialog();
        fileSaveDialog.removeChoosableFileFilter(fileSaveDialog.getAcceptAllFileFilter());
        fileSaveDialog.setFilter("txt", I18N.ENSEMBLE.getString("DataStore.TextPage.TXTFiles"));
        if (fileSaveDialog.showSaveDialog(this.m_Component) == 0) {
            this.m_Filename.setText(FileUtil.asURL(fileSaveDialog.getSelectedFile()));
        }
    }

    private void addTab(JTabbedPane jTabbedPane, String string, JComponent jComponent) {
        jTabbedPane.addTab(I18N.ENSEMBLE.getString(string), new JScrollPane(jComponent));
    }

    private void initComponents(Node node) {
        assert (node != null);
        this.m_Filename.setText(node.getUserProperty("display"));
        this.m_Append.setSelected(node.isUserProperty("Text_Append"));
        this.m_StartData.setText(node.getUserProperty("Text_StartData"));
        this.m_StartGroup.setText(node.getUserProperty("Text_StartGroup"));
        this.m_Record.setText(node.getUserProperty("Text_ProcessRecord"));
        this.m_EndGroup.setText(node.getUserProperty("Text_EndGroup"));
        this.m_EndData.setText(node.getUserProperty("Text_EndData"));
    }

    @Override
    public boolean isPageComplete() {
        boolean bl = true;
        this.setError(null);
        if (StringUtil.isEmpty(this.m_Filename.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.URL_REQUIRED"));
            bl = false;
        } else if (!CheckFileAccess.isOk(this.m_Filename.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.INVALID_FILE_LOCATION"));
            bl = false;
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    @Override
    public void performFinish() {
        INodeHolder iNodeHolder = (INodeHolder)((Object)this.m_Wizard);
        Node node = iNodeHolder.getNode();
        node.setUserProperty("display", this.m_Filename.getText());
        node.setUserProperty("Text_Filename", DataStoreWizard.ensureURL(this.m_Filename.getText()));
        node.setUserProperty("Text_Append", this.m_Append.isSelected());
        node.setUserProperty("Text_StartData", this.m_StartData.getText());
        node.setUserProperty("Text_StartGroup", this.m_StartGroup.getText());
        node.setUserProperty("Text_ProcessRecord", this.m_Record.getText());
        node.setUserProperty("Text_EndGroup", this.m_EndGroup.getText());
        node.setUserProperty("Text_EndData", this.m_EndData.getText());
    }
}

