/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datastore;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.ui.ViewablePasswordField;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.ds.DSUtil2;
import com.elixirtech.ensemble.wizard.datastore.CheckFileAccess;
import com.elixirtech.ensemble.wizard.datastore.DataStoreWizard;
import com.elixirtech.ensemble.wizard.datastore.INodeHolder;
import com.elixirtech.ensemble.wizard.datastore.TypePage;
import com.elixirtech.ui.FileSaveDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.FileUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class XLSXPage
extends TypePage
implements ActionListener {
    private JTextField m_URL;
    private JButton m_Dots;
    private JSpinner m_SheetGroupLevel;
    private JCheckBox m_FirstRowHeader;
    private JTextField m_SheetName;
    private ViewablePasswordField m_Password;

    public XLSXPage() {
        super("XLSX File");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DataStore.XLSXPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        Node node = ((INodeHolder)((Object)this.m_Wizard)).getNode();
        this.m_URL = SwingFactory.newTextField("url");
        this.m_Dots = SwingFactory.newDotsButton("dots", this);
        this.m_Dots.setEnabled(!iWizard.isReadOnly() && !DSUtil2.isRemote());
        int n = 0;
        if (node != null) {
            String string = node.getUserProperty("XLSX_SheetGroupLevel");
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_SheetGroupLevel = new JSpinner(new SpinnerNumberModel(n, 0, 999, 1));
        this.m_SheetGroupLevel.setName("group");
        this.m_FirstRowHeader = SwingFactory.newCheckBox("header");
        this.m_SheetName = SwingFactory.newTextField("sheet");
        this.m_Password = new ViewablePasswordField();
        this.m_Password.setName("password");
        if (node != null) {
            this.m_URL.setText(node.getUserProperty("display"));
            this.m_FirstRowHeader.setSelected(node.isUserProperty("XLSX_FirstRowHeader"));
            this.m_SheetName.setText(node.getUserProperty("XLSX_SheetName"));
            this.m_Password.setText(node.getUserProperty("XLSX_Password"));
        }
        this.m_URL.getDocument().addDocumentListener(new FieldWatcher(iWizard));
        this.m_Component.add(SwingFactory.newLabel("url-label"));
        this.m_Component.add(this.m_URL);
        this.m_Component.add(this.m_Dots);
        this.m_Component.add(SwingFactory.newLabel("group-label"));
        this.m_Component.add(this.m_SheetGroupLevel);
        this.m_Component.add(this.m_FirstRowHeader);
        this.m_Component.add(SwingFactory.newLabel("sheet-label"));
        this.m_Component.add(this.m_SheetName);
        this.m_Component.add(SwingFactory.newLabel("password-label"));
        this.m_Component.add(this.m_Password);
        I18N.ENSEMBLE_MAP.injectComponents("DataStore.XLSXPage.", this.m_Component);
        this.positionComponents();
    }

    private void positionComponents() {
        this.m_Layout.stickLeft("url-label");
        this.m_Layout.vCenter("url-label", "url");
        this.m_Layout.stickLeft("group-label");
        this.m_Layout.vCenter("group-label", "group");
        this.m_Layout.stickLeft("sheet-label");
        this.m_Layout.vCenter("sheet-label", "sheet");
        this.m_Layout.stickLeft("password-label");
        this.m_Layout.vCenter("password-label", "password");
        this.m_Layout.putRight("url", "url-label,group-label,sheet-label,password-label", 10);
        this.m_Layout.stickTop("url");
        this.m_Layout.putLeft("url", "dots");
        this.m_Layout.stickRight("dots");
        this.m_Layout.stickTop("dots");
        this.m_Layout.setHeight("dots", "url");
        this.m_Layout.alignBelow("sheet", "url");
        this.m_Layout.stickRight("sheet");
        this.m_Layout.alignBelow("password", "sheet");
        this.m_Layout.stickRight("password");
        this.m_Layout.alignBelow("group", "password");
        this.m_Layout.putRight("header", "group", 20);
        this.m_Layout.putBelow("header", "password", 2);
    }

    @Override
    public boolean isPageComplete() {
        boolean bl = true;
        this.setError(null);
        if (StringUtil.isEmpty((String)this.m_URL.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.URL_REQUIRED"));
            bl = false;
        } else if (!CheckFileAccess.isOk(this.m_URL.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.INVALID_FILE_LOCATION"));
            bl = false;
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    @Override
    public void performFinish() {
        INodeHolder iNodeHolder = (INodeHolder)((Object)this.m_Wizard);
        Node node = iNodeHolder.getNode();
        node.setUserProperty("display", this.m_URL.getText());
        node.setUserProperty("XLSX_URL", DataStoreWizard.ensureURL(this.m_URL.getText()));
        node.setUserProperty("XLSX_SheetGroupLevel", String.valueOf(this.m_SheetGroupLevel.getValue()));
        node.setUserProperty("XLSX_SheetName", this.m_SheetName.getText());
        node.setUserProperty("XLSX_FirstRowHeader", this.m_FirstRowHeader.isSelected());
        node.setUserProperty("XLSX_Password", this.m_Password.getText());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        FileSaveDialog fileSaveDialog = new FileSaveDialog();
        fileSaveDialog.removeChoosableFileFilter(fileSaveDialog.getAcceptAllFileFilter());
        fileSaveDialog.setFilter("xls", I18N.ENSEMBLE.getString("DataStore.XLSXPage.XLSXFiles"));
        if (fileSaveDialog.showSaveDialog(this.m_Component) == 0) {
            this.m_URL.setText(FileUtil.asURL(fileSaveDialog.getSelectedFile()));
        }
    }
}

