/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datastore;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.datastore.CheckFileAccess;
import com.elixirtech.ensemble.wizard.datastore.DataStoreWizard;
import com.elixirtech.ensemble.wizard.datastore.INodeHolder;
import com.elixirtech.ensemble.wizard.datastore.TypePage;
import com.elixirtech.ui.FileLoadDialog;
import com.elixirtech.ui.FileSaveDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.FileUtil;
import com.elixirtech.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class XMLPage
extends TypePage
implements ActionListener {
    private JTextField m_URL;
    private JTextField m_XSLT;
    private JButton m_Dots1;
    private JButton m_Dots2;
    private JCheckBox m_Indent;

    public XMLPage() {
        super("XML File");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DataStore.XMLPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        Node node = ((INodeHolder)((Object)this.m_Wizard)).getNode();
        this.m_URL = SwingFactory.newTextField("url");
        this.m_Dots1 = SwingFactory.newDotsButton("dots1", this);
        this.m_XSLT = SwingFactory.newTextField("xslt");
        this.m_Dots2 = SwingFactory.newDotsButton("dots2", this);
        this.m_Indent = SwingFactory.newCheckBox("indent");
        if (node != null) {
            this.m_URL.setText(node.getUserProperty("display"));
            this.m_XSLT.setText(node.getUserProperty("XML_XSLT"));
            this.m_Indent.setSelected(node.isUserProperty("XML_Indent"));
        }
        this.m_URL.getDocument().addDocumentListener(new FieldWatcher(iWizard));
        this.m_Component.add(SwingFactory.newLabel("url-label"));
        this.m_Component.add(this.m_URL);
        this.m_Component.add(this.m_Dots1);
        this.m_Component.add(SwingFactory.newLabel("xslt-label"));
        this.m_Component.add(this.m_XSLT);
        this.m_Component.add(this.m_Dots2);
        this.m_Component.add(this.m_Indent);
        I18N.ENSEMBLE_MAP.injectComponents("DataStore.XMLPage.", this.m_Component);
        this.positionComponents();
    }

    private void positionComponents() {
        this.m_Layout.stickLeft("url-label");
        this.m_Layout.vCenter("url-label", "url");
        this.m_Layout.putRight("url", "url-label,xslt-label", 10);
        this.m_Layout.stickTop("url");
        this.m_Layout.putLeft("url", "dots1");
        this.m_Layout.stickRight("dots1");
        this.m_Layout.stickTop("dots1");
        this.m_Layout.setHeight("dots1", "url");
        this.m_Layout.stickLeft("xslt-label");
        this.m_Layout.vCenter("xslt-label", "xslt");
        this.m_Layout.alignBelow("xslt", "url");
        this.m_Layout.putLeft("xslt", "dots2");
        this.m_Layout.stickRight("dots2");
        this.m_Layout.putBelow("dots2", "dots1");
        this.m_Layout.setHeight("dots2", "xslt");
        this.m_Layout.alignBelow("indent", "xslt");
    }

    @Override
    public boolean isPageComplete() {
        boolean bl = true;
        this.setError(null);
        if (StringUtil.isEmpty(this.m_URL.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.URL_REQUIRED"));
            bl = false;
        } else if (!CheckFileAccess.isOk(this.m_URL.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.INVALID_FILE_LOCATION"));
            bl = false;
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    @Override
    public void performFinish() {
        INodeHolder iNodeHolder = (INodeHolder)((Object)this.m_Wizard);
        Node node = iNodeHolder.getNode();
        node.setUserProperty("display", this.m_URL.getText());
        node.setUserProperty("XML_URL", DataStoreWizard.ensureURL(this.m_URL.getText()));
        node.setUserProperty("XML_XSLT", DataStoreWizard.ensureURL(this.m_XSLT.getText()));
        node.setUserProperty("XML_Indent", this.m_Indent.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        boolean bl2 = bl = actionEvent.getSource() == this.m_Dots1;
        if (bl) {
            FileSaveDialog fileSaveDialog = new FileSaveDialog();
            fileSaveDialog.removeChoosableFileFilter(fileSaveDialog.getAcceptAllFileFilter());
            fileSaveDialog.setFilter("ds", I18N.ENSEMBLE.getString("DataStore.XMLPage.XMLFiles"));
            if (fileSaveDialog.showSaveDialog(this.m_Component) == 0) {
                this.m_URL.setText(FileUtil.asURL(fileSaveDialog.getSelectedFile()));
            }
        } else {
            FileLoadDialog fileLoadDialog = new FileLoadDialog();
            fileLoadDialog.setFilter("xslt", I18N.ENSEMBLE.getString("DataStore.XMLPage.XSLTFiles"));
            if (fileLoadDialog.showOpenDialog(this.m_Component) == 0) {
                this.m_XSLT.setText(FileUtil.asURL(fileLoadDialog.getSelectedFile()));
            }
        }
    }
}

