/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.derivative;

import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.derivative.DerivativeSchemaPanel;
import com.elixirtech.ui.ClipboardUtil;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.datasource.ColumnDialog;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DerivativeColumnDialog
extends ColumnDialog<DerivativeSchemaPanel.DerivedSchemaColumn> {
    DataSchema m_BaseSchema;
    JTextField m_Value;
    JList m_AvailableFields;

    public DerivativeColumnDialog(JFrame jFrame, String string, DerivativeSchemaPanel.DerivedSchemaColumn derivedSchemaColumn, DataSchema dataSchema) {
        super(jFrame, string, derivedSchemaColumn);
        this.m_BaseSchema = dataSchema;
        this.m_AvailableFields.setModel(this.getAvailableFields());
    }

    @Override
    protected JPanel buildUI() {
        JPanel jPanel = super.buildUI();
        jPanel.add(SwingFactory.newLabel("value-label"));
        this.m_Value = SwingFactory.newTextField("value", 32);
        jPanel.add(this.m_Value);
        jPanel.add(SwingFactory.newLabel("fields-label"));
        this.m_AvailableFields = SwingFactory.newList();
        this.m_AvailableFields.addMouseListener(new ML());
        this.m_AvailableFields.setToolTipText(I18N.ENSEMBLE.getString("DerivativeColumnDialog.TIP"));
        jPanel.add(SwingFactory.newScrollPane("fields", this.m_AvailableFields));
        DerivativeSchemaPanel.DerivedSchemaColumn derivedSchemaColumn = (DerivativeSchemaPanel.DerivedSchemaColumn)this.m_Group;
        this.m_Value.setText(derivedSchemaColumn.value);
        I18N.ENSEMBLE_MAP.injectComponents("DerivativeColumnDialog.", jPanel);
        jPanel.setPreferredSize(new Dimension(200, 200));
        return jPanel;
    }

    @Override
    protected void setupConstraints() {
        this.m_Layout.stickLeft("name-label");
        this.m_Layout.vCenter("name-label", "name");
        this.m_Layout.stickLeft("data-type-label");
        this.m_Layout.vCenter("data-type-label", "data-type");
        this.m_Layout.stickLeft("value-label");
        this.m_Layout.vCenter("value-label", "value");
        this.m_Layout.putRight("name", "name-label,data-type-label,value-label,fields-label", 10);
        this.m_Layout.stickRight("name");
        this.m_Layout.stickTop("name");
        this.m_Layout.alignBelow("data-type", "name", 5);
        this.m_Layout.stickRight("data-type");
        this.m_Layout.alignBelow("value", "data-type", 5);
        this.m_Layout.stickRight("value");
        this.m_Layout.stickLeft("fields-label");
        this.m_Layout.alignBelow("fields", "value", 5);
        this.m_Layout.vCenter("fields-label", "fields");
        this.m_Layout.stickRight("fields");
        this.m_Layout.stickBottom("fields");
    }

    @Override
    public void ok() {
        ((DerivativeSchemaPanel.DerivedSchemaColumn)this.m_Group).value = this.m_Value.getText();
        super.ok();
    }

    private DefaultListModel getAvailableFields() {
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        if (this.m_BaseSchema != null) {
            int n = this.m_BaseSchema.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.m_BaseSchema.getColumnName(i);
                if (!StringUtil.notEmpty((String)object)) continue;
                char c = ((String)object).charAt(0);
                if (!Character.isJavaIdentifierStart(c)) {
                    object = "_" + (String)object;
                }
                if (!DerivativeColumnDialog.isValidJavaName((String)object)) {
                    object = "this[\"" + (String)object + "\"]";
                }
                defaultListModel.addElement(object);
            }
        }
        return defaultListModel;
    }

    private static boolean isValidJavaName(String string) {
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private class ML
    extends MouseAdapter {
        private ML() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            String string;
            if (mouseEvent.getClickCount() == 2 && StringUtil.notEmpty(string = (String)DerivativeColumnDialog.this.m_AvailableFields.getSelectedValue())) {
                ClipboardUtil.setText(string);
                DerivativeColumnDialog.this.m_Value.paste();
                DerivativeColumnDialog.this.m_Value.requestFocus();
            }
        }
    }
}

