/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.derivative;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.DerivativeGO;
import com.elixirtech.ensemble.canvas.DerivedNode;
import com.elixirtech.ensemble.canvas.GOUtil;
import com.elixirtech.ensemble.wizard.derivative.BaseSchemaPanel;
import com.elixirtech.ensemble.wizard.derivative.DerivativeSchemaPanel;
import com.elixirtech.ensemble.wizard.derivative.JSPanel;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.wizard.GOFirstPage;
import java.util.Set;
import javax.swing.JTabbedPane;

class DerivativePage
extends GOFirstPage<DerivativeGO> {
    private ResultSchemaPanel m_BasePanel;
    private DerivativeSchemaPanel m_DerivedPanel;
    private JSPanel m_JSPanel;

    public DerivativePage(DerivativeGO derivativeGO) {
        super(derivativeGO, "Derivative", "<dynamic>");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DerivativePage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        JTabbedPane jTabbedPane = SwingFactory.newTabbedPane("tabs");
        this.m_BasePanel = new BaseSchemaPanel(this);
        DataSchema dataSchema = ((DerivativeGO)this.m_GO).getBaseSchema();
        if (dataSchema != null) {
            Set set = GOUtil.getDiscardSet((Node)this.m_GO, (String)"Derivative_Discard");
            this.m_BasePanel.setSchema(dataSchema, set);
        } else {
            this.setError(I18N.ENSEMBLE.getString("DerivativePage.CANT_READ_SCHEMA"));
        }
        jTabbedPane.addTab(I18N.ENSEMBLE.getString("DerivativePage.BASE"), this.m_BasePanel);
        this.m_DerivedPanel = new DerivativeSchemaPanel();
        this.m_DerivedPanel.setBaseSchema(dataSchema);
        int n = ((DerivativeGO)this.m_GO).getDerivativeCount();
        for (int i = 0; i < n; ++i) {
            DerivedNode derivedNode = ((DerivativeGO)this.m_GO).getDerivative(i);
            DerivativeSchemaPanel.DerivedSchemaColumn derivedSchemaColumn = new DerivativeSchemaPanel.DerivedSchemaColumn();
            derivedSchemaColumn.name = derivedNode.getName();
            derivedSchemaColumn.type = derivedNode.getType();
            derivedSchemaColumn.value = derivedNode.getValue();
            this.m_DerivedPanel.addColumn(derivedSchemaColumn);
        }
        jTabbedPane.addTab(I18N.ENSEMBLE.getString("DerivativePage.DERIVED"), this.m_DerivedPanel);
        this.m_JSPanel = new JSPanel();
        this.m_JSPanel.setText(((DerivativeGO)this.m_GO).getUserProperty("Derivative_JavaScript"));
        jTabbedPane.addTab(I18N.ENSEMBLE.getString("DerivativePage.JAVASCRIPT"), this.m_JSPanel);
        this.m_Component.add(jTabbedPane);
        I18N.ENSEMBLE_MAP.injectComponents("DerivativePage.", this.m_Component);
        this.positionComponents();
    }

    public void addDerivativeFrom(ResultSchemaPanel.SchemaColumn schemaColumn) {
        if (!this.m_DerivedPanel.getNames().contains(schemaColumn.name)) {
            DerivativeSchemaPanel.DerivedSchemaColumn derivedSchemaColumn = new DerivativeSchemaPanel.DerivedSchemaColumn();
            derivedSchemaColumn.name = schemaColumn.name;
            derivedSchemaColumn.type = schemaColumn.type;
            derivedSchemaColumn.value = "";
            this.m_DerivedPanel.addColumn(derivedSchemaColumn);
        }
    }

    private void positionComponents() {
        this.putRight("GOFirstPage.name", "GOFirstPage.name-label", 10);
        this.putBelow("tabs", "GOFirstPage.name", 10);
        this.stickLeft("tabs");
        this.stickRight("tabs");
        this.stickBottom("tabs");
    }

    @Override
    public void performFinish() {
        super.performFinish();
        this.m_DerivedPanel.disposeEditor();
        GOUtil.setDiscardSet((Node)this.m_GO, (String)"Derivative_Discard", this.m_BasePanel.getDiscardSet());
        int n = this.m_DerivedPanel.getColumnCount();
        ((DerivativeGO)this.m_GO).removeAllDerivatives();
        for (int i = 0; i < n; ++i) {
            DerivativeSchemaPanel.DerivedSchemaColumn derivedSchemaColumn = (DerivativeSchemaPanel.DerivedSchemaColumn)this.m_DerivedPanel.getColumn(i);
            ((DerivativeGO)this.m_GO).addDerivative(derivedSchemaColumn.name, derivedSchemaColumn.type, derivedSchemaColumn.value, derivedSchemaColumn.attrs);
        }
        ((DerivativeGO)this.m_GO).setUserProperty("Derivative_JavaScript", this.m_JSPanel.getText());
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    public IWizardPage getNextPage() {
        return null;
    }

    @Override
    public boolean isPageComplete() {
        return ((DerivativeGO)this.m_GO).getSchema() != null;
    }
}

