/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.filter;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.filter.IDataSetProviderTab;
import com.elixirtech.ui.EscapableDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.CodeBlock;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class DataSetChooser
extends EscapableDialog {
    private IDataSetProviderTab[] m_TabProviders;
    private ArchLayout m_Layout;
    private JTextField m_URL;
    private JTabbedPane m_Tabs;
    private JButton m_Ok;
    private JButton m_Cancel;
    private boolean m_IsOk;

    public DataSetChooser(JFrame jFrame, String string, IDataSetProviderTab[] iDataSetProviderTabArray) {
        super(jFrame, I18N.ENSEMBLE.getString("DataSetChooser.TITLE"), true);
        int n;
        this.m_TabProviders = iDataSetProviderTabArray;
        this.m_Layout = new ArchLayout();
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(this.m_Layout);
        jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_URL = SwingFactory.newTextField("url");
        this.m_URL.setText(string);
        this.m_Tabs = SwingFactory.newTabbedPane("tabs");
        for (n = 0; n < this.m_TabProviders.length; ++n) {
            this.m_Tabs.addTab(this.m_TabProviders[n].getTabName(), this.m_TabProviders[n].getComponent());
            this.m_TabProviders[n].setURLField(this.m_URL);
            this.m_TabProviders[n].setURL(string);
        }
        for (n = 0; n < this.m_TabProviders.length; ++n) {
            if (!this.m_TabProviders[n].isValidURL(string)) continue;
            this.m_Tabs.setSelectedIndex(n);
            break;
        }
        this.m_URL.getDocument().addDocumentListener(new CodeBlock((Object)this, "updateTabs"));
        this.m_Ok = SwingFactory.newOkButton(new CodeBlock((Object)this, "ok"));
        this.m_Cancel = SwingFactory.newCancelButton(new CodeBlock((Object)this, "cancel"));
        jComponent.add(SwingFactory.newLabel("url-label"));
        jComponent.add(this.m_URL);
        jComponent.add(this.m_Tabs);
        jComponent.add(this.m_Ok);
        jComponent.add(this.m_Cancel);
        I18N.ENSEMBLE_MAP.injectComponents("DataSetChooser.", jComponent);
        this.layoutComponents();
        this.setSize(new Dimension(500, 400));
        this.setLocationRelativeTo(jFrame);
    }

    private void layoutComponents() {
        this.m_Layout.stickTop("url");
        this.m_Layout.stickRight("url");
        this.m_Layout.stickLeft("url-label");
        this.m_Layout.vCenter("url-label", "url");
        this.m_Layout.putRight("url", "url-label", 10);
        this.m_Layout.stickLeft("tabs");
        this.m_Layout.stickRight("tabs");
        this.m_Layout.putBelow("tabs", "url");
        this.m_Layout.putAbove("tabs", "SwingFactory.Ok", 5);
        this.m_Layout.stickBottom("SwingFactory.Ok");
        this.m_Layout.stickBottom("SwingFactory.Cancel");
        this.m_Layout.stickRight("SwingFactory.Cancel");
        this.m_Layout.putLeft("SwingFactory.Ok", "SwingFactory.Cancel", -10);
    }

    public void updateTabs() {
        String string = this.m_URL.getText();
        for (int i = 0; i < this.m_TabProviders.length; ++i) {
            this.m_TabProviders[i].setURL(string);
        }
    }

    public void ok() {
        this.m_IsOk = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.m_TabProviders.length; ++i) {
            this.m_TabProviders[i].dispose();
        }
        super.dispose();
    }

    public boolean isOk() {
        return this.m_IsOk;
    }

    public String getSelection() {
        return this.m_URL.getText();
    }
}

