/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.filter;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.attributes.Enumeration;
import com.elixirtech.data2.datasource.filter.FilteredDataSource;
import com.elixirtech.data2.datasource.filter.When;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.FilterGO;
import com.elixirtech.ensemble.canvas.FilterNode;
import com.elixirtech.ensemble.ds.DSPanel;
import com.elixirtech.ensemble.wizard.filter.FilterColumn;
import com.elixirtech.ensemble.wizard.filter.FilterSchemaPanel;
import com.elixirtech.ensemble.wizard.filter.JSPanel;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.GOFirstPage;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTabbedPane;

class FilterPage
extends GOFirstPage<FilterGO> {
    private FilterSchemaPanel m_FilterPanel0 = new FilterSchemaPanel();
    private FilterSchemaPanel m_FilterPanel1 = new FilterSchemaPanel();
    private FilterSchemaPanel m_FilterPanel2 = new FilterSchemaPanel();
    private JSPanel m_JSPanel;
    FilterSchemaPanel.IValueProvider m_ValueProvider = new VP();

    public FilterPage(FilterGO filterGO) {
        super(filterGO, "Filter", null);
        I18N.ENSEMBLE_MAP.injectObject(null, this, "FilterPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addChangeListener(new CodeBlock((Object)this, "tabChanged"));
        DataSchema dataSchema = ((FilterGO)this.m_GO).getSchema();
        if (dataSchema != null) {
            this.config(this.m_FilterPanel0, 0, dataSchema);
            this.config(this.m_FilterPanel1, 1, dataSchema);
            this.config(this.m_FilterPanel2, 2, dataSchema);
        } else {
            this.setError(I18N.ENSEMBLE.getString("FilterPage.CANT_READ_SCHEMA"));
        }
        jTabbedPane.addTab(I18N.ENSEMBLE.getString("FilterPage.FILTER_1"), this.m_FilterPanel0);
        jTabbedPane.addTab(I18N.ENSEMBLE.getString("FilterPage.FILTER_2"), this.m_FilterPanel1);
        jTabbedPane.addTab(I18N.ENSEMBLE.getString("FilterPage.FILTER_3"), this.m_FilterPanel2);
        this.m_JSPanel = new JSPanel();
        this.m_JSPanel.setText(((FilterGO)this.m_GO).getUserProperty("Filter_JavaScript"));
        jTabbedPane.addTab(I18N.ENSEMBLE.getString("FilterPage.JAVASCRIPT"), this.m_JSPanel);
        this.m_Component.add("tabs", jTabbedPane);
        this.putRight("GOFirstPage.name", "GOFirstPage.name-label", 10);
        this.putBelow("tabs", "GOFirstPage.name", 5);
        this.stickLeft("tabs");
        this.stickRight("tabs");
        this.stickBottom("tabs");
        I18N.ENSEMBLE_MAP.injectComponents("FilterPage", this.m_Component);
    }

    @Override
    public void performFinish() {
        super.performFinish();
        this.m_FilterPanel0.disposeEditor();
        this.m_FilterPanel1.disposeEditor();
        this.m_FilterPanel2.disposeEditor();
        ((FilterGO)this.m_GO).removeAllFilters();
        this.finish(this.m_FilterPanel0, 0);
        this.finish(this.m_FilterPanel1, 1);
        this.finish(this.m_FilterPanel2, 2);
        ((FilterGO)this.m_GO).setUserProperty("Filter_JavaScript", this.m_JSPanel.getText());
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    public IWizardPage getNextPage() {
        return null;
    }

    @Override
    public boolean isPageComplete() {
        return ((FilterGO)this.m_GO).getSchema() != null;
    }

    public void tabChanged() {
        this.m_FilterPanel0.disposeEditor();
        this.m_FilterPanel1.disposeEditor();
        this.m_FilterPanel2.disposeEditor();
    }

    private void config(FilterSchemaPanel filterSchemaPanel, int n, DataSchema dataSchema) {
        filterSchemaPanel.setSchema(dataSchema);
        filterSchemaPanel.setValueProvider(this.m_ValueProvider);
        int n2 = ((FilterGO)this.m_GO).getFilterCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            FilterNode filterNode = ((FilterGO)this.m_GO).getFilter(i);
            if (filterNode.getSetId() != n || (n3 = dataSchema.getColumnIndex(filterNode.getName())) < 0) continue;
            FilterColumn filterColumn = filterSchemaPanel.getColumn(n3);
            filterColumn.when = filterNode.getWhen();
            filterColumn.condition = filterNode.getValue();
        }
    }

    private void finish(FilterSchemaPanel filterSchemaPanel, int n) {
        int n2 = filterSchemaPanel.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            FilterColumn filterColumn = filterSchemaPanel.getColumn(i);
            if (filterColumn.when == When.NONE && filterColumn.condition.length() <= 0) continue;
            ((FilterGO)this.m_GO).addFilter(n, filterColumn.name, filterColumn.when, filterColumn.condition);
        }
    }

    private class VP
    implements FilterSchemaPanel.IValueProvider {
        private VP() {
        }

        @Override
        public Set<String> getChoices(String string) {
            IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
            DSPanel dSPanel = (DSPanel)iViewModel.getCurrentView();
            FilteredDataSource filteredDataSource = (FilteredDataSource)dSPanel.getDataSource(FilterPage.this.m_GO);
            IDataSource iDataSource = filteredDataSource.getParent();
            assert (iDataSource != null);
            DefaultPushContext defaultPushContext = new DefaultPushContext();
            try {
                HashSet<String> hashSet = new HashSet<String>();
                DataSchema dataSchema = iDataSource.getSchema();
                int n = dataSchema.getColumnIndex(string);
                if (n >= 0) {
                    Enumeration enumeration = (Enumeration)dataSchema.getAttribute(n, Enumeration.class);
                    if (enumeration != null) {
                        hashSet.addAll(enumeration.getChoices());
                    } else {
                        DataType dataType = dataSchema.getColumnType(n);
                        DataTable dataTable = DataTable.build((PushContext)defaultPushContext, (IDataSource)iDataSource);
                        Object[] objectArray = dataTable.getUniqueValues(n);
                        for (int i = 0; i < objectArray.length; ++i) {
                            hashSet.add(dataSchema.format(dataType, objectArray[i]));
                        }
                    }
                }
                return hashSet;
            }
            catch (RuntimeException runtimeException) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18N.ENSEMBLE.getString("FilterPage.CANT_READ_RECORDS"), (Throwable)runtimeException);
                return null;
            }
        }
    }
}

