/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.filter;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.datasource.filter.When;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.filter.DataSetChooser;
import com.elixirtech.ensemble.wizard.filter.FilterColumn;
import com.elixirtech.ensemble.wizard.filter.IDataSetProviderTab;
import com.elixirtech.ensemble.wizard.filter.RepositoryFieldTab;
import com.elixirtech.ensemble.wizard.filter.WhenRenderer;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.TableUtil;
import com.elixirtech.ui.table.BasicTableEditor;
import com.elixirtech.ui.table.ElxTable;
import com.elixirtech.ui.table.ElxTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FilterSchemaPanel
extends JPanel {
    protected ColumnModel m_ColumnModel;
    protected JTable m_ColumnTable;
    protected JButton m_EditColumn;
    protected IDataSetProviderTab[] m_DataSetProviderTabs;
    protected IValueProvider m_ValueProvider;
    private static final String[] COLUMNS = new String[]{"TableModel.Column", "TableModel.Name", "TableModel.Type", "TableModel.When", "TableModel.Condition"};

    public FilterSchemaPanel() {
        this.setLayout(new BorderLayout());
        this.m_ColumnModel = new ColumnModel();
        this.m_ColumnTable = new JTableEx(this.m_ColumnModel);
        this.m_ColumnTable.setSelectionMode(0);
        JComboBox<When> jComboBox = new JComboBox<When>(When.getAll());
        jComboBox.setRenderer(new WhenRenderer());
        jComboBox.setFont(UIManager.getFont("Tree.font"));
        this.m_ColumnTable.setDefaultRenderer(When.class, new WhenTableRenderer());
        this.m_ColumnTable.setDefaultEditor(When.class, new DefaultCellEditor(jComboBox));
        TableColumn tableColumn = this.m_ColumnTable.getColumnModel().getColumn(0);
        TableUtil.setColumnWidth(this.m_ColumnTable, tableColumn, I18N.ENSEMBLE, COLUMNS[0], 10);
        this.add((Component)new JScrollPane(this.m_ColumnTable), "Center");
        this.m_DataSetProviderTabs = new IDataSetProviderTab[1];
        this.m_DataSetProviderTabs[0] = new RepositoryFieldTab();
    }

    public void setIDataSetProviderTabs(IDataSetProviderTab[] iDataSetProviderTabArray) {
        this.m_DataSetProviderTabs = iDataSetProviderTabArray;
    }

    public void setValueProvider(IValueProvider iValueProvider) {
        this.m_ValueProvider = iValueProvider;
    }

    public void disposeEditor() {
        TableCellEditor tableCellEditor = this.m_ColumnTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
            this.m_ColumnTable.removeEditor();
        }
    }

    public DataSchema getSchema(String string, String string2, String string3) {
        int n = this.m_ColumnModel.getRowCount();
        String[] stringArray = new String[n];
        DataType[] dataTypeArray = new DataType[n];
        for (int i = 0; i < n; ++i) {
            FilterColumn filterColumn = this.m_ColumnModel.getColumn(i);
            stringArray[i] = filterColumn.name;
            dataTypeArray[i] = filterColumn.type;
        }
        DataSchema dataSchema = new DataSchema(true, stringArray, dataTypeArray);
        if (string != null && string.length() > 0) {
            dataSchema.setDateFormat(string);
        }
        if (string2 != null && string2.length() > 0) {
            dataSchema.setTimeFormat(string2);
        }
        if (string3 != null && string3.length() > 0) {
            dataSchema.setDateFormat(string3);
        }
        return dataSchema;
    }

    public void setSchema(DataSchema dataSchema) {
        this.m_ColumnModel.removeAll();
        int n = dataSchema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            FilterColumn filterColumn = this.newColumn();
            filterColumn.name = dataSchema.getColumnName(i);
            filterColumn.type = dataSchema.getColumnType(i);
            this.m_ColumnModel.addColumn(filterColumn);
        }
        this.m_ColumnModel.fireTableDataChanged();
    }

    public int getColumnCount() {
        return this.m_ColumnModel.getRowCount();
    }

    public FilterColumn getColumn(int n) {
        return this.m_ColumnModel.getColumn(n);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_ColumnTable.setEnabled(bl);
    }

    protected FilterColumn newColumn() {
        return new FilterColumn();
    }

    protected Set<String> getChoices(String string) {
        return this.m_ValueProvider.getChoices(string);
    }

    protected ComboBoxModel getComboModel(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getChoices(string));
        Collections.sort(arrayList);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (String string2 : arrayList) {
            defaultComboBoxModel.addElement(string2);
        }
        return defaultComboBoxModel;
    }

    protected class ColumnModel
    extends ElxTableModel {
        private List<FilterColumn> m_Columns;

        public ColumnModel() {
            super(I18N.ENSEMBLE, COLUMNS);
            this.m_Columns = new ArrayList<FilterColumn>();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 3) {
                return When.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.m_Columns.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return n + 1;
            }
            FilterColumn filterColumn = this.getColumn(n);
            return filterColumn.getData(n2);
        }

        public void removeAll() {
            this.m_Columns.clear();
        }

        public void addColumn(FilterColumn filterColumn) {
            this.m_Columns.add(filterColumn);
        }

        public void updateColumn(FilterColumn filterColumn) {
            int n = this.m_Columns.indexOf(filterColumn);
            if (n >= 0) {
                this.fireTableRowsUpdated(n, n);
            }
        }

        public FilterColumn getColumn(int n) {
            return this.m_Columns.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 3 || n2 == 4;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 3 && object instanceof When) {
                FilterColumn filterColumn = this.getColumn(n);
                filterColumn.when = (When)object;
            } else if (n2 == 4 && object instanceof String) {
                FilterColumn filterColumn = this.getColumn(n);
                filterColumn.condition = (String)object;
            }
        }
    }

    private class JTableEx
    extends ElxTable {
        private List<FillInListener> m_FillInListeners = new ArrayList<FillInListener>();

        public JTableEx(TableModel tableModel) {
            this.setModel(tableModel);
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 4) {
                FilterColumn filterColumn = FilterSchemaPanel.this.m_ColumnModel.getColumn(n);
                if (filterColumn.when == When.IN_DATASET || filterColumn.when == When.NOT_IN_DATASET) {
                    return new InDataSetEditor();
                }
                if (filterColumn.when == When.SCRIPT || filterColumn.when == When.NOT_SCRIPT) {
                    JTextField jTextField = new JTextField();
                    jTextField.setBorder(null);
                    jTextField.setFont(UIManager.getFont("Tree.font"));
                    return new DefaultCellEditor(jTextField);
                }
                if (FilterSchemaPanel.this.m_ValueProvider != null) {
                    JComboBox jComboBox = new JComboBox();
                    jComboBox.setFont(UIManager.getFont("Tree.font"));
                    jComboBox.setEditable(true);
                    jComboBox.addPopupMenuListener(this.getFillInListener(n, filterColumn.name));
                    return new DefaultCellEditor(jComboBox);
                }
            }
            return super.getCellEditor(n, n2);
        }

        private FillInListener getFillInListener(int n, String string) {
            while (this.m_FillInListeners.size() < n + 1) {
                this.m_FillInListeners.add(null);
            }
            FillInListener fillInListener = this.m_FillInListeners.get(n);
            if (fillInListener == null) {
                fillInListener = new FillInListener(string);
                this.m_FillInListeners.set(n, fillInListener);
            }
            return fillInListener;
        }
    }

    private class WhenTableRenderer
    extends DefaultTableCellRenderer {
        public WhenTableRenderer() {
            this.setFont(UIManager.getFont("Tree.font"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = WhenRenderer.i18n(object);
            return super.getTableCellRendererComponent(jTable, String.valueOf(object2), bl, bl2, n, n2);
        }
    }

    public static interface IValueProvider {
        public Set<String> getChoices(String var1);
    }

    private class InDataSetEditor
    extends BasicTableEditor
    implements ActionListener {
        private JPanel m_Panel = new JPanel(new BorderLayout());
        private JTextField m_Text = new JTextField();
        private JButton m_Dots;

        public InDataSetEditor() {
            this.m_Text.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.m_Dots = SwingFactory.newDotsButton(this);
            this.m_Panel.add((Component)this.m_Text, "Center");
            this.m_Panel.add((Component)this.m_Dots, "East");
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_Text.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.m_Text.setText(String.valueOf(object));
            return this.m_Panel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.m_Text.setText(String.valueOf(object));
            return this.m_Panel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            DataSetChooser dataSetChooser = new DataSetChooser(elixirFrame.getFrame(), this.m_Text.getText(), FilterSchemaPanel.this.m_DataSetProviderTabs);
            elixirFrame.showModal(dataSetChooser);
            if (dataSetChooser.isOk()) {
                this.m_Text.setText(dataSetChooser.getSelection());
            }
        }
    }

    private class FillInListener
    implements PopupMenuListener {
        private String m_Name;
        private ComboBoxModel m_Model;

        public FillInListener(String string) {
            this.m_Name = string;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JComboBox jComboBox = (JComboBox)popupMenuEvent.getSource();
            if (this.m_Model == null) {
                this.m_Model = FilterSchemaPanel.this.getComboModel(this.m_Name);
            }
            jComboBox.setModel(this.m_Model);
            Accessible accessible = FilterSchemaPanel.this.getUI().getAccessibleChild(jComboBox, 0);
            if (!(accessible instanceof JPopupMenu)) {
                return;
            }
            JPopupMenu jPopupMenu = (JPopupMenu)accessible;
            jPopupMenu.invalidate();
            jPopupMenu.validate();
            JComponent jComponent = (JComponent)jPopupMenu.getComponent(0);
            Dimension dimension = new Dimension();
            dimension.width = Math.max(jComboBox.getSize().width, jComboBox.getPreferredSize().width);
            dimension.height = Math.max(jComponent.getPreferredSize().height, 125);
            jComponent.setPreferredSize(dimension);
            jComponent.setMaximumSize(dimension);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }
    }
}

