/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.filter;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.repository.RepositoryTree;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.filter.IDataSetProviderTab;
import com.elixirtech.util.StringUtil;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class RepositoryTab
extends JPanel
implements IDataSetProviderTab {
    private RepositoryTree m_RepositoryTree;
    private JTextField m_URL;
    private boolean m_UpdateInProgress;

    public RepositoryTab() {
        Repository repository = (Repository)Elixir.get(Repository.class);
        this.m_RepositoryTree = RepositoryTree.apply("RepositoryTab", repository, this.getFilter());
        this.m_RepositoryTree.addTreeSelectionListener(new TSL());
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.m_RepositoryTree));
    }

    @Override
    public String getTabName() {
        return I18N.ENSEMBLE.getString("RepositoryTab.TITLE");
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean isValidURL(String string) {
        return string != null && string.startsWith("repository:");
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_RepositoryTree.setEnabled(bl);
    }

    @Override
    public void setURL(String string) {
        this.m_UpdateInProgress = true;
        if (string != null && string.startsWith("repository:")) {
            String string2 = string.substring(11);
            String[] stringArray = StringUtil.arrayOfSubstrings(string2, ':');
            Repository repository = (Repository)Elixir.get(Repository.class);
            FileObject fileObject = (FileObject)repository.getFile(stringArray[0]).get();
            if (fileObject != null) {
                this.m_RepositoryTree.setSelectionJ(fileObject);
            }
        } else {
            this.m_RepositoryTree.clearSelection();
        }
        this.m_UpdateInProgress = false;
    }

    @Override
    public void setURLField(JTextField jTextField) {
        this.m_URL = jTextField;
    }

    public void updateURL() {
        FileObject fileObject = this.m_RepositoryTree.getSelectionJ();
        if (fileObject != null) {
            this.m_URL.setText("repository:" + String.valueOf(fileObject.getPath()));
        }
    }

    @Override
    public void dispose() {
        if (this.m_RepositoryTree != null) {
            this.m_RepositoryTree.dispose();
        }
    }

    protected FileType getFilter() {
        RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
        return repositoryExplorer.getFileTypeJ(MimeTypes.DS().value());
    }

    protected class TSL
    implements TreeSelectionListener {
        protected TSL() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (RepositoryTab.this.m_UpdateInProgress) {
                return;
            }
            FileObject fileObject = RepositoryTab.this.m_RepositoryTree.getSelectionJ();
            if (fileObject != null) {
                RepositoryTab.this.updateURL();
            }
        }
    }
}

