/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.join;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.ui.SwingFactory;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

class JoinOptions
extends JPanel
implements ItemListener {
    public static final String[] ZERO_ACTION_IDS = new String[]{"Keep", "Discard"};
    public static final String[] ZERO_ACTION_KEYS = new String[]{"JoinWizard.Zero.Keep", "JoinWizard.Zero.Discard"};
    public static final String[] MULTIPLE_ACTION_IDS = new String[]{"Keep", "Repeat", "Discard"};
    public static final String[] MULTIPLE_ACTION_KEYS = new String[]{"JoinWizard.Multiple.Keep", "JoinWizard.Multiple.Repeat", "JoinWizard.Multiple.Discard"};
    private JCheckBox m_CrossJoin;
    private I18NComboBox m_ZeroSecondary;
    private I18NComboBox m_MultipleSecondary;
    private JTextField m_PrimaryPrefix;
    private JTextField m_SecondaryPrefix;

    public JoinOptions() {
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        ArchLayout archLayout = new ArchLayout();
        this.setLayout(archLayout);
        this.m_CrossJoin = SwingFactory.newCheckBox("cross");
        this.m_CrossJoin.addItemListener(this);
        Name[] nameArray = I18NComboBox.buildModel(ZERO_ACTION_IDS, I18N.ENSEMBLE, ZERO_ACTION_KEYS);
        this.m_ZeroSecondary = I18NComboBox.apply(nameArray);
        this.m_ZeroSecondary.setName("zero");
        Name[] nameArray2 = I18NComboBox.buildModel(MULTIPLE_ACTION_IDS, I18N.ENSEMBLE, MULTIPLE_ACTION_KEYS);
        this.m_MultipleSecondary = I18NComboBox.apply(nameArray2);
        this.m_MultipleSecondary.setName("multiple");
        this.m_PrimaryPrefix = SwingFactory.newTextField("primary");
        this.m_SecondaryPrefix = SwingFactory.newTextField("secondary");
        this.add(this.m_CrossJoin);
        this.add(SwingFactory.newLabel("zero-label"));
        this.add(SwingFactory.newLabel("multiple-label"));
        this.add(this.m_ZeroSecondary);
        this.add(this.m_MultipleSecondary);
        this.add(SwingFactory.newLabel("primary-label"));
        this.add(this.m_PrimaryPrefix);
        this.add(SwingFactory.newLabel("secondary-label"));
        this.add(this.m_SecondaryPrefix);
        this.layoutComponents(archLayout);
    }

    private void layoutComponents(ArchLayout archLayout) {
        archLayout.stickLeft("cross");
        archLayout.stickTop("cross");
        archLayout.stickLeft("zero-label");
        archLayout.vCenter("zero-label", "zero");
        archLayout.stickLeft("multiple-label");
        archLayout.vCenter("multiple-label", "multiple");
        archLayout.putRight("zero", "zero-label,multiple-label", 5);
        archLayout.stickRight("zero");
        archLayout.putBelow("zero", "cross", 10);
        archLayout.stickRight("multiple");
        archLayout.alignBelow("multiple", "zero");
        archLayout.stickLeft("primary-label");
        archLayout.vCenter("primary-label", "primary");
        archLayout.stickLeft("secondary-label");
        archLayout.vCenter("secondary-label", "secondary");
        archLayout.putRight("primary", "primary-label,secondary-label", 5);
        archLayout.putBelow("primary", "multiple", 10);
        archLayout.stickRight("primary");
        archLayout.alignBelow("secondary", "primary");
        archLayout.stickRight("secondary");
    }

    public boolean isCrossed() {
        return this.m_CrossJoin.isSelected();
    }

    public String getZeroSecondary() {
        return this.m_ZeroSecondary.getSelectedId();
    }

    public String getMultipleSecondary() {
        return this.m_MultipleSecondary.getSelectedId();
    }

    public String getPrimaryPrefix() {
        return this.m_PrimaryPrefix.getText();
    }

    public String getSecondaryPrefix() {
        return this.m_SecondaryPrefix.getText();
    }

    public void setCrossed(boolean bl) {
        this.m_CrossJoin.setSelected(bl);
        this.updateButtons();
    }

    public void setZeroSecondary(String string) {
        this.m_ZeroSecondary.setSelectedId(string);
    }

    public void setMultipleSecondary(String string) {
        this.m_MultipleSecondary.setSelectedId(string);
    }

    public void setPrimaryPrefix(String string) {
        this.m_PrimaryPrefix.setText(string);
    }

    public void setSecondaryPrefix(String string) {
        this.m_SecondaryPrefix.setText(string);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateButtons();
    }

    protected void updateButtons() {
        boolean bl = this.isCrossed();
        this.m_ZeroSecondary.setEnabled(!bl);
        this.m_MultipleSecondary.setEnabled(!bl);
    }

    protected Name getName(Name[] nameArray, String string) {
        for (int i = 0; i < nameArray.length; ++i) {
            if (!nameArray[i].getName().equals(string)) continue;
            return nameArray[i];
        }
        return null;
    }
}

