/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.join;

import com.elixirtech.canvas.extras.JoinGOHelper;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.GOUtil;
import com.elixirtech.ensemble.canvas.JoinGO;
import com.elixirtech.ensemble.canvas.JoinNode;
import com.elixirtech.ensemble.wizard.join.JoinOptions;
import com.elixirtech.ensemble.wizard.join.JoinSchemaPanel;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.wizard.GOFirstPage;
import java.util.Set;
import javax.swing.JTabbedPane;

class JoinPage
extends GOFirstPage<JoinGO> {
    private JoinOptions m_OptionsPanel;
    private ResultSchemaPanel m_PrimaryPanel;
    private JoinSchemaPanel m_SecondaryPanel;

    public JoinPage(JoinGO joinGO) {
        super(joinGO, "Join", "<dynamic>");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "JoinPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        JTabbedPane jTabbedPane = SwingFactory.newTabbedPane("tabs");
        this.m_OptionsPanel = new JoinOptions();
        this.m_OptionsPanel.setCrossed(((JoinGO)this.m_GO).isUserProperty("Join_Crossed"));
        this.m_OptionsPanel.setZeroSecondary(((JoinGO)this.m_GO).getUserProperty("Join_ZeroSecondary"));
        this.m_OptionsPanel.setMultipleSecondary(((JoinGO)this.m_GO).getUserProperty("Join_MultipleSecondary"));
        this.m_OptionsPanel.setPrimaryPrefix(this.trim(((JoinGO)this.m_GO).getUserProperty("Join_PrimaryPrefix")));
        this.m_OptionsPanel.setSecondaryPrefix(this.trim(((JoinGO)this.m_GO).getUserProperty("Join_SecondaryPrefix")));
        jTabbedPane.addTab(I18N.ENSEMBLE.getString("JoinPage.OPTIONS"), this.m_OptionsPanel);
        String[] stringArray = this.buildPrimaryPanel(jTabbedPane);
        this.buildSecondaryPanel(jTabbedPane, stringArray);
        this.m_Component.add(jTabbedPane);
        this.putRight("GOFirstPage.name", "GOFirstPage.name-label", 10);
        this.putBelow("tabs", "GOFirstPage.name", 5);
        this.stickLeft("tabs");
        this.stickRight("tabs");
        this.stickBottom("tabs");
        I18N.ENSEMBLE_MAP.injectComponents("JoinPage.", this.m_Component);
    }

    private String trim(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    private String[] buildPrimaryPanel(JTabbedPane jTabbedPane) {
        String[] stringArray;
        this.m_PrimaryPanel = new ResultSchemaPanel();
        DataSchema dataSchema = ((JoinGO)this.m_GO).getPrimarySchema();
        if (dataSchema != null) {
            Set set = GOUtil.getDiscardSet((Node)this.m_GO, (String)"Join_PrimaryDiscard");
            this.m_PrimaryPanel.setSchema(dataSchema, set);
            stringArray = new String[dataSchema.getColumnCount() + 1];
            stringArray[0] = "";
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray[i] = dataSchema.getColumnName(i - 1);
            }
        } else {
            this.setError(I18N.ENSEMBLE.getString("JoinPage.PRIMARY_ERROR"));
            stringArray = new String[]{""};
        }
        jTabbedPane.addTab(I18N.ENSEMBLE.getString("JoinPage.PRIMARY"), this.m_PrimaryPanel);
        return stringArray;
    }

    private void buildSecondaryPanel(JTabbedPane jTabbedPane, String[] stringArray) {
        this.m_SecondaryPanel = new JoinSchemaPanel();
        this.m_SecondaryPanel.setPrimaryChoices(stringArray);
        DataSchema dataSchema = ((JoinGO)this.m_GO).getSecondarySchema();
        if (dataSchema != null) {
            Set set = GOUtil.getDiscardSet((Node)this.m_GO, (String)"Join_SecondaryDiscard");
            this.m_SecondaryPanel.setSchema(dataSchema, set);
        } else if (this.getError() == null) {
            this.setError(I18N.ENSEMBLE.getString("JoinPage.SECONDARY_ERROR"));
        }
        int n = ((JoinGO)this.m_GO).getJoinCount();
        for (int i = 0; i < n; ++i) {
            JoinNode joinNode = ((JoinGO)this.m_GO).getJoin(i);
            this.m_SecondaryPanel.putPrimary(joinNode.getSecondary(), joinNode.getPrimary());
        }
        jTabbedPane.addTab(I18N.ENSEMBLE.getString("JoinPage.SECONDARY"), this.m_SecondaryPanel);
    }

    @Override
    public void performFinish() {
        super.performFinish();
        this.m_SecondaryPanel.disposeEditor();
        int n = this.m_SecondaryPanel.getColumnCount();
        JoinGOHelper.removeAllJoins((JoinGO)this.m_GO);
        for (int i = 0; i < n; ++i) {
            JoinSchemaPanel.JoinSchemaColumn joinSchemaColumn = (JoinSchemaPanel.JoinSchemaColumn)this.m_SecondaryPanel.getColumn(i);
            JoinGOHelper.addJoin((JoinGO)this.m_GO, joinSchemaColumn.name, joinSchemaColumn.primary);
        }
        ((JoinGO)this.m_GO).setUserProperty("Join_Crossed", this.m_OptionsPanel.isCrossed());
        ((JoinGO)this.m_GO).setUserProperty("Join_ZeroSecondary", this.m_OptionsPanel.getZeroSecondary());
        ((JoinGO)this.m_GO).setUserProperty("Join_MultipleSecondary", this.m_OptionsPanel.getMultipleSecondary());
        ((JoinGO)this.m_GO).setUserProperty("Join_PrimaryPrefix", this.m_OptionsPanel.getPrimaryPrefix());
        ((JoinGO)this.m_GO).setUserProperty("Join_SecondaryPrefix", this.m_OptionsPanel.getSecondaryPrefix());
        GOUtil.setDiscardSet((Node)this.m_GO, (String)"Join_PrimaryDiscard", this.m_PrimaryPanel.getDiscardSet());
        GOUtil.setDiscardSet((Node)this.m_GO, (String)"Join_SecondaryDiscard", this.m_SecondaryPanel.getDiscardSet());
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    public IWizardPage getNextPage() {
        return null;
    }

    @Override
    public boolean isPageComplete() {
        return ((JoinGO)this.m_GO).getSchema() != null;
    }

    protected boolean isCrossed() {
        return this.m_OptionsPanel.isCrossed();
    }
}

