/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.result;

import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.icons.StandardIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OrderableResultSchemaPanel
extends ResultSchemaPanel
implements ActionListener,
ListSelectionListener {
    public static final String UP = "up";
    public static final String DOWN = "down";
    protected Box m_Items;
    protected JButton m_MoveUp;
    protected JButton m_MoveDown;

    public OrderableResultSchemaPanel(boolean bl) {
        super(bl);
        this.initButtons();
        ListSelectionModel listSelectionModel = this.m_ColumnTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.checkEnabled();
    }

    public List<String> getOrderList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.m_ColumnModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.m_ColumnModel.getColumn((int)i).name);
        }
        return arrayList;
    }

    public void setOrderList(List<String> list) {
        if (!list.isEmpty()) {
            List<ResultSchemaPanel.SchemaColumn> list2 = this.m_ColumnModel.getAdjustableColumns();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ResultSchemaPanel.SchemaColumn object2 : list2) {
                arrayList.add(object2.name);
            }
            ArrayList<ResultSchemaPanel.SchemaColumn> arrayList2 = new ArrayList<ResultSchemaPanel.SchemaColumn>(list2);
            ArrayList<ResultSchemaPanel.SchemaColumn> arrayList3 = new ArrayList<ResultSchemaPanel.SchemaColumn>();
            for (String string : list) {
                int n = arrayList.indexOf(string);
                if (n < 0) continue;
                ResultSchemaPanel.SchemaColumn schemaColumn = list2.get(n);
                arrayList3.add(schemaColumn);
                arrayList2.remove(schemaColumn);
            }
            arrayList3.addAll(arrayList2);
            this.m_ColumnModel.setAdjustableColumns(arrayList3);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.checkEnabled();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = this.m_ColumnTable.getSelectedRow();
        if (UP.equals(string)) {
            int n2 = this.m_ColumnModel.moveUp(n);
            this.m_ColumnTable.setRowSelectionInterval(n2, n2);
        } else if (DOWN.equals(string)) {
            int n3 = this.m_ColumnModel.moveDown(n);
            this.m_ColumnTable.setRowSelectionInterval(n3, n3);
        }
    }

    public void checkEnabled() {
        if (this.m_ColumnTable.isEnabled()) {
            int[] nArray = this.m_ColumnTable.getSelectedRows();
            int n = this.m_ColumnTable.getRowCount() - 1;
            this.m_MoveUp.setEnabled(nArray.length == 1 && nArray[0] > 0);
            this.m_MoveDown.setEnabled(nArray.length == 1 && nArray[0] < n);
        } else {
            this.m_MoveUp.setEnabled(false);
            this.m_MoveDown.setEnabled(false);
        }
    }

    protected void initButtons() {
        this.m_Items = new Box(1);
        this.m_MoveUp = this.button(UP, Bundle.ARCH.getString("MoveUp"), StandardIcons.UP);
        this.m_MoveDown = this.button(DOWN, Bundle.ARCH.getString("MoveDown"), StandardIcons.DOWN);
        this.m_Items.add(this.m_MoveUp);
        this.m_Items.add(this.m_MoveDown);
        this.m_MoveUp.setMnemonic('U');
        this.m_MoveDown.setMnemonic('J');
        this.add((Component)this.m_Items, "West");
    }

    protected JButton button(String string, String string2, Icon icon) {
        JButton jButton = new JButton(null, icon);
        jButton.setActionCommand(string);
        jButton.setToolTipText(string2);
        jButton.addActionListener(this);
        return jButton;
    }
}

