/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.result;

import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.ensemble.EnsembleAction;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ui.DoubleClickListener;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.TableUtil;
import com.elixirtech.ui.table.ElxTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class ResultSchemaPanel
extends JPanel {
    protected boolean m_NotAllowClearSelection;
    protected ColumnModel m_ColumnModel;
    protected JTable m_ColumnTable;
    protected boolean m_HideDiscard;
    protected List<DoubleClickListener> m_Listeners;
    protected ML m_ML = new ML();
    public static final String[] COLUMNS = new String[]{"TableModel.Column", "TableModel.Name", "TableModel.Type", "TableModel.Discard"};
    public static final String[] NO_DISCARD_COLUMNS = new String[]{"TableModel.Column", "TableModel.Name", "TableModel.Type"};

    public ResultSchemaPanel() {
        this(false);
    }

    public ResultSchemaPanel(boolean bl) {
        this.setName("schema");
        this.m_HideDiscard = bl;
        this.setLayout(new BorderLayout());
        this.m_ColumnModel = this.newColumnModel();
        this.m_ColumnTable = SwingFactory.newTable();
        this.m_ColumnTable.setModel(this.m_ColumnModel);
        this.m_ColumnTable.setSelectionMode(0);
        TableColumn tableColumn = this.m_ColumnTable.getColumnModel().getColumn(0);
        TableUtil.setColumnWidth(this.m_ColumnTable, tableColumn, I18N.ENSEMBLE, COLUMNS[0], 10);
        this.m_ColumnTable.addMouseListener(this.m_ML);
        this.add((Component)new JScrollPane(this.m_ColumnTable), "Center");
    }

    public void setSelectionMode(int n) {
        this.m_ColumnTable.setSelectionMode(n);
    }

    public void setAllowClearSelection(boolean bl) {
        this.m_NotAllowClearSelection = !bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_ColumnTable.setEnabled(bl);
    }

    public void setRowSelectionAllowed(boolean bl) {
        this.m_ColumnTable.setRowSelectionAllowed(bl);
    }

    public void setRowSelectionMode(int n) {
        this.m_ColumnTable.setSelectionMode(n);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.m_ColumnTable.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.m_ColumnTable.getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    public int getSelection() {
        return this.m_ColumnTable.getSelectedRow();
    }

    public String getSelectedName() {
        int n = this.m_ColumnTable.getSelectedRow();
        if (n >= 0) {
            return this.getColumn((int)n).name;
        }
        return null;
    }

    public void setSelectedName(String string) {
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getColumn((int)i).name.equals(string)) continue;
            this.m_ColumnTable.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    public String[] getSelectedNames() {
        int[] nArray = this.m_ColumnTable.getSelectedRows();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.getColumn((int)nArray[i]).name;
        }
        return stringArray;
    }

    public void setSelectedNames(String[] stringArray) {
        this.m_ColumnTable.clearSelection();
        block0: for (int i = 0; i < stringArray.length; ++i) {
            int n = this.getColumnCount();
            for (int j = 0; j < n; ++j) {
                if (!this.getColumn((int)j).name.equals(stringArray[i])) continue;
                this.m_ColumnTable.getSelectionModel().addSelectionInterval(j, j);
                continue block0;
            }
        }
    }

    public void disposeEditor() {
        TableCellEditor tableCellEditor = this.m_ColumnTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
            this.m_ColumnTable.removeEditor();
        }
    }

    public void setSchema(DataSchema dataSchema, Set<String> set) {
        this.m_ColumnModel.removeAll();
        if (dataSchema != null) {
            int n = dataSchema.getColumnCount();
            for (int i = 0; i < n; ++i) {
                SchemaColumn schemaColumn = this.newColumn();
                schemaColumn.name = dataSchema.getColumnName(i);
                schemaColumn.type = dataSchema.getColumnType(i);
                schemaColumn.attrs = new DataAttributes(dataSchema.getAttributes(i));
                schemaColumn.discard = set.contains(schemaColumn.name) ? Boolean.TRUE : Boolean.FALSE;
                this.m_ColumnModel.addColumn(schemaColumn);
            }
        }
    }

    public Set<String> getDiscardSet() {
        HashSet<String> hashSet = new HashSet<String>();
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            SchemaColumn schemaColumn = this.getColumn(i);
            if (!Boolean.TRUE.equals(schemaColumn.discard)) continue;
            hashSet.add(schemaColumn.name);
        }
        return hashSet;
    }

    public int getColumnCount() {
        return this.m_ColumnModel.getRowCount();
    }

    public SchemaColumn getColumn(int n) {
        return this.m_ColumnModel.getColumn(n);
    }

    public void addDoubleClickListener(DoubleClickListener doubleClickListener) {
        if (this.m_Listeners == null) {
            this.m_Listeners = new ArrayList<DoubleClickListener>();
        }
        this.m_Listeners.add(doubleClickListener);
    }

    public void removeDoubleClickListener(DoubleClickListener doubleClickListener) {
        if (this.m_Listeners != null) {
            this.m_Listeners.remove(doubleClickListener);
        }
    }

    public void doPopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (!this.m_HideDiscard) {
            jPopupMenu.add(new DiscardAllAction());
            jPopupMenu.add(new DiscardNoneAction());
        }
        if (!this.m_NotAllowClearSelection) {
            jPopupMenu.add(new ClearSelectionAction());
        }
        jPopupMenu.show(this.m_ColumnTable, mouseEvent.getX(), mouseEvent.getY());
    }

    protected ColumnModel newColumnModel() {
        return new ColumnModel(this.getColumnNames());
    }

    protected SchemaColumn newColumn() {
        return new SchemaColumn();
    }

    protected String[] getColumnNames() {
        if (this.m_HideDiscard) {
            return NO_DISCARD_COLUMNS;
        }
        return COLUMNS;
    }

    private class ML
    extends MouseAdapter {
        private ML() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.doPopup(mouseEvent);
            }
            if (ResultSchemaPanel.this.isEnabled() && mouseEvent.getClickCount() == 2 && ResultSchemaPanel.this.m_Listeners != null) {
                for (DoubleClickListener doubleClickListener : ResultSchemaPanel.this.m_Listeners) {
                    doubleClickListener.doubleClick(mouseEvent);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.doPopup(mouseEvent);
            }
        }

        public void doPopup(MouseEvent mouseEvent) {
            ResultSchemaPanel.this.doPopup(mouseEvent);
        }
    }

    protected class ColumnModel
    extends ElxTableModel {
        private List<SchemaColumn> m_Columns;

        public ColumnModel(String[] stringArray) {
            super(I18N.ENSEMBLE, stringArray);
            this.m_Columns = new ArrayList<SchemaColumn>();
        }

        @Override
        public int getRowCount() {
            return this.m_Columns.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return n + 1;
            }
            SchemaColumn schemaColumn = this.getColumn(n);
            return schemaColumn.getData(n2);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (this.m_Columns.size() == 0) {
                return String.class;
            }
            return this.getColumn(0).getClass(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            SchemaColumn schemaColumn = this.getColumn(n);
            return schemaColumn.isEditable(n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SchemaColumn schemaColumn = this.getColumn(n);
            schemaColumn.setValue(object, n2);
        }

        public void discardAll(boolean bl) {
            Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            for (SchemaColumn schemaColumn : this.m_Columns) {
                schemaColumn.discard = bl2;
            }
            this.fireTableDataChanged();
        }

        public void removeAll() {
            int n = this.m_Columns.size();
            if (n > 0) {
                this.m_Columns.clear();
                this.fireTableRowsDeleted(0, n - 1);
            }
        }

        public void addColumn(SchemaColumn schemaColumn) {
            int n = this.m_Columns.size();
            this.m_Columns.add(schemaColumn);
            this.fireTableRowsInserted(n, n);
        }

        public void updateColumn(SchemaColumn schemaColumn) {
            int n = this.m_Columns.indexOf(schemaColumn);
            if (n >= 0) {
                this.fireTableRowsUpdated(n, n);
            }
        }

        public SchemaColumn getColumn(int n) {
            return this.m_Columns.get(n);
        }

        public int moveUp(int n) {
            if (n > 0) {
                SchemaColumn schemaColumn = this.m_Columns.remove(n);
                this.m_Columns.add(n - 1, schemaColumn);
                this.fireTableRowsUpdated(n - 1, n);
                return n - 1;
            }
            return n;
        }

        public int moveDown(int n) {
            if (n < this.m_Columns.size() - 1) {
                SchemaColumn schemaColumn = this.m_Columns.remove(n);
                this.m_Columns.add(n + 1, schemaColumn);
                this.fireTableRowsUpdated(n, n + 1);
                return n + 1;
            }
            return n;
        }

        protected List<SchemaColumn> getAdjustableColumns() {
            return Collections.unmodifiableList(this.m_Columns);
        }

        protected void setAdjustableColumns(List<SchemaColumn> list) {
            this.m_Columns = list;
            this.fireTableDataChanged();
        }
    }

    public static class SchemaColumn {
        public String name = "";
        public DataType type = DataType.UNKNOWN;
        public DataAttributes attrs;
        public Boolean discard = Boolean.FALSE;

        public Class<?> getClass(int n) {
            if (n == 3) {
                return Boolean.class;
            }
            return String.class;
        }

        public Object getData(int n) {
            if (n == 1) {
                return this.name;
            }
            if (n == 2) {
                return this.type;
            }
            if (n == 3) {
                return this.discard;
            }
            return null;
        }

        public boolean isEditable(int n) {
            return n == 3;
        }

        public void setValue(Object object, int n) {
            if (n == 3 && object instanceof Boolean) {
                this.discard = (Boolean)object;
            }
        }
    }

    protected class DiscardAllAction
    extends EnsembleAction {
        public DiscardAllAction() {
            super("ResultSchemaPanel.DiscardAll");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ResultSchemaPanel.this.m_ColumnModel.discardAll(true);
        }
    }

    protected class DiscardNoneAction
    extends EnsembleAction {
        public DiscardNoneAction() {
            super("ResultSchemaPanel.DiscardNone");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ResultSchemaPanel.this.m_ColumnModel.discardAll(false);
        }
    }

    protected class ClearSelectionAction
    extends EnsembleAction {
        public ClearSelectionAction() {
            super("ResultSchemaPanel.ClearSelection");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ResultSchemaPanel.this.m_ColumnTable.clearSelection();
        }
    }
}

