/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.sort;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StrBuffer;
import java.awt.Dimension;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExtractPage
extends RelativeLayoutWizardPage
implements ChangeListener {
    public static final String PAGE_NAME = "Extract";
    private JRadioButton m_Top;
    private JRadioButton m_Bottom;
    private JSpinner m_Amount;
    private SpinnerNumberModel m_AmountModel;
    private JCheckBox m_Percent;
    private JSpinner m_Level;
    private SpinnerNumberModel m_LevelModel;
    private JTextField m_Value;

    public ExtractPage() {
        super(PAGE_NAME, null);
        I18N.ENSEMBLE_MAP.injectObject(null, this, "SortPage");
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.getNextPage() != null;
    }

    @Override
    public boolean isPageComplete() {
        IWizardPage iWizardPage = this.m_Wizard.getPage("Sort");
        if (iWizardPage != null) {
            return iWizardPage.isPageComplete();
        }
        return true;
    }

    public void performFinish() {
        ((ExtractWizard)((Object)this.m_Wizard)).setExtractValue(this.m_Value.getText());
    }

    public void setValue() {
        StrBuffer strBuffer = new StrBuffer();
        if (this.m_Top.isSelected()) {
            strBuffer.append("Top ");
        } else {
            strBuffer.append("Bottom ");
        }
        strBuffer.append(this.m_Amount.getValue());
        if (this.m_Percent.isSelected()) {
            strBuffer.append("%");
        }
        strBuffer.append(" Level ");
        strBuffer.append(this.m_Level.getValue());
        this.m_Value.setText(strBuffer.toString());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.m_Percent.isSelected()) {
            Number number = (Number)this.m_AmountModel.getValue();
            if (number.intValue() > 100) {
                this.m_AmountModel.setValue(100);
            }
            this.m_AmountModel.setMaximum(Integer.valueOf(100));
        } else {
            this.m_AmountModel.setMaximum(null);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            int n = ((ExtractWizard)((Object)this.m_Wizard)).getGroupCount();
            Number number = (Number)this.m_LevelModel.getValue();
            if (number.intValue() > n) {
                this.m_LevelModel.setValue(n);
            }
            this.m_LevelModel.setMaximum(Integer.valueOf(n));
        }
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Top = SwingFactory.newRadioButton("top");
        this.m_Bottom = SwingFactory.newRadioButton("bottom");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_Top);
        buttonGroup.add(this.m_Bottom);
        this.m_Top.setSelected(true);
        Integer n = 0;
        Integer n2 = 1;
        this.m_AmountModel = new SpinnerNumberModel(n, n, null, n2);
        this.m_Amount = SwingFactory.newSpinner("amount", this.m_AmountModel);
        Dimension dimension = this.m_Amount.getPreferredSize();
        dimension.width *= 2;
        this.m_Amount.setPreferredSize(dimension);
        this.m_Percent = SwingFactory.newCheckBox("percent");
        this.m_Percent.addChangeListener(this);
        this.m_LevelModel = new SpinnerNumberModel(n, n, n, n2);
        this.m_Level = SwingFactory.newSpinner("level", this.m_LevelModel);
        this.m_Level.setPreferredSize(dimension);
        JPanel jPanel = this.buildPanel();
        JButton jButton = SwingFactory.newButton("set");
        jButton.addActionListener(new CodeBlock((Object)this, "setValue"));
        this.m_Value = SwingFactory.newTextField("value", 25);
        this.m_Component.add("panel", jPanel);
        this.m_Component.add("set", jButton);
        this.m_Component.add(SwingFactory.newLabel("value-label"));
        this.m_Component.add("value", this.m_Value);
        this.positionComponents();
        this.m_Value.setText(((ExtractWizard)((Object)this.m_Wizard)).getExtractValue());
        I18N.ENSEMBLE_MAP.injectComponents("ExtractPage.", this.m_Component);
    }

    private JPanel buildPanel() {
        ArchLayout archLayout = new ArchLayout();
        JPanel jPanel = new JPanel(archLayout);
        jPanel.setBorder(new TitledBorder(I18N.ENSEMBLE.getString("ExtractPage.ExpressionBuilder")));
        jPanel.add(SwingFactory.newLabel("amount-label"));
        jPanel.add(SwingFactory.newLabel("level-label"));
        jPanel.add(this.m_Top);
        jPanel.add(this.m_Bottom);
        jPanel.add(this.m_Amount);
        jPanel.add(this.m_Percent);
        jPanel.add(this.m_Level);
        archLayout.stickTop("top");
        archLayout.stickLeft("top");
        archLayout.stickTop("bottom");
        archLayout.putRight("bottom", "top", 5);
        archLayout.putRight("amount-label", "bottom", 10);
        archLayout.vCenter("amount-label", "top");
        archLayout.vCenter("amount", "top");
        archLayout.putRight("amount", "amount-label", 10);
        archLayout.vCenter("percent", "top");
        archLayout.putRight("percent", "amount", 10);
        archLayout.putRight("level-label", "percent", 10);
        archLayout.vCenter("level-label", "top");
        archLayout.vCenter("level", "top");
        archLayout.putRight("level", "level-label", 10);
        return jPanel;
    }

    private void positionComponents() {
        this.stickLeft("panel");
        this.stickTop("panel");
        this.stickRight("panel");
        this.hCenter("set");
        this.putBelow("set", "panel", 20);
        this.stickLeft("value-label");
        this.vCenter("value-label", "value");
        this.putRight("value", "value-label", 10);
        this.stickRight("value");
        this.putBelow("value", "set", 20);
    }

    public static interface ExtractWizard {
        public String getExtractValue();

        public int getGroupCount();

        public void setExtractValue(String var1);
    }
}

