/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.sort;

import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.grouping.GrouperFactory;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.SortNode;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.I18NName;
import com.elixirtech.i18n.Name;
import com.elixirtech.ui.LabelledPanel;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SortDialog
extends JDialog {
    private static final String[] IDS = new String[]{"None", "Ascending", "Ascending-Lexicographic", "Descending", "Descending-Lexicographic"};
    private static final String[] KEYS = new String[]{"Sort.NONE", "Sort.ASCENDING", "Sort.ASCENDING_LEXICOGRAPHIC", "Sort.DESCENDING", "Sort.DESCENDING_LEXICOGRAPHIC"};
    protected final boolean m_IsShowTitle;
    protected final DataSchema m_Schema;
    protected final SortNode m_Node;
    protected final boolean m_TotalsVisible;
    protected boolean m_IsOk;
    protected JComboBox m_Name;
    protected JCheckBox m_ShowTotals;
    protected I18NComboBox m_SortOrder;
    protected I18NComboBox m_GroupOn;
    protected JTextField m_GroupData;
    protected JTextField m_DerivedField;
    protected JTextField m_TotalTitle;
    protected JLabel m_DataLabel;
    protected JButton m_Ok;
    protected JButton m_Cancel;

    public static Name[] getGroupDisplayNames(String[] stringArray) {
        Name[] nameArray = new Name[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nameArray[i] = SortDialog.getGroupDisplayName(stringArray[i]);
        }
        return nameArray;
    }

    public static Name getGroupDisplayName(String string) {
        String string2 = StringUtil.isEmpty(string) ? "None" : string;
        String string3 = "Group." + string2.replace(' ', '_').toUpperCase(Locale.ENGLISH);
        return I18NName.apply((String)string2, (ResourceBundle)I18N.ENSEMBLE, (String)string3);
    }

    public static Name getSortDisplayName(String string) {
        for (int i = 0; i < IDS.length; ++i) {
            if (!IDS[i].equals(string)) continue;
            return I18NName.apply((String)string, (ResourceBundle)I18N.ENSEMBLE, (String)KEYS[i]);
        }
        return Name.apply((String)string);
    }

    public SortDialog(JFrame jFrame, String string, DataSchema dataSchema, SortNode sortNode, boolean bl, boolean bl2) {
        super((Frame)jFrame, true);
        this.setTitle(string);
        this.m_IsShowTitle = bl;
        this.m_Schema = dataSchema;
        this.m_Node = sortNode;
        this.m_TotalsVisible = bl2;
        this.setDefaultCloseOperation(2);
        int n = 5;
        if (this.m_IsShowTitle) {
            n = 6;
        }
        LabelledPanel labelledPanel = new LabelledPanel(n);
        this.getContentPane().add((Component)labelledPanel, "Center");
        this.buildUI(labelledPanel);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.buildButtons(jPanel);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        Dimension dimension = this.getPreferredSize();
        this.setSize(dimension.width * 2, dimension.height);
        this.setLocationRelativeTo(jFrame);
        I18N.ENSEMBLE_MAP.injectComponents("SortDialog.", this);
    }

    public void ok() {
        this.m_Node.setName((String)this.m_Name.getSelectedItem());
        this.m_Node.setSortOrder(this.m_SortOrder.getSelectedId());
        this.m_Node.setGroupOn(this.m_GroupOn.getSelectedId());
        if (this.m_GroupData.isVisible()) {
            this.m_Node.setGroupData(this.m_GroupData.getText());
        } else {
            this.m_Node.setGroupData("");
        }
        if (this.hasDerivedField()) {
            this.m_Node.setDerivedField(this.m_DerivedField.getText());
        }
        if (this.m_TotalsVisible) {
            this.m_Node.setTotalTitle(this.m_TotalTitle.getText());
            this.m_Node.setShowTotals(this.m_ShowTotals.isSelected());
        }
        this.m_IsOk = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public boolean isOk() {
        return this.m_IsOk;
    }

    protected void buildUI(LabelledPanel labelledPanel) {
        this.m_Name = SwingFactory.newComboBox("name-inner", this.getNames());
        this.m_Name.setSelectedItem(this.m_Node.getName());
        this.m_SortOrder = I18NComboBox.apply(I18NComboBox.buildModel(IDS, I18N.ENSEMBLE, KEYS));
        this.m_SortOrder.setName("sort-order");
        this.m_SortOrder.setSelectedId(this.m_Node.getSortOrder());
        this.m_GroupOn = I18NComboBox.apply(this.getGroupOn());
        this.m_GroupOn.setName("group-on");
        this.m_GroupOn.setSelectedId(this.m_Node.getGroupOn());
        this.m_GroupData = SwingFactory.newTextField("group-data", 32);
        this.m_GroupData.setText(this.m_Node.getGroupData());
        this.m_TotalTitle = SwingFactory.newTextField("total-title", 32);
        this.m_TotalTitle.setText(this.m_Node.getTotalTitle());
        if (this.hasDerivedField()) {
            this.m_DerivedField = SwingFactory.newTextField("field", 32);
            this.m_DerivedField.setText(this.m_Node.getDerivedField());
        }
        this.m_Name.addItemListener(new CodeBlock((Object)this, "updateGroupOn"));
        this.m_GroupOn.addItemListener(new CodeBlock((Object)this, "updateGroupData"));
        this.addItems(labelledPanel);
        this.updateCombos();
    }

    protected void addItems(LabelledPanel labelledPanel) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setName("name");
        jPanel.add((Component)this.m_Name, "Center");
        if (this.m_TotalsVisible) {
            this.m_ShowTotals = SwingFactory.newCheckBox("totals");
            this.m_ShowTotals.setMargin(new Insets(0, 5, 0, 0));
            this.m_ShowTotals.setSelected(this.m_Node.isShowTotals());
            jPanel.add((Component)this.m_ShowTotals, "East");
        }
        labelledPanel.addItem(SwingFactory.newLabel("name-label"), jPanel);
        labelledPanel.addItem(SwingFactory.newLabel("sort-order-label"), this.m_SortOrder);
        labelledPanel.addItem(SwingFactory.newLabel("group-on-label"), this.m_GroupOn);
        if (this.m_TotalsVisible && this.m_IsShowTitle) {
            labelledPanel.addItem(SwingFactory.newLabel("total-title-label"), this.m_TotalTitle);
        }
        this.m_DataLabel = labelledPanel.addItem(SwingFactory.newLabel("group-data-label"), this.m_GroupData);
        if (this.hasDerivedField()) {
            labelledPanel.addItem(SwingFactory.newLabel("field-label"), this.m_DerivedField);
        }
    }

    protected void buildButtons(JPanel jPanel) {
        this.m_Ok = SwingFactory.newOkButton(new CodeBlock((Object)this, "ok"));
        jPanel.add(this.m_Ok);
        this.m_Cancel = SwingFactory.newCancelButton(new CodeBlock((Object)this, "cancel"));
        jPanel.add(this.m_Cancel);
    }

    public void updateCombos() {
        this.updateGroupOn();
        this.updateGroupData();
    }

    public void updateGroupOn() {
        Object object = this.m_GroupOn.getSelectedItem();
        this.m_GroupOn.setModel(new DefaultComboBoxModel<Name>(this.getGroupOn()));
        this.m_GroupOn.setSelectedItem(object);
        if (this.m_GroupOn.getSelectedIndex() < 0 && this.m_GroupOn.getItemCount() > 0) {
            this.m_GroupOn.setSelectedIndex(0);
        }
    }

    public void updateGroupData() {
        String string = this.m_GroupOn.getSelectedId();
        if (string == null || string.equals("All") || string.equals("Each Value") || string.equals("None") || string.equals("Quarter")) {
            this.m_DataLabel.setText("");
            this.m_GroupData.setVisible(false);
        } else if (string.equals("Range")) {
            this.m_DataLabel.setText(I18N.ENSEMBLE.getString("SortDialog.Range"));
            this.m_GroupData.setVisible(true);
        } else if (string.equals("Substring")) {
            this.m_DataLabel.setText(I18N.ENSEMBLE.getString("SortDialog.StartEnd"));
            this.m_GroupData.setVisible(true);
        } else {
            this.m_DataLabel.setText(I18N.ENSEMBLE.getString("SortDialog.GroupInterval"));
            this.m_GroupData.setVisible(true);
        }
    }

    protected SortNode getNode() {
        return this.m_Node;
    }

    protected boolean hasDerivedField() {
        return true;
    }

    protected String[] getNames() {
        int n = this.m_Schema != null ? this.m_Schema.getColumnCount() : 0;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_Schema.getColumnName(i);
        }
        return stringArray;
    }

    protected Name[] getGroupOn() {
        int n = this.m_Name.getSelectedIndex();
        if (n < 0) {
            return new Name[0];
        }
        if (this.m_Schema != null) {
            DataType dataType = this.m_Schema.getColumnType(n);
            return SortDialog.getGroupDisplayNames(GrouperFactory.getGroupOnNames((DataType)dataType));
        }
        return new Name[0];
    }
}

