/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.sort;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.SortGO;
import com.elixirtech.ensemble.canvas.SortNode;
import com.elixirtech.ensemble.wizard.sort.SortDialog;
import com.elixirtech.ui.OrderedEditableTable;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.GOFirstPage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

class SortPage
extends GOFirstPage<SortGO>
implements ActionListener {
    SortModel m_Model;
    OrderedEditableTable m_Table;
    List<SortNode> m_Items = new ArrayList<SortNode>();
    static final String[] COLUMNS = new String[]{"TableModel.Name", "TableModel.SortOrder", "TableModel.GroupOn", "TableModel.GroupData", "TableModel.Field"};

    public SortPage(SortGO sortGO) {
        super(sortGO, "Sort", "Extract");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "SortPage");
    }

    @Override
    public void performFinish() {
        super.performFinish();
        this.m_Table.disposeEditor();
        ((SortGO)this.m_GO).removeAllSorts();
        for (SortNode sortNode : this.m_Items) {
            ((SortGO)this.m_GO).addSort(sortNode);
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    public boolean isPageComplete() {
        boolean bl;
        boolean bl2 = bl = ((SortGO)this.m_GO).getSchema() != null;
        if (bl) {
            this.setError(null);
        } else {
            this.setError(I18N.ENSEMBLE.getString("GO.CANT_READ_SCHEMA"));
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("plus".equals(string)) {
            this.m_Model.add();
        } else if ("minus".equals(string)) {
            this.m_Model.remove();
        } else if ("edit".equals(string)) {
            this.m_Model.edit();
        } else if ("up".equals(string)) {
            this.m_Model.moveUp();
        } else if ("down".equals(string)) {
            this.m_Model.moveDown();
        }
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        int n = ((SortGO)this.m_GO).getSortCount();
        for (int i = 0; i < n; ++i) {
            this.m_Items.add(new SortNode(((SortGO)this.m_GO).getSort(i)));
        }
        this.m_Model = new SortModel();
        this.m_Table = new OrderedEditableTable(this.m_Model, true, false);
        this.m_Table.addActionListener(this);
        this.m_Table.setSingleSelectionMode();
        this.m_Table.setEnabled(((SortGO)this.m_GO).getSchema() != null);
        this.m_Component.add("table", this.m_Table);
        this.putRight("GOFirstPage.name", "GOFirstPage.name-label", 10);
        this.putBelow("table", "GOFirstPage.name", 5);
        this.stickLeft("table");
        this.stickRight("table");
        this.stickBottom("table");
        I18N.ENSEMBLE_MAP.injectComponents("SortPage", this.m_Component);
    }

    protected int getGroupCount() {
        return this.m_Items.size();
    }

    public class SortModel
    extends ElxTableModel {
        public SortModel() {
            super(I18N.ENSEMBLE, COLUMNS);
        }

        @Override
        public int getRowCount() {
            return SortPage.this.m_Items.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SortNode sortNode = SortPage.this.m_Items.get(n);
            if (n2 == 0) {
                return sortNode.getName();
            }
            if (n2 == 1) {
                return SortDialog.getSortDisplayName(sortNode.getSortOrder());
            }
            if (n2 == 2) {
                return SortDialog.getGroupDisplayName(sortNode.getGroupOn());
            }
            if (n2 == 3) {
                return sortNode.getGroupData();
            }
            if (n2 == 4) {
                return sortNode.getDerivedField();
            }
            return null;
        }

        public void add() {
            SortNode sortNode = new SortNode();
            sortNode.setSortOrder("None");
            sortNode.setGroupOn("None");
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            String string = I18N.ENSEMBLE.getString("SortDialog.SORT");
            SortDialog sortDialog = new SortDialog(elixirFrame.getFrame(), string, ((SortGO)SortPage.this.m_GO).getSchema(), sortNode, false, false);
            elixirFrame.showModal(sortDialog);
            if (sortDialog.isOk()) {
                int n = SortPage.this.m_Items.size();
                SortPage.this.m_Items.add(sortNode);
                this.fireTableRowsInserted(n, n);
                SortPage.this.m_Table.select(n);
            }
        }

        public void edit() {
            int n = SortPage.this.m_Table.getSelectedRow();
            if (n >= 0) {
                SortNode sortNode = SortPage.this.m_Items.get(n);
                ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
                String string = I18N.ENSEMBLE.getString("SortDialog.SORT");
                SortDialog sortDialog = new SortDialog(elixirFrame.getFrame(), string, ((SortGO)SortPage.this.m_GO).getSchema(), sortNode, false, false);
                elixirFrame.showModal(sortDialog);
                if (sortDialog.isOk()) {
                    this.fireTableRowsUpdated(n, n);
                }
            }
        }

        public void moveUp() {
            int n = SortPage.this.m_Table.getSelectedRow();
            SortNode sortNode = SortPage.this.m_Items.remove(n);
            SortPage.this.m_Items.add(--n, sortNode);
            this.fireTableRowsUpdated(n, n + 1);
            SortPage.this.m_Table.select(n);
        }

        public void moveDown() {
            int n = SortPage.this.m_Table.getSelectedRow();
            SortNode sortNode = SortPage.this.m_Items.remove(n);
            SortPage.this.m_Items.add(++n, sortNode);
            this.fireTableRowsUpdated(n - 1, n);
            SortPage.this.m_Table.select(n);
        }

        public void remove() {
            int n = SortPage.this.m_Table.getSelectedRow();
            SortPage.this.m_Items.remove(n);
            this.fireTableRowsDeleted(n, n);
            if (n >= SortPage.this.m_Items.size()) {
                --n;
            }
            if (n >= 0) {
                SortPage.this.m_Table.select(n);
            }
        }
    }
}

