/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.subflow;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.DataFlowGO;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.sub.InputGO;
import com.elixirtech.ensemble.wizard.subflow.InputTestDialog;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.WizardDialog;
import com.elixirtech.wizard.GOFirstPage;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

class InputPage
extends GOFirstPage<InputGO>
implements ActionListener,
ListSelectionListener {
    private JTable m_Table;
    private Model m_Model;
    private JButton m_Up;
    private JButton m_Down;
    static final String[] COLUMNS = new String[]{"TableModel.Test", "TableModel.Next"};

    public InputPage(InputGO inputGO) {
        super(inputGO, "Input", null);
        I18N.ENSEMBLE_MAP.injectObject(null, this, "InputPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Model = new Model();
        this.m_Table = SwingFactory.newTable();
        this.m_Table.setModel(this.m_Model);
        this.m_Table.setSelectionMode(0);
        this.m_Table.getSelectionModel().addListSelectionListener(this);
        this.m_Table.addMouseListener(new ML());
        this.m_Up = new JButton(StandardIcons.UP);
        this.m_Up.addActionListener(this);
        this.m_Down = new JButton(StandardIcons.DOWN);
        this.m_Down.addActionListener(this);
        this.m_Component.add("table", new JScrollPane(this.m_Table));
        this.m_Component.add("up", this.m_Up);
        this.m_Component.add("down", this.m_Down);
        I18N.ENSEMBLE_MAP.injectComponents("InputPage.", this.m_Component);
        this.putRight("GOFirstPage.name", "GOFirstPage.name-label", 10);
        this.putBelow("table", "GOFirstPage.name", 5);
        this.stickLeft("table");
        this.putLeft("table", "up");
        this.stickBottom("table");
        this.stickRight("up");
        this.stickRight("down");
        this.putBelow("up", "GOFirstPage.name", 5);
        this.putBelow("down", "up");
        this.checkEnabled();
        if (((InputGO)this.m_GO).getSchema() == null) {
            this.setError(I18N.ENSEMBLE.getString("GO.CANT_READ_SCHEMA"));
        }
    }

    public void disposeEditor() {
        TableCellEditor tableCellEditor = this.m_Table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
            this.m_Table.removeEditor();
        }
    }

    @Override
    public void performFinish() {
        super.performFinish();
        this.disposeEditor();
        ((InputGO)this.m_GO).setOutFlows(this.m_Model.getChoices());
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    public IWizardPage getNextPage() {
        return null;
    }

    @Override
    public boolean isPageComplete() {
        if (((InputGO)this.m_GO).getSchema() == null) {
            return false;
        }
        String string = this.m_Model.duplicate();
        if (string != null) {
            this.setError(I18NUtil.getString(I18N.ENSEMBLE, "InputPage.DUPLICATE_NEXT", string));
            IWizardContainer iWizardContainer = this.m_Wizard.getContainer();
            if (iWizardContainer != null) {
                iWizardContainer.updateMessage();
            }
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.disposeEditor();
        if (actionEvent.getSource() == this.m_Up) {
            this.up();
        } else if (actionEvent.getSource() == this.m_Down) {
            this.down();
        }
    }

    public void up() {
        int n = this.m_Table.getSelectedRow();
        this.m_Model.moveUp(n);
        this.m_Table.setRowSelectionInterval(--n, n);
        this.checkEnabled();
    }

    public void down() {
        int n = this.m_Table.getSelectedRow();
        this.m_Model.moveDown(n);
        this.m_Table.setRowSelectionInterval(++n, n);
        this.checkEnabled();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.checkEnabled();
        }
    }

    public void edit(int n) {
        WizardDialog wizardDialog = (WizardDialog)this.m_Wizard.getContainer();
        InputTestDialog inputTestDialog = new InputTestDialog(wizardDialog, ((InputGO)this.m_GO).getSchema(), this.m_Model.getChoices()[n]);
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.showModal(inputTestDialog);
        if (inputTestDialog.isOk()) {
            this.m_Model.fireTableCellUpdated(n, 0);
        }
    }

    private void checkEnabled() {
        int n = this.m_Table.getSelectedRow();
        this.m_Up.setEnabled(n > 0);
        this.m_Down.setEnabled(n >= 0 && n < this.m_Table.getRowCount() - 1);
    }

    private class Model
    extends ElxTableModel {
        private DataFlowGO[] m_Choices;

        public Model() {
            super(I18N.ENSEMBLE, COLUMNS);
            this.m_Choices = ((InputGO)InputPage.this.m_GO).getOutFlows();
        }

        @Override
        public int getRowCount() {
            return this.m_Choices.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.m_Choices[n].getUserProperty("Input_Test");
            }
            return ((InOutGO)this.m_Choices[n].getStopGO()).getText();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.m_Choices[n].setUserProperty("Input_Test", String.valueOf(object));
        }

        public void moveUp(int n) {
            DataFlowGO dataFlowGO = this.m_Choices[n];
            this.m_Choices[n] = this.m_Choices[n - 1];
            this.m_Choices[n - 1] = dataFlowGO;
            this.fireTableDataChanged();
        }

        public void moveDown(int n) {
            DataFlowGO dataFlowGO = this.m_Choices[n];
            this.m_Choices[n] = this.m_Choices[n + 1];
            this.m_Choices[n + 1] = dataFlowGO;
            this.fireTableDataChanged();
        }

        public DataFlowGO[] getChoices() {
            return this.m_Choices;
        }

        public String duplicate() {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < this.m_Choices.length; ++i) {
                String string = ((InOutGO)this.m_Choices[i].getStopGO()).getText();
                if (hashSet.contains(string)) {
                    return string;
                }
                hashSet.add(string);
            }
            return null;
        }
    }

    private class ML
    extends MouseAdapter {
        private ML() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point;
            int n;
            if (mouseEvent.getClickCount() == 2 && InputPage.this.m_Table.isEnabled() && (n = InputPage.this.m_Table.rowAtPoint(point = mouseEvent.getPoint())) >= 0) {
                InputPage.this.edit(n);
            }
        }
    }
}

