/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.subflow;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.DataFlowGO;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.ClipboardUtil;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InputTestDialog
extends JDialog {
    public static final String INPUT_TEST = "Input_Test";
    protected final ArchLayout m_Layout = new ArchLayout();
    protected boolean m_IsOk;
    protected JButton m_Ok;
    protected JButton m_Cancel;
    DataSchema m_BaseSchema;
    DataFlowGO m_FlowGO;
    JTextField m_Value;
    JList m_AvailableFields;

    public InputTestDialog(JDialog jDialog, DataSchema dataSchema, DataFlowGO dataFlowGO) {
        super((Dialog)jDialog, true);
        this.m_BaseSchema = dataSchema;
        this.m_FlowGO = dataFlowGO;
        this.setTitle(((InOutGO)this.m_FlowGO.getStopGO()).getText());
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.buildUI(), "Center");
        this.getContentPane().add((Component)this.buildSouth(), "South");
        this.m_AvailableFields.setModel(this.getAvailableFields());
        this.setupConstraints();
        this.packAndSize();
        this.setLocationRelativeTo(jDialog);
    }

    protected JPanel buildUI() {
        JPanel jPanel = new JPanel(this.m_Layout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(SwingFactory.newLabel("value-label"));
        this.m_Value = SwingFactory.newTextField("value", 32);
        jPanel.add(this.m_Value);
        jPanel.add(SwingFactory.newLabel("fields-label"));
        this.m_AvailableFields = SwingFactory.newList();
        this.m_AvailableFields.addMouseListener(new ML());
        this.m_AvailableFields.setToolTipText(I18N.ENSEMBLE.getString("DerivativeColumnDialog.TIP"));
        jPanel.add(SwingFactory.newScrollPane("fields", this.m_AvailableFields));
        this.m_Value.setText(this.m_FlowGO.getUserProperty(INPUT_TEST));
        I18N.ENSEMBLE_MAP.injectComponents("InputTestDialog.", jPanel);
        jPanel.setPreferredSize(new Dimension(200, 200));
        return jPanel;
    }

    protected void setupConstraints() {
        this.m_Layout.stickLeft("value-label");
        this.m_Layout.vCenter("value-label", "value");
        this.m_Layout.putRight("value", "value-label,fields-label", 10);
        this.m_Layout.stickRight("value");
        this.m_Layout.stickTop("value");
        this.m_Layout.stickLeft("fields-label");
        this.m_Layout.alignBelow("fields", "value", 5);
        this.m_Layout.vCenter("fields-label", "fields");
        this.m_Layout.stickRight("fields");
        this.m_Layout.stickBottom("fields");
    }

    protected void packAndSize() {
        this.pack();
        Dimension dimension = this.getPreferredSize();
        this.setSize(dimension.width * 2, dimension.height);
    }

    public void ok() {
        this.m_IsOk = true;
        this.m_FlowGO.setUserProperty(INPUT_TEST, this.m_Value.getText());
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public boolean isOk() {
        return this.m_IsOk;
    }

    protected JPanel buildSouth() {
        this.m_Ok = SwingFactory.newOkButton(new CodeBlock((Object)this, "ok"));
        this.m_Cancel = SwingFactory.newCancelButton(new CodeBlock((Object)this, "cancel"));
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.m_Ok);
        jPanel.add(this.m_Cancel);
        this.getRootPane().setDefaultButton(this.m_Ok);
        Bundle.ARCH_MAP.injectComponents(null, jPanel);
        return jPanel;
    }

    private DefaultListModel getAvailableFields() {
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        if (this.m_BaseSchema != null) {
            int n = this.m_BaseSchema.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.m_BaseSchema.getColumnName(i);
                if (!StringUtil.notEmpty((String)object)) continue;
                char c = ((String)object).charAt(0);
                if (!Character.isJavaIdentifierStart(c)) {
                    object = "_" + (String)object;
                }
                if (!InputTestDialog.isValidJavaName((String)object)) {
                    object = "this[\"" + (String)object + "\"]";
                }
                defaultListModel.addElement(object);
            }
        }
        return defaultListModel;
    }

    private static boolean isValidJavaName(String string) {
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private class ML
    extends MouseAdapter {
        private ML() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            String string;
            if (mouseEvent.getClickCount() == 2 && StringUtil.notEmpty(string = (String)InputTestDialog.this.m_AvailableFields.getSelectedValue())) {
                ClipboardUtil.setText(string);
                InputTestDialog.this.m_Value.paste();
                InputTestDialog.this.m_Value.requestFocus();
            }
        }
    }
}

