/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IUser;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.ITabComponent;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.UnitField;
import com.elixirtech.util.CodeBlock;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;

public class ERDGlobalProperties
extends TabComponent
implements ITabComponent {
    public static final String CONSTRUCTION_LINE_COLOR = "ERD-Construction-Line";
    public static final String RULER_LINE_COLOR = "ERD-Ruler-Line";
    public static final String USER_PREFERRED_UNITS = "PreferredUnits";
    public static final String USER_CONSTRUCTION_LINES = "ConstructionLines";
    public static final String USER_RULER_LINES = "RulerLines";
    private IUser m_User = (IUser)Elixir.get(IUser.class);
    private ArchLayout m_Layout = new ArchLayout();
    private JComboBox m_Units;
    private JButton m_ConstructionColor;
    private JButton m_RulerLinesColor;

    public ERDGlobalProperties() {
        this.setLayout(this.m_Layout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(SwingFactory.newLabel("unit-label"));
        this.m_Units = SwingFactory.newComboBox("unit", UnitField.MEASURES);
        this.add(this.m_Units);
        this.add(SwingFactory.newLabel("cons-label"));
        this.m_ConstructionColor = SwingFactory.newDotsButton("cons", new CodeBlock((Object)this, "constructionColor"));
        this.add(this.m_ConstructionColor);
        this.add(SwingFactory.newLabel("rul-label"));
        this.m_RulerLinesColor = SwingFactory.newDotsButton("rul", new CodeBlock((Object)this, "rulerLinesColor"));
        this.add(this.m_RulerLinesColor);
        this.m_Layout.stickTop("unit");
        this.m_Layout.stickLeft("unit-label");
        this.m_Layout.vCenter("unit-label", "unit");
        this.m_Layout.putRight("unit", "unit-label,cons-label,rul-label", 10);
        this.m_Layout.stickLeft("cons-label");
        this.m_Layout.vCenter("cons-label", "cons");
        this.m_Layout.alignBelow("cons", "unit");
        this.m_Layout.stickLeft("rul-label");
        this.m_Layout.vCenter("rul-label", "rul");
        this.m_Layout.alignBelow("rul", "cons");
        int n = this.m_User.getInt(USER_PREFERRED_UNITS, 0);
        UnitField.setPreferredUnits(n);
        this.m_Units.setSelectedIndex(n);
        Color color = StandardColor.lookup(this.m_User.getString(USER_CONSTRUCTION_LINES, "Gray"));
        this.m_ConstructionColor.setBackground(color);
        StandardColor.registerUserColor(CONSTRUCTION_LINE_COLOR, color);
        color = StandardColor.lookup(this.m_User.getString(USER_RULER_LINES, "Gray"));
        this.m_RulerLinesColor.setBackground(color);
        StandardColor.registerUserColor(RULER_LINE_COLOR, color);
        I18N.ERD_MAP.injectComponents("ERDGlobalProperties.", this);
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("ERDGlobalProperties.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("ERDGlobalProperties.message");
    }

    @Override
    public void performFinish() {
        int n = this.m_Units.getSelectedIndex();
        this.m_User.setInt(USER_PREFERRED_UNITS, n);
        UnitField.setPreferredUnits(n);
        Color color = this.m_ConstructionColor.getBackground();
        StandardColor.registerUserColor(CONSTRUCTION_LINE_COLOR, color);
        this.m_User.setString(USER_CONSTRUCTION_LINES, StandardColor.getColorName(color));
        color = this.m_RulerLinesColor.getBackground();
        StandardColor.registerUserColor(RULER_LINE_COLOR, color);
        this.m_User.setString(USER_RULER_LINES, StandardColor.getColorName(color));
    }

    public void constructionColor() {
        String string = I18N.ERD.getString("GlobalProperties.ConstructionLines");
        Color color = JColorChooser.showDialog(this, string, this.m_ConstructionColor.getBackground());
        if (color != null) {
            this.m_ConstructionColor.setBackground(color);
        }
    }

    public void rulerLinesColor() {
        String string = I18N.ERD.getString("GlobalProperties.RulerLines");
        Color color = JColorChooser.showDialog(this, string, this.m_RulerLinesColor.getBackground());
        if (color != null) {
            this.m_RulerLinesColor.setBackground(color);
        }
    }
}

