/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.repository.BasicRepositoryActions;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.erd.images.Icons;
import com.elixirtech.erd.reportdesigner.ERDAction;
import com.elixirtech.erd.reportdesigner.style.StylesheetTab;
import com.elixirtech.erd.reportdesigner.style.StylesheetUtil;
import com.elixirtech.erd.reportdesigner.style.StylesheetWizard;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.report2.raw.model.Stylesheet;
import com.elixirtech.v2.repository.FileObject;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.Action;

public class StylesheetFileType
extends FileType {
    public static final String MIME_TYPE = "application/x-repository-stylesheet";
    public static final DataFlavor STYLESHEET_FLAVOR = new DataFlavor("application/x-repository-stylesheet", null);
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(StylesheetFileType.class);

    public StylesheetFileType() {
        super("Report StyleSheet", "rss", Icons.STYLESHEET, STYLESHEET_FLAVOR);
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public Action getAddAction(FileObject fileObject) {
        return new AddStyleSheet(fileObject);
    }

    @Override
    public Action getPropertiesAction(FileObject fileObject) {
        return null;
    }

    @Override
    public Action[] getPopupActions(FileObject fileObject) {
        return new Action[]{BasicRepositoryActions.getOpenFile(fileObject)};
    }

    @Override
    public IPanelView createView(FileObject fileObject) {
        try {
            Stylesheet stylesheet = StylesheetUtil.read(fileObject);
            return new StylesheetTab(stylesheet);
        }
        catch (IOException iOException) {
            ElixirJ.error(I18NUtil.getString(Bundle.ARCH, "Error.CANT_READ_FILE_X", fileObject.getName()), iOException);
            return null;
        }
    }

    private static class AddStyleSheet
    extends ERDAction {
        private FileObject m_FileObject;

        public AddStyleSheet(FileObject fileObject) {
            super("Repository.AddStylesheet");
            this.m_FileObject = fileObject;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            m_Log.info((Object)("add stylesheet " + String.valueOf(this.m_FileObject.getPath())));
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(new StylesheetWizard(this.m_FileObject));
        }
    }
}

