/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.images;

import com.elixirtech.erd.images.ImageInfo;
import com.elixirtech.glint.viewer.ViewerCanvas;
import com.elixirtech.util.FileUtil;
import com.elixirtech.v2.repository.FileObject;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageCanvas
extends ViewerCanvas {
    private ImageInfo m_ImageInfo;
    private List<ImageIcon> m_ImageIcons = new ArrayList<ImageIcon>();
    protected boolean m_Scrolled = true;

    public ImageCanvas() {
    }

    public ImageCanvas(FileObject fileObject) {
        this.setObject(fileObject);
    }

    public void setScrolled(boolean bl) {
        this.m_Scrolled = bl;
    }

    public boolean isScrolled() {
        return this.m_Scrolled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(Object object) {
        block11: {
            try {
                if (object instanceof File) {
                    File file = (File)object;
                    try {
                        ZipFile zipFile = new ZipFile(file);
                        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                        while (enumeration.hasMoreElements()) {
                            ZipEntry zipEntry = enumeration.nextElement();
                            if (zipEntry.isDirectory()) continue;
                            InputStream inputStream = zipFile.getInputStream(zipEntry);
                            this.read(inputStream);
                        }
                        zipFile.close();
                    }
                    catch (IOException iOException) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        this.m_ImageInfo = new ImageInfo();
                        this.m_ImageInfo.setInput(fileInputStream);
                        this.read(new FileInputStream(file));
                    }
                    break block11;
                }
                if (!(object instanceof FileObject)) break block11;
                FileObject fileObject = (FileObject)object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try (InputStream inputStream = fileObject.getInputStream();){
                    FileUtil.copyStream(inputStream, byteArrayOutputStream);
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.m_ImageInfo = new ImageInfo();
                this.m_ImageInfo.setInput(new ByteArrayInputStream(byArray));
                this.read(new ByteArrayInputStream(byArray));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.print(fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                System.err.print(iOException.getMessage());
            }
        }
        this.m_PageNo = 1;
    }

    @Override
    public void read(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        bufferedInputStream.close();
        if (bufferedImage != null) {
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            if (this.m_ImageIcons.size() == 0) {
                int n = imageIcon.getIconHeight();
                int n2 = imageIcon.getIconWidth();
                this.m_Dimension = new Dimension(n2, n);
            }
            this.m_ImageIcons.add(imageIcon);
        }
        this.m_PageNo = 1;
    }

    @Override
    public void update() {
        this.updateSize();
        this.repaint();
    }

    @Override
    public int getPageCount() {
        return this.m_ImageIcons.size();
    }

    public String getStatus() {
        if (this.m_ImageIcons.size() > 0) {
            return "Image loaded";
        }
        return "Image not Loaded";
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.m_PageNo - 1;
        if (n < 0 || n >= this.m_ImageIcons.size()) {
            return;
        }
        ImageIcon imageIcon = this.m_ImageIcons.get(n);
        if (imageIcon != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.scale((float)this.m_ZoomPercent / 100.0f, (float)this.m_ZoomPercent / 100.0f);
            imageIcon.paintIcon(this, graphics2D, 0, 0);
        }
    }

    public ImageInfo getImageInfo() {
        return this.m_ImageInfo;
    }

    protected void updateSize() {
        int n = this.m_PageNo - 1;
        if (n < 0 || n >= this.m_ImageIcons.size()) {
            return;
        }
        ImageIcon imageIcon = this.m_ImageIcons.get(n);
        if (imageIcon != null) {
            int n2 = imageIcon.getIconWidth();
            int n3 = imageIcon.getIconHeight();
            n2 = n2 * this.m_ZoomPercent / 100;
            n3 = n3 * this.m_ZoomPercent / 100;
            this.m_Dimension = new Dimension(n2, n3);
        } else {
            this.m_Dimension = DEFAULT_SIZE;
        }
        this.invalidate();
        if (this.m_Scrolled) {
            this.getParent().getParent().getParent().validate();
        }
    }
}

