/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.images;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.erd.images.ImageCanvas;
import com.elixirtech.erd.images.ImageInfo;
import com.elixirtech.erd.reportdesigner.ERDAction;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.ui.viewer.ViewerToolBar;
import com.elixirtech.v2.repository.FileObject;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class OpenImage
extends ERDAction {
    private FileObject m_FileObject;
    private static final String[] TEXT = new String[]{"ImageViewer.FileFormat", "ImageViewer.MIMEType", "ImageViewer.Width", "ImageViewer.Height", "ImageViewer.BPP", "ImageViewer.Pixels"};

    public OpenImage(FileObject fileObject) {
        super("OpenImage");
        this.m_FileObject = fileObject;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        JDialog jDialog = new JDialog((Frame)elixirFrame.getFrame(), this.m_FileObject.getName());
        Container container = jDialog.getContentPane();
        ViewerToolBar viewerToolBar = new ViewerToolBar(4);
        jDialog.setDefaultCloseOperation(2);
        ImageCanvas imageCanvas = new ImageCanvas(this.m_FileObject);
        viewerToolBar.setViewer(imageCanvas);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jTextArea.setEditable(false);
        container.add((Component)viewerToolBar, "North");
        container.add((Component)new JScrollPane(imageCanvas), "Center");
        container.add((Component)jTextArea, "South");
        ImageInfo imageInfo = imageCanvas.getImageInfo();
        if (imageInfo != null && imageInfo.check()) {
            String[] stringArray = I18NUtil.getStrings(I18N.ERD, TEXT);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(stringArray[0]).append(" ").append(imageInfo.getFormatName()).append('\n');
            stringBuffer.append(stringArray[1]).append(" ").append(imageInfo.getMimeType()).append('\n');
            stringBuffer.append(stringArray[2]).append(" ").append(imageInfo.getWidth()).append(" ").append(stringArray[5]).append('\n');
            stringBuffer.append(stringArray[3]).append(" ").append(imageInfo.getHeight()).append(" ").append(stringArray[5]).append('\n');
            stringBuffer.append(stringArray[4]).append(" ").append(imageInfo.getBitsPerPixel());
            jTextArea.setText(stringBuffer.toString());
        }
        jDialog.pack();
        jDialog.setSize(new Dimension(400, 500));
        jDialog.setLocationRelativeTo(elixirFrame.getFrame());
        elixirFrame.showModal(jDialog);
    }
}

