/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner;

import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.Group;
import com.elixirtech.report2.raw.model.GroupFooter;
import com.elixirtech.report2.raw.model.GroupHeader;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class ChunkComboRenderer
extends DefaultListCellRenderer {
    private static final Map<String, String> TITLES = new HashMap<String, String>();

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (object instanceof Chunk) {
            jLabel.setText(this.getName((Chunk)object));
        } else {
            jLabel.setText("");
        }
        return jLabel;
    }

    private String getName(Chunk chunk) {
        Group group;
        String string = chunk.getTagName();
        String string2 = TITLES.get(string);
        if (string2 == null) {
            return string;
        }
        if ("group-header".equals(string)) {
            group = ((GroupHeader)chunk).getGroup();
            string2 = MessageFormat.format(string2, group.getField());
        }
        if ("group-footer".equals(string)) {
            group = ((GroupFooter)chunk).getGroup();
            string2 = MessageFormat.format(string2, group.getField());
        }
        return string2;
    }

    static {
        TITLES.put("section-header", I18N.ERD.getString("SECTION_HEADER"));
        TITLES.put("page-header", I18N.ERD.getString("PAGE_HEADER"));
        TITLES.put("group-header", I18N.ERD.getString("GROUP_HEADER"));
        TITLES.put("detail", I18N.ERD.getString("DETAIL"));
        TITLES.put("group-footer", I18N.ERD.getString("GROUP_FOOTER"));
        TITLES.put("page-footer", I18N.ERD.getString("PAGE_FOOTER"));
        TITLES.put("section-footer", I18N.ERD.getString("SECTION_FOOTER"));
    }
}

