/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner;

import com.elixirtech.erd.reportdesigner.BasicToolBar;
import com.elixirtech.erd.reportdesigner.LayoutTab;
import com.elixirtech.erd.reportdesigner.tool.CubeTableBeanFactory;
import com.elixirtech.erd.reportdesigner.tool.HBoxBeanFactory;
import com.elixirtech.erd.reportdesigner.tool.LineCreationTool;
import com.elixirtech.erd.reportdesigner.tool.LiteralFieldBeanFactory;
import com.elixirtech.erd.reportdesigner.tool.RectCreationTool;
import com.elixirtech.erd.reportdesigner.tool.SelectionTool;
import com.elixirtech.erd.reportdesigner.tool.StyledTool;
import com.elixirtech.erd.reportdesigner.tool.TableBeanFactory;
import com.elixirtech.erd.reportdesigner.tool.Tool;
import com.elixirtech.erd.reportdesigner.tool.UiElementBeanFactory;
import com.elixirtech.erd.reportdesigner.tool.VBoxBeanFactory;
import com.elixirtech.erd.reportdesigner.tool.select.ResizeAlignmentTool;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Barcode;
import com.elixirtech.report2.raw.model.CallbackElement;
import com.elixirtech.report2.raw.model.Chart;
import com.elixirtech.report2.raw.model.CheckBox;
import com.elixirtech.report2.raw.model.CompositeChart;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.model.Grid;
import com.elixirtech.report2.raw.model.Image;
import com.elixirtech.report2.raw.model.Line;
import com.elixirtech.report2.raw.model.MapElement;
import com.elixirtech.report2.raw.model.PageBreak;
import com.elixirtech.report2.raw.model.RTF;
import com.elixirtech.report2.raw.model.Rectangle;
import com.elixirtech.report2.raw.model.SVG;
import com.elixirtech.report2.raw.model.SubReport;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class ComponentToolBar
extends BasicToolBar {
    private static final String[] COMPONENTS = new String[]{"Component.Selection", "Component.Label", "Component.DataField", "Component.DataGrid", "Component.Image", "Component.CheckBox", "Component.Line", "Component.Rectangle", "Component.Table", "Component.HBox", "Component.VBox", "Component.SubReport", "Component.PageBreak", "Component.Barcode", "Component.Chart", "Component.CompositeChart", "Component.Map", "Component.SVG", "Component.RTF", "Component.CubeTable", "Component.Callback"};
    LayoutTab m_LayoutTab;
    private ButtonGroup m_ButtonGroup = new ButtonGroup();
    private JToggleButton m_SelectionButton;
    private SelectionTool m_SelectionTool;
    private final Border m_toolBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.WHITE), BorderFactory.createEmptyBorder(3, 3, 3, 3));

    public ComponentToolBar(LayoutTab layoutTab) {
        this.m_LayoutTab = layoutTab;
        this.m_SelectionTool = new ResizeAlignmentTool();
        String[] stringArray = I18NUtil.getStrings(I18N.ERD, COMPONENTS);
        this.m_SelectionButton = (JToggleButton)this.add(new ToolAction(ERDIcons.SELECTION, this.m_SelectionTool), stringArray[0]);
        this.add(new ToolAction(ERDIcons.LABEL, new RectCreationTool(new LiteralFieldBeanFactory(), this)), stringArray[1]);
        this.add(new ToolAction(ERDIcons.TEXT, new RectCreationTool(new UiElementBeanFactory(Field.class), this)), stringArray[2]);
        this.add(new ToolAction(ERDIcons.GRID, new RectCreationTool(new UiElementBeanFactory(Grid.class), this)), stringArray[3]);
        this.add(new ToolAction(ERDIcons.IMAGE, new RectCreationTool(new UiElementBeanFactory(Image.class), this)), stringArray[4]);
        this.add(new ToolAction(ERDIcons.CHECKBOX, new RectCreationTool(new UiElementBeanFactory(CheckBox.class), this)), stringArray[5]);
        this.add(new ToolAction(ERDIcons.LINE, new LineCreationTool(new UiElementBeanFactory(Line.class), this)), stringArray[6]);
        this.add(new ToolAction(ERDIcons.RECTANGLE, new RectCreationTool(new UiElementBeanFactory(Rectangle.class), this)), stringArray[7]);
        this.add(new ToolAction(ERDIcons.TABLE, new RectCreationTool(new TableBeanFactory(), this)), stringArray[8]);
        this.add(new ToolAction(ERDIcons.HORIZONTAL_BOX, new RectCreationTool(new HBoxBeanFactory(), this)), stringArray[9]);
        this.add(new ToolAction(ERDIcons.VERTICAL_BOX, new RectCreationTool(new VBoxBeanFactory(), this)), stringArray[10]);
        this.add(new ToolAction(ERDIcons.SUB_REPORT, new RectCreationTool(new UiElementBeanFactory(SubReport.class), this)), stringArray[11]);
        this.add(new ToolAction(ERDIcons.PAGE_BREAK, new RectCreationTool(new UiElementBeanFactory(PageBreak.class), this)), stringArray[12]);
        this.add(new ToolAction(ERDIcons.BARCODE, new RectCreationTool(new UiElementBeanFactory(Barcode.class), this)), stringArray[13]);
        this.add(new ToolAction(ERDIcons.CHART, new RectCreationTool(new UiElementBeanFactory(Chart.class), this)), stringArray[14]);
        this.add(new ToolAction(ERDIcons.COMPOSITE_CHART, new RectCreationTool(new UiElementBeanFactory(CompositeChart.class), this)), stringArray[15]);
        this.add(new ToolAction(ERDIcons.MAP, new RectCreationTool(new UiElementBeanFactory(MapElement.class), this)), stringArray[16]);
        this.add(new ToolAction(ERDIcons.SVG, new RectCreationTool(new UiElementBeanFactory(SVG.class), this)), stringArray[17]);
        this.add(new ToolAction(ERDIcons.RTF, new RectCreationTool(new UiElementBeanFactory(RTF.class), this)), stringArray[18]);
        this.add(new ToolAction(ERDIcons.CUBE, new RectCreationTool(new CubeTableBeanFactory(), this)), stringArray[19]);
        this.add(new ToolAction(ERDIcons.CALLBACK, new RectCreationTool(new UiElementBeanFactory(CallbackElement.class), this)), stringArray[20]);
        this.selectSelectionTool();
    }

    public void setReadOnly(boolean bl) {
        JToolBar jToolBar = this.getToolBar();
        int n = jToolBar.getComponentCount();
        for (int i = 1; i < n; ++i) {
            jToolBar.getComponent(i).setEnabled(!bl);
        }
    }

    public void selectSelectionTool() {
        this.m_SelectionButton.setSelected(true);
        this.m_LayoutTab.setCurrentTool(this.m_SelectionTool);
        this.m_SelectionButton.setBorder(this.m_toolBorder);
        this.m_SelectionButton.setRolloverEnabled(true);
    }

    public JComponent add(ToolAction toolAction, String string) {
        JToggleButton jToggleButton = new JToggleButton(toolAction);
        jToggleButton.setBorder(this.m_toolBorder);
        jToggleButton.setToolTipText(string);
        jToggleButton.setRolloverEnabled(true);
        jToggleButton.setBorderPainted(false);
        if (toolAction.getTool() instanceof StyledTool) {
            jToggleButton.addMouseListener(new PopupListener((StyledTool)toolAction.getTool()));
        }
        this.m_ButtonGroup.add(jToggleButton);
        this.getToolBar().add(jToggleButton);
        return jToggleButton;
    }

    protected String[] getStyleNames() {
        return this.m_LayoutTab.getReport().getStyleNames();
    }

    private class ToolAction
    extends AbstractAction {
        private Tool m_Tool;

        public ToolAction(Icon icon, Tool tool) {
            super(null, icon);
            this.m_Tool = tool;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ComponentToolBar.this.m_LayoutTab.setCurrentTool(this.m_Tool);
        }

        public Tool getTool() {
            return this.m_Tool;
        }
    }

    private class PopupListener
    extends MouseAdapter
    implements ActionListener {
        private StyledTool m_Tool;
        private final Color m_bgColor = new Color(151, 163, 204);

        public PopupListener(StyledTool styledTool) {
            this.m_Tool = styledTool;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            ((JToggleButton)mouseEvent.getSource()).setBorderPainted(true);
            ((JToggleButton)mouseEvent.getSource()).setBackground(this.m_bgColor);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ((JToggleButton)mouseEvent.getSource()).setBorderPainted(false);
            ((JToggleButton)mouseEvent.getSource()).setBackground(null);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.doPopup(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.doPopup(mouseEvent);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.m_Tool.setStyle(actionEvent.getActionCommand());
        }

        protected void doPopup(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            String[] stringArray = ComponentToolBar.this.getStyleNames();
            String string = I18N.ERD.getString("ComponentToolBar.no-styles");
            if (stringArray.length == 0) {
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.setEnabled(false);
                jPopupMenu.add(jMenuItem);
            } else {
                String string2 = this.m_Tool.getStyle();
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("<" + string + ">");
                jRadioButtonMenuItem.setActionCommand(null);
                if (string2 == null) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null || stringArray[i].length() == 0) {
                        jRadioButtonMenuItem = new JRadioButtonMenuItem("<" + string + ">");
                        if (string2 == null || string2.length() == 0) {
                            jRadioButtonMenuItem.setSelected(true);
                        }
                    } else {
                        jRadioButtonMenuItem = new JRadioButtonMenuItem(stringArray[i]);
                        if (stringArray[i].equals(string2)) {
                            jRadioButtonMenuItem.setSelected(true);
                        }
                    }
                    jRadioButtonMenuItem.setActionCommand(stringArray[i]);
                    jRadioButtonMenuItem.addActionListener(this);
                    jPopupMenu.add(jRadioButtonMenuItem);
                }
            }
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

