/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner;

import com.elixirtech.arch.IDirtyState;
import com.elixirtech.arch.js.ScriptEditor;
import com.elixirtech.editor.JEditor;
import com.elixirtech.erd.reportdesigner.ChunkComboRenderer;
import com.elixirtech.erd.reportdesigner.CodeBlockAction;
import com.elixirtech.erd.reportdesigner.LayoutTab;
import com.elixirtech.erd.reportdesigner.ScriptSummary;
import com.elixirtech.erd.reportdesigner.SectionComboRenderer;
import com.elixirtech.erd.util.DerivedComboBoxModel;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.Detail;
import com.elixirtech.report2.raw.model.Group;
import com.elixirtech.report2.raw.model.GroupHeader;
import com.elixirtech.report2.raw.model.PageFooter;
import com.elixirtech.report2.raw.model.PageHeader;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.SectionFooter;
import com.elixirtech.report2.raw.model.SectionHeader;
import com.elixirtech.report2.raw.property.PropertyTypes;
import com.elixirtech.sax.ChangeNotifier;
import com.elixirtech.ui.CurrentTab;
import com.elixirtech.ui.ElxTabbedPane;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FunctionsPanel
extends JPanel
implements CurrentTab,
ItemListener,
TreeSelectionListener {
    protected RawReport m_Report;
    protected JComboBox m_SectionCombo;
    protected DerivedComboBoxModel<Section> m_SectionModel;
    protected JComboBox m_ChunkCombo;
    protected JTree m_Tree;
    protected ElxTabbedPane m_EditorPanel;
    protected CodeBlockAction m_Cut;
    protected CodeBlockAction m_Copy;
    protected CodeBlockAction m_Paste;
    protected CodeBlockAction m_SaveAs;
    protected CodeBlockAction m_Print;
    protected EditorTab m_FunctionDefinitions;
    protected ScriptSummary m_ScriptSummary;

    public FunctionsPanel(RawReport rawReport) {
        this.m_Report = rawReport;
        this.m_SectionModel = new DerivedComboBoxModel((ChangeNotifier)this.m_Report, this.m_Report.getSectionList(), "RawReport.Section");
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        JToolBar jToolBar = SwingFactory.newToolBar();
        this.m_Cut = new CodeBlockAction("Cut", this, "cut");
        this.m_Cut.setEnabled(false);
        jToolBar.add(this.m_Cut);
        this.m_Copy = new CodeBlockAction("Copy", this, "copy");
        this.m_Copy.setEnabled(false);
        jToolBar.add(this.m_Copy);
        this.m_Paste = new CodeBlockAction("Paste", this, "paste");
        jToolBar.add(this.m_Paste);
        this.m_SaveAs = new CodeBlockAction("SaveAs", this, "saveAs");
        this.m_Print = new CodeBlockAction("Print", this, "print");
        jToolBar.add(Box.createHorizontalGlue());
        this.add((Component)jToolBar, "North");
        this.m_EditorPanel = new ElxTabbedPane();
        this.m_ScriptSummary = new ScriptSummary(this, this.m_Report);
        this.m_FunctionDefinitions = new EditorTab(this.m_Report.getProperty(new Name("RawReport.FunctionDefinitions")));
        this.m_EditorPanel.addTab(I18N.ERD.getString("FunctionsPanel.script-summary"), this.m_ScriptSummary.getComponent());
        this.m_EditorPanel.addTab(I18N.ERD.getString("FunctionsPanel.function-definitions"), this.m_FunctionDefinitions);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        this.m_SectionCombo = SwingFactory.newComboBox("section-combo", this.m_SectionModel);
        this.m_SectionCombo.setRenderer(new SectionComboRenderer());
        this.m_SectionCombo.addItemListener(this);
        this.m_ChunkCombo = SwingFactory.newComboBox("chunk-combo");
        this.m_ChunkCombo.setRenderer(new ChunkComboRenderer());
        this.m_ChunkCombo.addItemListener(this);
        jPanel2.add(this.m_SectionCombo);
        jPanel2.add(this.m_ChunkCombo);
        this.m_Tree = new JTree((TreeModel)null);
        this.m_Tree.setCellRenderer(new LayoutTab.ShapeTreeRenderer());
        this.m_Tree.addTreeSelectionListener(this);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add(new JScrollPane(this.m_Tree));
        JSplitPane jSplitPane = SwingFactory.newHorizontalSplit(this.m_EditorPanel, new JScrollPane(jPanel));
        jSplitPane.setDividerLocation(650);
        jSplitPane.setResizeWeight(1.0);
        this.add(jSplitPane);
        if (this.m_SectionCombo.getItemCount() > 0) {
            this.chooseSection((Section)this.m_SectionCombo.getItemAt(0));
        }
        I18N.ERD_MAP.injectComponents("FunctionsPanel.", this);
    }

    public boolean isReadOnly() {
        return this.m_Report.getSecurity().isReadOnly();
    }

    public void showFunction(PropertyHolder propertyHolder, Property property) {
        if (propertyHolder instanceof Chunk) {
            Chunk chunk = (Chunk)propertyHolder;
            this.chooseSection(chunk.getSection());
            this.chooseChunk(chunk);
            this.chooseProperty(property);
        } else if (propertyHolder instanceof RawModelElement) {
            RawModelElement rawModelElement = (RawModelElement)propertyHolder;
            Chunk chunk = rawModelElement.getChunk();
            this.chooseSection(chunk.getSection());
            this.chooseChunk(chunk);
            this.choosePropertyHolder((PropertyHolder)rawModelElement);
            this.chooseProperty(property);
        }
    }

    @Override
    public void setCurrent(boolean bl) {
        if (this.m_SectionCombo.getItemCount() > 0) {
            Section section = (Section)this.m_SectionCombo.getSelectedItem();
            this.buildChunkCombo(section);
        }
        this.m_EditorPanel.setCurrent(bl);
        this.checkEnabled();
    }

    public void cut() {
        CurrentTab currentTab = this.m_EditorPanel.getCurrentTab();
        if (currentTab instanceof EditorTab) {
            EditorTab editorTab = (EditorTab)currentTab;
            editorTab.cut();
            editorTab.requestFocus();
        }
    }

    public void copy() {
        CurrentTab currentTab = this.m_EditorPanel.getCurrentTab();
        if (currentTab instanceof EditorTab) {
            EditorTab editorTab = (EditorTab)currentTab;
            editorTab.copy();
            editorTab.requestFocus();
        }
    }

    public void paste() {
        CurrentTab currentTab = this.m_EditorPanel.getCurrentTab();
        if (currentTab instanceof EditorTab) {
            EditorTab editorTab = (EditorTab)currentTab;
            editorTab.paste();
            editorTab.requestFocus();
        }
    }

    public void saveAs() {
    }

    public void print() {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_SectionCombo) {
            this.chooseSection((Section)this.m_SectionCombo.getSelectedItem());
        } else if (itemEvent.getSource() == this.m_ChunkCombo) {
            this.chooseChunk((Chunk)this.m_ChunkCombo.getSelectedItem());
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = this.m_Tree.getSelectionPath();
        if (treePath != null) {
            this.choosePropertyHolder((PropertyHolder)treePath.getLastPathComponent());
        }
    }

    protected void buildChunkCombo(Section section) {
        List<Chunk> list = FunctionsPanel.getChunks(section);
        Object[] objectArray = new Object[list.size()];
        list.toArray(objectArray);
        this.m_ChunkCombo.setModel(new DefaultComboBoxModel<Object>(objectArray));
    }

    protected void chooseSection(Section section) {
        if (this.m_SectionCombo.getSelectedItem() != section) {
            this.m_SectionCombo.setSelectedItem(section);
        }
        this.buildChunkCombo(section);
        if (this.m_ChunkCombo.getItemCount() > 0) {
            this.chooseChunk((Chunk)this.m_ChunkCombo.getItemAt(0));
        }
    }

    protected void chooseChunk(Chunk chunk) {
        if (this.m_ChunkCombo.getSelectedItem() != chunk) {
            this.m_ChunkCombo.setSelectedItem(chunk);
        }
        Chunk.MyTreeModel myTreeModel = chunk.getTreeModel();
        this.m_Tree.setModel((TreeModel)myTreeModel);
        this.m_Tree.setSelectionPath(new TreePath(new Object[]{myTreeModel.getRoot()}));
        this.choosePropertyHolder((PropertyHolder)chunk);
    }

    protected void choosePropertyHolder(PropertyHolder propertyHolder) {
        Chunk.MyTreeModel myTreeModel = (Chunk.MyTreeModel)this.m_Tree.getModel();
        this.m_Tree.setSelectionPath(myTreeModel.getTreePath((RawModelElement)propertyHolder));
        this.m_EditorPanel.removeAll();
        this.m_EditorPanel.addTab(I18N.ERD.getString("FunctionsPanel.script-summary"), this.m_ScriptSummary.getComponent());
        this.m_EditorPanel.addTab(I18N.ERD.getString("FunctionsPanel.function-definitions"), this.m_FunctionDefinitions);
        HashSet hashSet = new HashSet();
        propertyHolder.getPropertyNames(hashSet);
        TreeSet treeSet = new TreeSet(hashSet);
        for (Name name : treeSet) {
            Property property = propertyHolder.getProperty(name);
            if (property.getType() != PropertyTypes.SCRIPT) continue;
            EditorTab editorTab = new EditorTab(property);
            this.m_EditorPanel.addTab(editorTab.getName(), editorTab);
        }
    }

    protected void chooseProperty(Property property) {
        int n = this.m_EditorPanel.getTabCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.m_EditorPanel.getComponentAt(i);
            if (!(component instanceof EditorTab) || !property.equals((Object)((EditorTab)component).getProperty())) continue;
            this.m_EditorPanel.setSelectedIndex(i);
            break;
        }
    }

    protected static List<Chunk> getChunks(Section section) {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        if (section != null) {
            SectionHeader sectionHeader = section.getSectionHeader();
            PageHeader pageHeader = section.getPageHeader();
            Detail detail = section.getDetail();
            PageFooter pageFooter = section.getPageFooter();
            SectionFooter sectionFooter = section.getSectionFooter();
            List list = section.getGroupList();
            ArrayList<GroupHeader> arrayList2 = new ArrayList<GroupHeader>();
            if (sectionHeader != null && section.isShowSectionHeader()) {
                arrayList.add((Chunk)sectionHeader);
            }
            if (pageHeader != null && section.isShowPageHeader()) {
                arrayList.add((Chunk)pageHeader);
            }
            for (Group group : list) {
                GroupHeader groupHeader;
                if (group.isGroupHeaderVisible() && (groupHeader = group.getGroupHeader()) != null) {
                    arrayList.add((Chunk)groupHeader);
                }
                if (!group.isGroupFooterVisible() || (groupHeader = group.getGroupFooter()) == null) continue;
                arrayList2.add(0, groupHeader);
            }
            if (detail != null) {
                arrayList.add((Chunk)detail);
            }
            arrayList.addAll(arrayList2);
            if (pageFooter != null && section.isShowPageFooter()) {
                arrayList.add((Chunk)pageFooter);
            }
            if (sectionFooter != null && section.isShowSectionFooter()) {
                arrayList.add((Chunk)sectionFooter);
            }
        }
        return arrayList;
    }

    protected void checkEnabled() {
        boolean bl = this.isReadOnly();
        IEditorTab iEditorTab = (IEditorTab)this.m_EditorPanel.getCurrentTab();
        iEditorTab.setEnabled(!bl);
        this.m_Cut.setEnabled(!bl && iEditorTab.canCut());
        this.m_Copy.setEnabled(iEditorTab.canCopy());
        this.m_Paste.setEnabled(!bl && iEditorTab.canPaste());
        this.m_SaveAs.setEnabled(iEditorTab.canSaveAs());
        this.m_Print.setEnabled(iEditorTab.canPrint());
    }

    protected class EditorTab
    extends JPanel
    implements IEditorTab,
    CaretListener {
        protected Property m_Property;
        protected ScriptEditor m_ScriptEditor;
        protected JEditor m_Editor;
        protected JLabel m_LineInfo;
        protected DL m_DL;
        protected String m_Line;
        protected String m_Column;

        public EditorTab(Property property) {
            this.m_DL = new DL();
            this.m_Property = property;
            this.setLayout(new BorderLayout());
            this.m_ScriptEditor = new ScriptEditor();
            this.m_Editor = this.m_ScriptEditor.getEditor();
            this.m_Editor.addDirtyListener(this.m_DL);
            this.m_Editor.setMinimumSize(new Dimension(100, 200));
            this.add(this.m_ScriptEditor.getComponent());
            this.m_Line = I18N.ERD.getString("FunctionsPanel.line-label");
            this.m_Column = I18N.ERD.getString("FunctionsPanel.column-label");
            this.m_LineInfo = SwingFactory.newLabel("lineinfo");
            this.m_LineInfo.setText(this.m_Line + " " + this.m_Column);
            this.m_LineInfo.setFont(UIManager.getFont("Tree.font"));
            this.add((Component)this.m_LineInfo, "South");
            this.m_Editor.addCaretListener(this);
        }

        @Override
        public String getName() {
            if (this.m_Property != null) {
                return this.m_Property.getShortLabel();
            }
            return "EditorTab";
        }

        public Property getProperty() {
            return this.m_Property;
        }

        @Override
        public void setCurrent(boolean bl) {
            if (bl) {
                this.readProperty();
                this.m_ScriptEditor.refresh();
                this.m_Editor.requestFocus();
                this.caretUpdate(null);
                FunctionsPanel.this.checkEnabled();
            } else {
                this.writeProperty();
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            this.m_ScriptEditor.setEnabled(bl);
        }

        @Override
        public void requestFocus() {
            this.m_Editor.requestFocus();
        }

        public JEditor getEditor() {
            return this.m_Editor;
        }

        public void readProperty() {
            this.m_Editor.removeDirtyListener(this.m_DL);
            Script script = (Script)this.m_Property.getValue();
            if (script != null) {
                if (!script.getText().equals(this.m_Editor.getText())) {
                    this.m_Editor.setText(script.getText());
                    this.m_Editor.setCaretPosition(0);
                }
            } else {
                this.m_Editor.setText("");
            }
            this.m_Editor.setDirty(false);
            this.m_Editor.addDirtyListener(this.m_DL);
        }

        public void writeProperty() {
            String string;
            String string2 = this.m_Editor.getText();
            Script script = (Script)this.m_Property.getValue();
            String string3 = string = script != null ? script.getText() : null;
            if (!(script == null && string2.length() <= 0 || string2.equals(string))) {
                this.m_Property.setValue((Object)new Script("javascript", this.m_Editor.getText()));
                FunctionsPanel.this.m_Report.setDirty(true);
            }
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            this.m_LineInfo.setText(this.m_Line + " " + this.line() + " " + this.m_Column + " " + this.column());
            FunctionsPanel.this.checkEnabled();
        }

        public void cut() {
            this.m_Editor.cut();
        }

        public void copy() {
            this.m_Editor.copy();
        }

        public void paste() {
            this.m_Editor.paste();
        }

        @Override
        public boolean canCut() {
            String string = this.m_Editor.getSelectedText();
            return StringUtil.notEmpty(string);
        }

        @Override
        public boolean canCopy() {
            String string = this.m_Editor.getSelectedText();
            return StringUtil.notEmpty(string);
        }

        @Override
        public boolean canPaste() {
            return true;
        }

        @Override
        public boolean canSaveAs() {
            return false;
        }

        @Override
        public boolean canPrint() {
            return false;
        }

        protected int line() {
            return this.m_Editor.getCaretRow() + 1;
        }

        protected int column() {
            return this.m_Editor.getCaretColumn() + 1;
        }
    }

    protected static interface IEditorTab
    extends CurrentTab {
        public boolean canCut();

        public boolean canCopy();

        public boolean canPaste();

        public boolean canSaveAs();

        public boolean canPrint();

        public void setEnabled(boolean var1);
    }

    private class DL
    implements IDirtyState.Listener {
        private DL() {
        }

        @Override
        public void dirtyStateChanged(IDirtyState iDirtyState) {
            if (iDirtyState.isDirty()) {
                FunctionsPanel.this.m_Report.setDirty(true);
            }
        }
    }
}

