/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner;

import com.elixirtech.erd.reportdesigner.Ruler;
import com.elixirtech.report2.raw.model.RulerMark;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Iterator;

public class HorizontalRuler
extends Ruler {
    private static final GeneralPath POLYGON = new GeneralPath();

    public HorizontalRuler(Section section) {
        this.m_Markers = section != null ? section.getRulerMarkList() : new ArrayList();
    }

    public void setSection(Section section) {
        this.m_Markers = section != null ? section.getRulerMarkList() : new ArrayList();
    }

    public void setWidth(int n) {
        this.m_Dimension.width = n;
        this.invalidate();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        graphics2D.setColor(BACKGROUND);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        if (this.m_CurrentRange != null) {
            graphics2D.setColor(HIGHLIGHT);
            int n2 = this.inPixels(this.m_CurrentRange.start);
            n = this.inPixels(this.m_CurrentRange.stop);
            graphics2D.fillRect(n2, 0, n - n2, dimension.height);
        }
        graphics2D.setFont(FONT);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        n = this.inPixels(this.getUnitLength());
        int n3 = fontMetrics.getAscent();
        int n4 = dimension.width / n;
        int n5 = n / this.m_MajorScaleCnt;
        int n6 = n5 / this.m_MinorScaleCnt;
        int n7 = 0;
        for (int i = 0; i <= n4; ++i) {
            graphics2D.setColor(Color.blue);
            graphics2D.drawLine(n7, 2, n7, 15);
            graphics2D.setColor(Color.black);
            int n8 = n7;
            for (int j = 0; j < this.m_MajorScaleCnt; ++j) {
                int n9 = n8;
                for (int k = 0; k < this.m_MinorScaleCnt - 1; ++k) {
                    graphics2D.drawLine(n9 += n6, 9, n9, 15);
                }
                n8 += n5;
                if (j == this.m_MajorScaleCnt - 1) continue;
                graphics2D.drawLine(n8, 6, n8, 15);
            }
            graphics2D.setColor(Color.blue);
            graphics2D.drawString(Integer.toString(i), n7 + 1, n3);
            n7 += n;
        }
        this.drawMarkers(graphics2D);
        graphics2D.setColor(SystemColor.controlShadow);
        graphics2D.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, 15);
    }

    public void drawMarkers(Graphics2D graphics2D) {
        graphics2D.setColor(Color.red);
        for (RulerMark rulerMark : this.m_Markers) {
            int n = this.inPixels(rulerMark.getValue());
            graphics2D.translate(n, 14);
            graphics2D.fill(POLYGON);
            graphics2D.translate(-n, -14);
        }
    }

    public void drawMarkerLines(Graphics2D graphics2D, int n) {
        Iterator iterator;
        Rectangle rectangle = graphics2D.getClipBounds();
        int n2 = 0;
        int n3 = n;
        if (rectangle != null) {
            n2 = rectangle.y;
            n3 = rectangle.y + rectangle.height;
        }
        if ((iterator = this.m_Markers.iterator()).hasNext()) {
            graphics2D.setColor(StandardColor.lookup("ERD-Ruler-Line"));
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(MARKER_LINES);
            while (iterator.hasNext()) {
                RulerMark rulerMark = (RulerMark)iterator.next();
                int n4 = rulerMark.getValue();
                graphics2D.drawLine(n4, n2, n4, n3);
            }
            graphics2D.setStroke(stroke);
        }
    }

    @Override
    protected int getPos(MouseEvent mouseEvent) {
        return this.inTwips(mouseEvent.getX());
    }

    @Override
    protected int getMinMarkerPos() {
        return 0;
    }

    @Override
    protected int getMaxMarkerPos() {
        return this.inTwips(this.getSize().width);
    }

    static {
        POLYGON.moveTo(0.0f, 0.0f);
        POLYGON.lineTo(4.0f, -5.0f);
        POLYGON.lineTo(-4.0f, -5.0f);
        POLYGON.lineTo(0.0f, 0.0f);
    }
}

