/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.mime.IMIMEManager;
import com.elixirtech.arch.mime.MIMEEntry;
import com.elixirtech.glint.viewer.IViewerCanvas;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.ui.viewer.ViewerToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ImageTab
extends JPanel {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ImageTab.class);

    public ImageTab(File file) throws IOException {
        IViewerCanvas iViewerCanvas = this.getCanvas(file);
        this.setLayout(new BorderLayout());
        ViewerToolBar viewerToolBar = new ViewerToolBar(14);
        viewerToolBar.setMargin(new Insets(0, 0, 0, 0));
        viewerToolBar.setViewer(iViewerCanvas);
        this.add((Component)viewerToolBar, "North");
        this.add((Component)new JScrollPane(iViewerCanvas.getCanvasComponent()), "Center");
    }

    private IViewerCanvas getCanvas(File file) throws IOException {
        m_Log.debug((Object)("getCanvas(" + String.valueOf(file) + ")"));
        IMIMEManager iMIMEManager = (IMIMEManager)Elixir.get(IMIMEManager.class);
        MIMEEntry mIMEEntry = iMIMEManager.getEntryForFilename(file.getName());
        if (mIMEEntry != null) {
            String string = mIMEEntry.getProperty("java-view");
            m_Log.debug((Object)("Java view : " + string));
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    IViewerCanvas iViewerCanvas = (IViewerCanvas)clazz.newInstance();
                    iViewerCanvas.read(file);
                    return iViewerCanvas;
                }
                catch (Exception exception) {
                    ElixirJ.error(I18N.ERD.getString("ImageTab.error-create-view") + String.valueOf(exception), exception);
                    throw new IOException("Error creating viewer");
                }
            }
        }
        ElixirJ.error(I18N.ERD.getString("ImageTab.error-create-for-view") + file.getName());
        throw new IOException("No viewer found");
    }
}

