/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IProgressDisplayer;
import com.elixirtech.arch.IUINavigator;
import com.elixirtech.arch.UINavigatorPath;
import com.elixirtech.command.CommandManager;
import com.elixirtech.erd.reportdesigner.ComponentToolBar;
import com.elixirtech.erd.reportdesigner.ERDAction;
import com.elixirtech.erd.reportdesigner.HorizontalRuler;
import com.elixirtech.erd.reportdesigner.RowHeader;
import com.elixirtech.erd.reportdesigner.Ruler;
import com.elixirtech.erd.reportdesigner.SectionComboRenderer;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.chunk.ColumnBasedChunkPanel;
import com.elixirtech.erd.reportdesigner.chunk.DetailChunkPanel;
import com.elixirtech.erd.reportdesigner.chunk.GroupFooterChunkPanel;
import com.elixirtech.erd.reportdesigner.chunk.GroupHeaderChunkPanel;
import com.elixirtech.erd.reportdesigner.chunk.PageFooterChunkPanel;
import com.elixirtech.erd.reportdesigner.chunk.PageHeaderChunkPanel;
import com.elixirtech.erd.reportdesigner.chunk.SectionFooterChunkPanel;
import com.elixirtech.erd.reportdesigner.chunk.SectionHeaderChunkPanel;
import com.elixirtech.erd.reportdesigner.data.AddDataSourceWizard;
import com.elixirtech.erd.reportdesigner.data.DataTree;
import com.elixirtech.erd.reportdesigner.select.SelectionEvent;
import com.elixirtech.erd.reportdesigner.select.SelectionListener;
import com.elixirtech.erd.reportdesigner.select.SelectionManager;
import com.elixirtech.erd.reportdesigner.shape.ShapeTreeListener;
import com.elixirtech.erd.reportdesigner.style.StyleTree;
import com.elixirtech.erd.reportdesigner.tool.SelectionTool;
import com.elixirtech.erd.reportdesigner.tool.Tool;
import com.elixirtech.erd.util.DerivedComboBoxModel;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.Detail;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.model.Group;
import com.elixirtech.report2.raw.model.GroupFooter;
import com.elixirtech.report2.raw.model.GroupHeader;
import com.elixirtech.report2.raw.model.PageFooter;
import com.elixirtech.report2.raw.model.PageHeader;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.SectionFooter;
import com.elixirtech.report2.raw.model.SectionHeader;
import com.elixirtech.report2.raw.model.Shape;
import com.elixirtech.sax.ChangeNotifier;
import com.elixirtech.ui.CurrentTab;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.TopLeftLayoutManager;
import com.elixirtech.ui.property.PropertyTable;
import com.elixirtech.ui.property.PropertyTableListener;
import com.elixirtech.ui.tree.BasicTreeCellRenderer;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.renderer.RendererWizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class LayoutTab
extends JPanel
implements ItemListener,
Ruler.MarkerListener,
PropertyTableListener,
CurrentTab,
IUINavigator {
    public static final int BOTTOM_GAP = 100;
    private static List<PropertyHolder> emptylist = Collections.emptyList();
    private Section m_Section;
    private JToolBar m_ToolBar = SwingFactory.newToolBar();
    private ComponentToolBar m_ComponentToolBar;
    private List<ChunkPanel> m_Chunks = new ArrayList<ChunkPanel>();
    private JComboBox m_ZoomCombo;
    private JComboBox m_SectionCombo;
    private JButton m_Undo;
    private JButton m_Redo;
    private HorizontalRuler m_Ruler;
    private RowHeader m_RowHeader;
    private DataTree m_DataTree;
    private StyleTree m_StyleTree;
    private Tool m_CurrentTool = new SelectionTool();
    private CommandManager m_CommandManager;
    private JSplitPane m_HSplit;
    private boolean m_Initialized;
    RawReport m_Report;
    SelectionManager m_SelectionManager;
    ChunkPanel m_CurrentChunk;
    PropertyTable m_PropertyTable;
    JTree m_ShapeTree;
    JLabel m_Progress;
    private DerivedComboBoxModel<Section> m_SectionModel;
    private JScrollPane m_Layout;
    private static final String[] LAYOUT_ZOOM_LEVELS = new String[]{"100%", "200%", "300%", "400%"};
    private static final int[] LAYOUT_ZOOM_LEVEL_VALUES = new int[]{100, 200, 300, 400};
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LayoutTab.class);
    private static final String RENDERING_COMPLETE = "Rendering Complete";
    private static final String RENDERING_COMPLETE_UI = I18N.ERD.getString("LayoutTab.RenderingComplete");

    public LayoutTab(RawReport rawReport) {
        this.m_Report = rawReport;
        this.m_SectionModel = new DerivedComboBoxModel((ChangeNotifier)this.m_Report, this.m_Report.getSectionList(), "RawReport.Section");
        this.m_CommandManager = new CommandManager();
        this.m_SelectionManager = new SelectionManager(this.m_Report, this.m_CommandManager);
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.m_ToolBar.setLayout(new FlowLayout(0, 8, 0));
        this.m_ToolBar.setBorder(BorderFactory.createEmptyBorder());
        this.m_ToolBar.add(SwingFactory.newLabel("zoom-label"));
        this.m_ZoomCombo = SwingFactory.newComboBox("Zoom", LAYOUT_ZOOM_LEVELS);
        this.m_ZoomCombo.addItemListener(this);
        this.m_ToolBar.add(this.m_ZoomCombo);
        this.m_ToolBar.add(SwingFactory.newLabel("section-label"));
        this.m_SectionCombo = SwingFactory.newComboBox("Section", this.m_SectionModel);
        Dimension dimension = this.m_SectionCombo.getPreferredSize();
        dimension.width = 200;
        this.m_SectionCombo.setPreferredSize(dimension);
        this.m_SectionCombo.setRenderer(new SectionComboRenderer());
        if (this.m_SectionCombo.getItemCount() > 0) {
            this.m_SectionCombo.setSelectedIndex(0);
            this.m_Section = (Section)this.m_SectionCombo.getItemAt(0);
        } else {
            m_Log.error((Object)"This report has no sections");
        }
        this.m_SectionCombo.addItemListener(this);
        this.m_ToolBar.add(this.m_SectionCombo);
        this.m_Redo = this.m_ToolBar.add(new RedoAction());
        this.m_Redo.setMargin(new Insets(0, 0, 0, 0));
        this.m_Undo = this.m_ToolBar.add(new UndoAction());
        this.m_Undo.setMargin(new Insets(0, 0, 0, 0));
        this.m_Redo.setEnabled(this.m_CommandManager.canRedo());
        this.m_Undo.setEnabled(this.m_CommandManager.canUndo());
        this.m_CommandManager.addChangeListener(new UndoRedoChange());
        JButton jButton = this.m_ToolBar.add(new RenderAction());
        jButton.setMargin(new Insets(0, 0, 0, 0));
        JButton jButton2 = this.m_ToolBar.add(new FastRenderAction());
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        this.m_Progress = new JLabel();
        this.m_Progress.setFont(UIManager.getFont("TextField.Font"));
        this.m_ToolBar.add(this.m_Progress);
        this.buildChunks();
        this.add((Component)this.m_ToolBar, "North");
        this.m_Layout = SwingFactory.newScrollPane("chunk", this.getChunkPanelComponent());
        this.m_Ruler = new HorizontalRuler(this.m_Section);
        this.m_Ruler.addMarkerListener(this);
        this.m_Ruler.setWidth(this.getMaxChunkWidth());
        this.m_Layout.setColumnHeaderView(this.m_Ruler);
        this.m_RowHeader = new RowHeader(this);
        this.m_Layout.setRowHeaderView(this.m_RowHeader);
        this.m_SelectionManager.setHRuler(this.m_Ruler);
        this.m_ShapeTree = new JTree((TreeModel)null);
        this.m_ShapeTree.addMouseListener(new ShapeTreeListener());
        this.m_ShapeTree.setCellRenderer(new ShapeTreeRenderer());
        this.m_DataTree = new DataTree(this.m_Report);
        this.m_StyleTree = new StyleTree(this.m_Report);
        this.m_PropertyTable = new PropertyTable();
        this.m_PropertyTable.addPropertyTableListener(this);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(I18N.ERD.getString("LayoutTab.data"), this.m_DataTree.getComponent());
        jTabbedPane.addTab(I18N.ERD.getString("LayoutTab.shapes"), SwingFactory.newScrollPane("shape-tree", this.m_ShapeTree));
        jTabbedPane.addTab(I18N.ERD.getString("LayoutTab.styles"), this.m_StyleTree.getComponent());
        JSplitPane jSplitPane = SwingFactory.newVerticalSplit(jTabbedPane, this.m_PropertyTable);
        jSplitPane.setDividerLocation(300);
        this.m_HSplit = SwingFactory.newHorizontalSplit(this.m_Layout, jSplitPane);
        this.m_HSplit.setOneTouchExpandable(true);
        this.m_HSplit.setResizeWeight(1.0);
        this.add((Component)this.m_HSplit, "Center");
        this.m_ComponentToolBar = new ComponentToolBar(this);
        this.add((Component)this.m_ComponentToolBar.getToolBar(), "West");
        SelectionAdapter selectionAdapter = new SelectionAdapter();
        this.m_SelectionManager.addSelectionListener(selectionAdapter);
        this.m_ShapeTree.addTreeSelectionListener(selectionAdapter);
        I18N.ERD_MAP.injectComponents("LayoutTab.", this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                LayoutTab.this.initSplitter();
                LayoutTab.this.removeComponentListener(this);
            }
        });
    }

    @Override
    public void showUINavigator(UINavigatorPath uINavigatorPath) {
    }

    public RawReport getReport() {
        return this.m_Report;
    }

    @Override
    public void propertyChanged(Name name, List<? extends PropertyHolder> list) {
        if (this.m_CurrentChunk != null) {
            this.m_CurrentChunk.repaintBody();
            String string = name.getName();
            if (string.equals("RawElement.Name")) {
                this.m_CurrentChunk.getChunkManager().fireChangedEvent(list);
            } else if (string.equals("Common.Height") && this.containsChunk(list)) {
                this.buildChunks();
                this.m_Layout.setViewportView(this.getChunkPanelComponent());
                this.m_RowHeader.rebuild();
                this.validate();
            }
        }
        if (!this.isReadOnly()) {
            this.m_Report.setDirty(true);
        }
    }

    public void initSplitter() {
        if (!this.m_Initialized) {
            int n = this.getWidth();
            this.m_HSplit.setDividerLocation(Math.max(100, n - 360));
            this.m_Initialized = true;
        }
    }

    public boolean isReadOnly() {
        return this.m_Report.getSecurity().isReadOnly();
    }

    @Override
    public void setCurrent(boolean bl) {
        if (bl) {
            JViewport jViewport;
            this.buildChunks();
            if (!this.m_Chunks.contains(this.m_CurrentChunk)) {
                this.setCurrentChunk(null);
            }
            if ((jViewport = this.m_Layout.getViewport()) != null) {
                Point point = jViewport.getViewPosition();
                this.m_Layout.setViewportView(this.getChunkPanelComponent());
                jViewport.setViewPosition(point);
            } else {
                this.m_Layout.setViewportView(this.getChunkPanelComponent());
            }
            this.m_RowHeader.rebuild();
            this.m_Ruler.setWidth(this.getMaxChunkWidth());
            this.m_PropertyTable.setPropertyHolders(this.m_PropertyTable.getPropertyHolders());
            boolean bl2 = this.isReadOnly();
            this.m_Ruler.setReadOnly(bl2);
            this.m_SelectionManager.setReadOnly(bl2);
            this.m_ComponentToolBar.setReadOnly(bl2);
            this.m_PropertyTable.setReadOnly(bl2);
            this.validate();
        } else {
            this.m_PropertyTable.disposeEditor();
        }
    }

    public CommandManager getCommandManager() {
        return this.m_CommandManager;
    }

    public SelectionManager getSelectionManager() {
        return this.m_SelectionManager;
    }

    public void setCurrentChunk(ChunkPanel chunkPanel) {
        if (this.m_CurrentChunk != chunkPanel) {
            if (this.m_CurrentChunk != null) {
                this.m_CurrentChunk.setCurrent(false);
            }
            this.m_CurrentChunk = chunkPanel;
            if (this.m_CurrentChunk != null) {
                this.m_CurrentChunk.setCurrent(true);
            } else {
                this.setTreeModel(null);
                this.m_PropertyTable.setPropertyHolders(emptylist);
            }
        }
    }

    public void setTreeModel(TreeModel treeModel) {
        this.m_ShapeTree.setModel(treeModel);
    }

    public void setCurrentTool(Tool tool) {
        this.m_CurrentTool = tool;
    }

    public Tool getCurrentTool() {
        return this.m_CurrentTool;
    }

    public List<ChunkPanel> getChunkPanels() {
        return Collections.unmodifiableList(this.m_Chunks);
    }

    public ChunkPanel getChunkPanel(String string) {
        for (ChunkPanel chunkPanel : this.m_Chunks) {
            if (!string.equals(chunkPanel.getChunkTitle())) continue;
            return chunkPanel;
        }
        return null;
    }

    @Override
    public void markersChanged() {
        for (ChunkPanel chunkPanel : this.m_Chunks) {
            chunkPanel.repaint();
        }
    }

    public RowHeader getRowHeader() {
        return this.m_RowHeader;
    }

    public void startDrag(ChunkPanel.Dragger dragger, MouseEvent mouseEvent) {
        ChunkPanel.DragBarState dragBarState = dragger.getDragBarState();
        if (dragBarState != null) {
            Point point = dragBarState.getOffset();
            Dimension dimension = dragger.getSize();
            Rectangle rectangle = dragBarState.getRectangle();
            rectangle.x = point.x;
            rectangle.y = point.y + mouseEvent.getY();
            rectangle.width = dimension.width;
            rectangle.height = dimension.height;
        }
    }

    public void endDrag(ChunkPanel.Dragger dragger, MouseEvent mouseEvent) {
        ChunkPanel.DragBarState dragBarState = dragger.getDragBarState();
        if (dragBarState != null) {
            Rectangle rectangle = dragBarState.getRectangle();
            this.paintImmediately(rectangle);
            int n = mouseEvent.getY();
            dragger.setLocation(n);
            this.validate();
        }
    }

    public void drag(ChunkPanel.Dragger dragger, MouseEvent mouseEvent) {
        ChunkPanel.DragBarState dragBarState = dragger.getDragBarState();
        if (dragBarState != null) {
            Rectangle rectangle = dragBarState.getRectangle();
            int n = dragBarState.getOffset().y + mouseEvent.getY();
            Graphics graphics = this.getGraphics();
            this.paintImmediately(rectangle);
            graphics.setColor(Color.blue);
            rectangle.y = Math.max(this.m_ToolBar.getHeight() + this.m_Layout.getY() + 15, n);
            rectangle.width = Math.min(rectangle.width, this.m_Layout.getWidth() - 15);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.dispose();
        }
    }

    protected void buildChunks() {
        HashMap<Chunk, ChunkPanel> hashMap = new HashMap<Chunk, ChunkPanel>();
        for (ChunkPanel chunkPanel : this.m_Chunks) {
            hashMap.put(chunkPanel.getChunk(), chunkPanel);
        }
        this.m_Chunks.clear();
        if (this.m_Section != null) {
            Object object;
            Serializable serializable;
            ChunkPanel chunkPanel;
            Object object2 = this.m_Section.getSectionHeader();
            chunkPanel = this.m_Section.getPageHeader();
            Detail detail = this.m_Section.getDetail();
            PageFooter pageFooter = this.m_Section.getPageFooter();
            SectionFooter sectionFooter = this.m_Section.getSectionFooter();
            if (this.m_Section.isShowPageHeader()) {
                if (chunkPanel == null) {
                    chunkPanel = new PageHeader();
                    this.m_Section.setPageHeader((PageHeader)chunkPanel);
                }
                if ((serializable = (PageHeaderChunkPanel)hashMap.get(chunkPanel)) == null) {
                    serializable = new PageHeaderChunkPanel(this, (Chunk)chunkPanel);
                }
                this.m_Chunks.add((ChunkPanel)serializable);
            }
            if (this.m_Section.isShowSectionHeader()) {
                if (object2 == null) {
                    object2 = new SectionHeader();
                    this.m_Section.setSectionHeader((SectionHeader)object2);
                }
                if ((serializable = (SectionHeaderChunkPanel)hashMap.get(object2)) == null) {
                    serializable = new SectionHeaderChunkPanel(this, (Chunk)object2);
                }
                this.m_Chunks.add((ChunkPanel)serializable);
            }
            serializable = new ArrayList();
            this.m_Section.getGroupList();
            Object object3 = this.m_Section.getGroupList().iterator();
            while (object3.hasNext()) {
                ColumnBasedChunkPanel columnBasedChunkPanel;
                GroupHeader groupHeader;
                object = (Group)object3.next();
                if (object.isGroupHeaderVisible()) {
                    groupHeader = object.getGroupHeader();
                    if (groupHeader == null) {
                        groupHeader = new GroupHeader();
                        object.setGroupHeader(groupHeader);
                    }
                    if ((columnBasedChunkPanel = (GroupHeaderChunkPanel)hashMap.get(groupHeader)) == null) {
                        columnBasedChunkPanel = new GroupHeaderChunkPanel(this, (Chunk)groupHeader);
                    }
                    this.m_Chunks.add(columnBasedChunkPanel);
                }
                if (!object.isGroupFooterVisible()) continue;
                groupHeader = object.getGroupFooter();
                if (groupHeader == null) {
                    groupHeader = new GroupFooter();
                    object.setGroupFooter((GroupFooter)groupHeader);
                }
                if ((columnBasedChunkPanel = (GroupFooterChunkPanel)hashMap.get(groupHeader)) == null) {
                    columnBasedChunkPanel = new GroupFooterChunkPanel(this, (Chunk)groupHeader);
                }
                serializable.add(0, columnBasedChunkPanel);
            }
            if (detail == null) {
                detail = new Detail();
                this.m_Section.setDetail(detail);
            }
            if ((object3 = (DetailChunkPanel)hashMap.get(detail)) == null) {
                object3 = new DetailChunkPanel(this, (Chunk)detail);
            }
            this.m_Chunks.add((ChunkPanel)object3);
            this.m_Chunks.addAll((Collection<ChunkPanel>)((Object)serializable));
            if (this.m_Section.isShowSectionFooter()) {
                if (sectionFooter == null) {
                    sectionFooter = new SectionFooter();
                    this.m_Section.setSectionFooter(sectionFooter);
                }
                if ((object = (SectionFooterChunkPanel)hashMap.get(sectionFooter)) == null) {
                    object = new SectionFooterChunkPanel(this, (Chunk)sectionFooter);
                }
                this.m_Chunks.add((ChunkPanel)object);
            }
            if (this.m_Section.isShowPageFooter()) {
                if (pageFooter == null) {
                    pageFooter = new PageFooter();
                    this.m_Section.setPageFooter(pageFooter);
                }
                if ((object = (PageFooterChunkPanel)hashMap.get(pageFooter)) == null) {
                    object = new PageFooterChunkPanel(this, (Chunk)pageFooter);
                }
                this.m_Chunks.add((ChunkPanel)object);
            }
        }
        for (ChunkPanel chunkPanel : this.m_Chunks) {
            chunkPanel.refresh();
        }
    }

    protected JPanel getChunkPanelComponent() {
        JPanel jPanel = new JPanel(new TopLeftLayoutManager());
        jPanel.setBackground(Color.GRAY);
        Box box = new Box(1);
        for (ChunkPanel chunkPanel : this.m_Chunks) {
            box.add(chunkPanel);
        }
        box.add(Box.createVerticalStrut(100));
        jPanel.add(box);
        return jPanel;
    }

    protected int getMaxChunkWidth() {
        int n = 0;
        for (ChunkPanel chunkPanel : this.m_Chunks) {
            n = Math.max(n, chunkPanel.getSize().width);
        }
        return n;
    }

    protected boolean containsChunk(List<? extends PropertyHolder> list) {
        Iterator<? extends PropertyHolder> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof Chunk)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Section section;
        if (itemEvent.getSource() == this.m_ZoomCombo) {
            this.updateZoom();
            this.validate();
        } else if (itemEvent.getSource() == this.m_SectionCombo && (section = (Section)this.m_SectionCombo.getSelectedItem()) != this.m_Section) {
            this.m_Section = section;
            this.m_Ruler.setSection(this.m_Section);
            this.buildChunks();
            this.setCurrentChunk(null);
            this.m_Layout.setViewportView(this.getChunkPanelComponent());
            this.m_RowHeader.rebuild();
            this.updateZoom();
            this.validate();
        }
    }

    public void updateZoom() {
        int n = LAYOUT_ZOOM_LEVEL_VALUES[this.m_ZoomCombo.getSelectedIndex()];
        for (ChunkPanel chunkPanel : this.m_Chunks) {
            chunkPanel.setZoomPercent(n);
        }
        this.m_Ruler.setZoomPercent(n);
        this.m_Ruler.setWidth(this.getMaxChunkWidth());
    }

    public HorizontalRuler getRuler() {
        return this.m_Ruler;
    }

    public JScrollPane getLayoutScrollPane() {
        return this.m_Layout;
    }

    private class RedoAction
    extends ERDAction {
        public RedoAction() {
            super("Report.Redo");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (LayoutTab.this.m_CommandManager.canRedo()) {
                LayoutTab.this.m_CommandManager.redo();
            }
            LayoutTab.this.m_Redo.setEnabled(LayoutTab.this.m_CommandManager.canRedo());
        }
    }

    private class UndoAction
    extends ERDAction {
        public UndoAction() {
            super("Report.Undo");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (LayoutTab.this.m_CommandManager.canUndo()) {
                LayoutTab.this.m_CommandManager.undo();
            }
            LayoutTab.this.m_Undo.setEnabled(LayoutTab.this.m_CommandManager.canUndo());
        }
    }

    private class UndoRedoChange
    implements ChangeListener {
        private UndoRedoChange() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            LayoutTab.this.m_Redo.setEnabled(LayoutTab.this.m_CommandManager.canRedo());
            LayoutTab.this.m_Undo.setEnabled(LayoutTab.this.m_CommandManager.canUndo());
        }
    }

    private class RenderAction
    extends ERDAction
    implements IProgressDisplayer {
        public RenderAction() {
            super("Report.Render");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RendererWizard rendererWizard = new RendererWizard(LayoutTab.this.m_Report, true);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.setProgressDisplayer(this);
            elixirFrame.showWizard(rendererWizard);
        }

        @Override
        public void setProgress(String string) {
            if (LayoutTab.RENDERING_COMPLETE.equals(string)) {
                string = RENDERING_COMPLETE_UI;
            }
            LayoutTab.this.m_Progress.setText(string);
        }
    }

    private class FastRenderAction
    extends ERDAction
    implements IProgressDisplayer {
        public FastRenderAction() {
            super("Report.FastRender");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RendererWizard rendererWizard = new RendererWizard(LayoutTab.this.m_Report, true);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.setProgressDisplayer(this);
            if (rendererWizard.canFinish() && !rendererWizard.isReadOnly()) {
                rendererWizard.performFinish();
            } else {
                elixirFrame.showWizard(rendererWizard);
            }
        }

        @Override
        public void setProgress(String string) {
            if (LayoutTab.RENDERING_COMPLETE.equals(string)) {
                string = RENDERING_COMPLETE_UI;
            }
            LayoutTab.this.m_Progress.setText(string);
        }
    }

    public static class ShapeTreeRenderer
    extends BasicTreeCellRenderer {
        @Override
        protected String getName(Object object) {
            Shape shape = ((RawModelElement)object).getShape();
            if (shape != null) {
                ControlSource controlSource;
                String string = shape.getName();
                if (StringUtil.notEmpty(string)) {
                    return string;
                }
                RawModelElement rawModelElement = shape.getModel();
                if (rawModelElement instanceof Field && (controlSource = ((Field)rawModelElement).getControlSource()) != null) {
                    return controlSource.getDisplayNameValue();
                }
                return "";
            }
            return "null";
        }

        @Override
        protected Icon getIcon(Object object) {
            Shape shape = ((RawModelElement)object).getShape();
            if (shape != null) {
                return shape.getIcon();
            }
            return null;
        }
    }

    private class SelectionAdapter
    implements SelectionListener,
    TreeSelectionListener {
        private boolean m_Selecting;

        private SelectionAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void selectionChanged(SelectionEvent selectionEvent) {
            block6: {
                try {
                    if (this.m_Selecting) break block6;
                    this.m_Selecting = true;
                    try {
                        TreePath[] treePathArray = new TreePath[LayoutTab.this.m_SelectionManager.getSelectionCount()];
                        for (int i = 0; i < treePathArray.length; ++i) {
                            RawModelElement rawModelElement = LayoutTab.this.m_SelectionManager.getSelection(i);
                            treePathArray[i] = LayoutTab.this.m_CurrentChunk.getChunkManager().getTreePath(rawModelElement);
                            LayoutTab.this.m_ShapeTree.expandPath(treePathArray[i]);
                        }
                        LayoutTab.this.m_ShapeTree.setSelectionPaths(treePathArray);
                        this.updatePropertySheet(LayoutTab.this.m_SelectionManager.getSelection());
                    }
                    finally {
                        this.m_Selecting = false;
                    }
                }
                catch (Throwable throwable) {
                    m_Log.error((Object)("Error with notification from selection manager: " + String.valueOf(throwable)), throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            block7: {
                try {
                    if (this.m_Selecting) break block7;
                    this.m_Selecting = true;
                    try {
                        TreePath[] treePathArray = ((JTree)treeSelectionEvent.getSource()).getSelectionPaths();
                        if (treePathArray != null) {
                            ArrayList<RawModelElement> arrayList = new ArrayList<RawModelElement>();
                            for (int i = 0; i < treePathArray.length; ++i) {
                                arrayList.add((RawModelElement)treePathArray[i].getLastPathComponent());
                            }
                            LayoutTab.this.m_SelectionManager.setSelection(arrayList);
                            LayoutTab.this.m_CurrentChunk.repaintBody();
                            this.updatePropertySheet(arrayList);
                        }
                    }
                    finally {
                        this.m_Selecting = false;
                    }
                }
                catch (Throwable throwable) {
                    m_Log.error((Object)("Error with notification from selection tree: " + String.valueOf(throwable)), throwable);
                }
            }
        }

        private void updatePropertySheet(List<? extends PropertyHolder> list) {
            LayoutTab.this.m_PropertyTable.setPropertyHolders(list);
        }
    }

    private class FilterAction
    extends ERDAction {
        public FilterAction() {
            super("Report.Filter");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = LayoutTab.this.m_Section.getDataSource();
            DataSource dataSource = LayoutTab.this.m_Report.getDataSource(string);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            if (dataSource != null) {
                AddDataSourceWizard addDataSourceWizard = new AddDataSourceWizard(LayoutTab.this.m_Report, dataSource);
                addDataSourceWizard.setShowFilterPage(true);
                elixirFrame.showWizard(addDataSourceWizard);
            } else {
                JOptionPane.showMessageDialog(elixirFrame.getFrame(), I18N.ERD.getObject("Filter.NoDataSource"));
            }
        }
    }
}

