/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IDirtyState;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.js.help.BasicNode;
import com.elixirtech.arch.js.help.Bean;
import com.elixirtech.arch.js.help.Category;
import com.elixirtech.arch.js.help.Global;
import com.elixirtech.arch.js.help.ICategorySupplier;
import com.elixirtech.arch.js.help.INode;
import com.elixirtech.arch.js.help.JSHelpUtil;
import com.elixirtech.arch.repository.RepositoryConverter;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.erd.images.Icons;
import com.elixirtech.erd.reportdesigner.FunctionsPanel;
import com.elixirtech.erd.reportdesigner.LayoutTab;
import com.elixirtech.erd.reportdesigner.report.ReportPanel;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.ReportLoader;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.ui.ElxTabbedPane;
import com.elixirtech.util.ClassUtil;
import com.elixirtech.util.StringUtil;
import com.elixirtech.v2.repository.FileObject;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ReportTab
extends ElxTabbedPane
implements IPanelView,
IDirtyState.Listener,
ICategorySupplier {
    private final RawReport m_Report;
    private final ReportPanel m_ReportPanel;
    private final LayoutTab m_Layout;
    private final FunctionsPanel m_Functions;

    public ReportTab(RawReport rawReport) {
        this.m_Report = rawReport;
        this.m_Report.addDirtyListener((IDirtyState.Listener)this);
        this.m_ReportPanel = new ReportPanel(this.m_Report);
        this.m_Layout = new LayoutTab(this.m_Report);
        this.m_Functions = new FunctionsPanel(this.m_Report);
        this.setBorder(null);
        this.addTab(I18N.ERD.getString("ReportTab.Report"), this.m_ReportPanel, ERDIcons.REPORT_TAB);
        this.addTab(I18N.ERD.getString("ReportTab.Layout"), this.m_Layout, Icons.TEMPLATE);
        this.addTab(I18N.ERD.getString("ReportTab.Functions"), this.m_Functions, ERDIcons.FUNCTION_TAB);
        this.setSelectedComponent(this.m_Layout);
        this.addChangeListener(this);
    }

    public RawReport getReport() {
        return this.m_Report;
    }

    public ReportPanel getReportPanel() {
        return this.m_ReportPanel;
    }

    public LayoutTab getLayoutTab() {
        return this.m_Layout;
    }

    @Override
    public List<INode> getCategories() {
        Category category;
        ArrayList<Category> arrayList = new ArrayList<Category>();
        if (ClassUtil.getClassSilent("com.elixirtech.report2.raw.model.BeanMap") != null) {
            category = new Category("Report-Raw");
            JSHelpUtil.buildPackage(category, "com.elixirtech.report2.raw.model");
            arrayList.add(category);
        }
        if (ClassUtil.getClassSilent("com.elixirtech.report2.logical.model.BeanMap") != null) {
            category = new Category("Report-Logical");
            JSHelpUtil.buildPackage(category, "com.elixirtech.report2.logical.model");
            arrayList.add(category);
        }
        category = new Category("Data");
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        Iterator iterator = this.m_Report.getDataSourceIterator();
        while (iterator.hasNext()) {
            DataSource dataSource = (DataSource)iterator.next();
            Category category2 = new Category(dataSource.getName());
            String string = dataSource.getDataSourceName();
            try {
                IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
                DataSchema dataSchema = iDataSource.getSchema();
                if (dataSchema != null) {
                    int n = dataSchema.getColumnCount();
                    for (int i = 0; i < n; ++i) {
                        Object object = dataSchema.getColumnName(i);
                        if (!StringUtil.notEmpty((String)object)) continue;
                        String string2 = dataSchema.getColumnType(i).getTypeName();
                        category2.add(new BasicNode((String)object + " : " + string2, (String)object));
                        char c = ((String)object).charAt(0);
                        if (Character.isJavaIdentifierStart(c)) continue;
                        object = "_" + (String)object;
                        category2.add(new BasicNode((String)object + " (variable name)", (String)object));
                    }
                }
                category.add(category2);
            }
            catch (Throwable throwable) {}
        }
        arrayList.add(category);
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<INode> getGlobals() {
        ArrayList<INode> arrayList = new ArrayList<INode>();
        arrayList.add(new Global("result"));
        arrayList.add(new Bean("com.elixirtech.report2.logical.Data"));
        arrayList.add(new Bean("com.elixirtech.report2.data.DataCacheManager"));
        arrayList.add(new Bean("com.elixirtech.data2.DataSourceManager"));
        arrayList.add(new Bean("com.elixirtech.report2.js.Format"));
        arrayList.add(new Bean("com.elixirtech.report2.data.function.Function"));
        arrayList.add(new Bean("com.elixirtech.report2.data.IDataCache"));
        arrayList.add(new Bean("Paginator", "com.elixirtech.report2.logical.IPaginator"));
        arrayList.add(new Bean("Parameters", "com.elixirtech.report2.js.IProperties"));
        arrayList.add(new Bean("Renderer", "com.elixirtech.report2.logical.IRenderer"));
        return arrayList;
    }

    public void showDesigner() {
        this.setSelectedComponent(this.m_Layout);
    }

    public void showFunction(PropertyHolder propertyHolder, Property property) {
        this.setSelectedComponent(this.m_Functions);
        this.m_Functions.showFunction(propertyHolder, property);
    }

    @Override
    public String getName() {
        if (this.m_Report != null) {
            return this.m_Report.getFileObject().getPath().toString();
        }
        return "ReportTab";
    }

    public Object getId() {
        return this.m_Report.getFileObject();
    }

    @Override
    public Icon getIcon() {
        return Icons.TEMPLATE;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void dirtyStateChanged(IDirtyState iDirtyState) {
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        iViewModel.refreshView();
    }

    @Override
    public boolean canSave() {
        RMLFileObject rMLFileObject = this.m_Report.getFileObject();
        return rMLFileObject != null && this.m_Report.isDirty();
    }

    @Override
    public boolean canSaveAs() {
        return true;
    }

    @Override
    public void save() throws IOException {
        if (this.m_Report.isDirty()) {
            this.setCurrent(false);
            this.setCurrent(true);
            FileObject fileObject = RepositoryConverter.toFO(this.m_Report.getFileObject());
            ReportLoader.writeRML(this.m_Report, fileObject);
        }
    }

    @Override
    public void saveAs(FileObject fileObject) throws IOException {
        this.setCurrent(false);
        this.setCurrent(true);
        ReportLoader.close(this.m_Report);
        ReportLoader.writeRML(this.m_Report, fileObject);
    }

    @Override
    public FileObject getFileObject() {
        return RepositoryConverter.toFO(this.m_Report.getFileObject());
    }

    @Override
    public void dispose() {
        ReportLoader.close(this.m_Report);
    }

    private void addTab(String string, Component component, Icon icon) {
        this.addTab(string, icon, component);
        this.setTabComponentAt(this.getTabCount() - 1, new ElxTabbedPane.TabLabel(string, icon));
    }
}

