/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner;

import com.elixirtech.erd.reportdesigner.ERDAction;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.RulerMark;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.UnitField;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class Ruler
extends JComponent {
    public static final int THICKNESS = 15;
    public static final int MAJOR_SCALE_THICKNESS = 9;
    public static final int MINOR_SCALE_THICKNESS = 6;
    public static final Color BACKGROUND = UIManager.getColor("Panel.background");
    public static final Color HIGHLIGHT = StandardColor.SEASHELL;
    protected static final Font FONT = new Font("Monospaced", 1, 8);
    protected Dimension m_Dimension = new Dimension(15, 15);
    protected int m_ZoomPercent = 100;
    protected List<RulerMark> m_Markers;
    protected RulerMark m_CurrentMarker;
    protected MarkerListener m_Listener;
    protected Range m_CurrentRange;
    protected int m_MajorScaleCnt = 4;
    protected int m_MinorScaleCnt = 2;
    public static final int INCH_UNITS = 1440;
    public static final int MM_UNITS = 566;
    public static final int PIXEL_UNITS = 2000;
    public static final int TWIPS_UNITS = 1000;
    protected static final Stroke MARKER_LINES = new BasicStroke(1.0f);

    protected Ruler() {
        this.setOpaque(true);
        this.setBackground(BACKGROUND);
        this.setReadOnly(false);
    }

    public void setReadOnly(boolean bl) {
        if (bl) {
            this.disableEvents(48L);
        } else {
            this.enableEvents(48L);
        }
    }

    public void addMarkerListener(MarkerListener markerListener) {
        if (this.m_Listener != null) {
            throw new IllegalStateException("Only one marker listener allowed");
        }
        this.m_Listener = markerListener;
    }

    public void removeMarkerListener(MarkerListener markerListener) {
        if (this.m_Listener != markerListener) {
            throw new IllegalStateException("Incorrect marker listener");
        }
        this.m_Listener = null;
    }

    public void setZoomPercent(int n) {
        this.m_ZoomPercent = n;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_Dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public int[] getPositions() {
        int[] nArray = new int[this.m_Markers.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.m_Markers.get(i).getValue();
        }
        return nArray;
    }

    public void setPositions(int[] nArray) {
        this.m_Markers.clear();
        for (int i = 0; i < nArray.length; ++i) {
            this.m_Markers.add(new RulerMark(nArray[i]));
        }
    }

    public void setCurrentRange(Range range) {
        this.m_CurrentRange = range;
        this.repaint();
    }

    protected abstract int getPos(MouseEvent var1);

    protected abstract int getMinMarkerPos();

    protected abstract int getMaxMarkerPos();

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.m_CurrentMarker = this.getMarker(this.getPos(mouseEvent));
                if (mouseEvent.isPopupTrigger() && this.m_CurrentMarker != null) {
                    this.doPopup(mouseEvent);
                    return;
                }
                if (this.m_CurrentMarker != null || !SwingUtilities.isLeftMouseButton(mouseEvent)) break;
                this.m_CurrentMarker = new RulerMark(this.getPos(mouseEvent));
                this.m_Markers.add(this.m_CurrentMarker);
                this.repaint();
                break;
            }
            case 502: {
                if (this.m_CurrentMarker == null) break;
                if (mouseEvent.isPopupTrigger()) {
                    this.doPopup(mouseEvent);
                    return;
                }
                int n = this.m_CurrentMarker.getValue();
                if (n < this.getMinMarkerPos() || n > this.getMaxMarkerPos()) {
                    this.m_Markers.remove(this.m_CurrentMarker);
                } else {
                    for (RulerMark rulerMark : this.m_Markers) {
                        if (rulerMark == this.m_CurrentMarker || rulerMark.getValue() != this.m_CurrentMarker.getValue()) continue;
                        this.m_Markers.remove(this.m_CurrentMarker);
                        break;
                    }
                }
                this.m_CurrentMarker = null;
                this.fireMarkersChanged();
            }
        }
    }

    private void doPopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(I18N.ERD.getString("Ruler.remove"));
        jMenuItem.addActionListener(new RemoveMarker(this.m_CurrentMarker));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 506: {
                if (this.m_CurrentMarker == null || !SwingUtilities.isLeftMouseButton(mouseEvent)) break;
                this.m_CurrentMarker.setValue(this.getPos(mouseEvent));
                this.repaint();
            }
        }
    }

    protected RulerMark getMarker(int n) {
        for (RulerMark rulerMark : this.m_Markers) {
            if (Math.abs(rulerMark.getValue() - n) >= 60) continue;
            return rulerMark;
        }
        return null;
    }

    protected void fireMarkersChanged() {
        if (this.m_Listener != null) {
            this.m_Listener.markersChanged();
        }
    }

    protected final int inPixels(int n) {
        return n * this.m_ZoomPercent / 2000;
    }

    protected final int inTwips(int n) {
        return n * 20 * 100 / this.m_ZoomPercent;
    }

    protected final int getUnitLength() {
        int n = UnitField.getPreferredUnits();
        if (n == 0) {
            return 2000;
        }
        if (n == 2) {
            return 1440;
        }
        if (n == 3) {
            return 566;
        }
        if (n == 1) {
            return 1000;
        }
        return 1440;
    }

    public static interface MarkerListener {
        public void markersChanged();
    }

    public static class Range {
        public int start;
        public int stop;

        public Range(int n, int n2) {
            this.start = n;
            this.stop = n2;
        }
    }

    private class RemoveMarker
    extends ERDAction {
        private RulerMark m_Mark;

        public RemoveMarker(RulerMark rulerMark) {
            super("Ruler.RemoveMarker");
            this.m_Mark = rulerMark;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Ruler.this.m_Markers.remove(this.m_Mark);
            if (Ruler.this.m_CurrentMarker == this.m_Mark) {
                Ruler.this.m_CurrentMarker = null;
            }
            Ruler.this.fireMarkersChanged();
            Ruler.this.repaint();
        }
    }
}

