/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.erd.reportdesigner.FunctionsPanel;
import com.elixirtech.erd.reportdesigner.section.SectionWizard;
import com.elixirtech.erd.reportdesigner.tool.UiElementBeanFactory;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.Detail;
import com.elixirtech.report2.raw.model.GroupFooter;
import com.elixirtech.report2.raw.model.GroupHeader;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.PageFooter;
import com.elixirtech.report2.raw.model.PageHeader;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.property.PropertyTypes;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.report.ReportPropertiesWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;

public class ScriptSummary
extends JPanel
implements FunctionsPanel.IEditorTab {
    FunctionsPanel m_Panel;
    RawReport m_Report;
    private JEditorPane m_Editor;
    private JScrollPane m_Scroller;
    List<Link> m_Hyperlinks = new ArrayList<Link>();
    private static String EDIT = I18N.ERD.getString("ScriptSummary.Edit");
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ScriptSummary.class);

    public ScriptSummary(FunctionsPanel functionsPanel, RawReport rawReport) {
        this.m_Panel = functionsPanel;
        this.m_Report = rawReport;
        this.setLayout(new BorderLayout());
        this.m_Editor = new JEditorPane();
        this.m_Scroller = SwingFactory.newScrollPane("scroller", this.m_Editor);
        this.add((Component)this.m_Scroller, "Center");
        this.m_Editor.setEditable(false);
        this.m_Editor.setEditorKit(new HTMLEditorKit());
        this.m_Editor.addHyperlinkListener(new HLL());
        this.refresh();
    }

    @Override
    public void setCurrent(boolean bl) {
        if (bl) {
            this.refresh();
            this.m_Panel.checkEnabled();
        }
    }

    public void refresh() {
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.m_Editor.getEditorKit();
        Document document = hTMLEditorKit.createDefaultDocument();
        try {
            hTMLEditorKit.read(this.getHTML(), document, 0);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't build Script Summary: " + String.valueOf(exception)), (Throwable)exception);
        }
        this.m_Editor.setDocument(document);
    }

    public Reader getHTML() {
        this.m_Hyperlinks.clear();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        this.buildScriptForHolder(stringBuffer, (PropertyHolder)this.m_Report);
        Iterator iterator = this.m_Report.getSectionIterator();
        while (iterator.hasNext()) {
            Section section = (Section)iterator.next();
            this.getHTML(stringBuffer, section);
        }
        stringBuffer.append("</html>");
        return new StringReader(stringBuffer.toString());
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean canCut() {
        return false;
    }

    @Override
    public boolean canCopy() {
        return false;
    }

    @Override
    public boolean canPaste() {
        return false;
    }

    @Override
    public boolean canSaveAs() {
        return false;
    }

    @Override
    public boolean canPrint() {
        return false;
    }

    private void getHTML(StringBuffer stringBuffer, Section section) {
        int n;
        this.buildScriptForHolder(stringBuffer, (PropertyHolder)section);
        this.buildScript(stringBuffer, (RawModelElement)section.getSectionHeader());
        this.buildScript(stringBuffer, (RawModelElement)section.getPageHeader());
        int n2 = section.getGroupCount();
        for (n = 0; n < n2; ++n) {
            this.buildScript(stringBuffer, (RawModelElement)section.getGroup(n).getGroupHeader());
        }
        this.buildScript(stringBuffer, (RawModelElement)section.getDetail());
        for (n = n2 - 1; n >= 0; --n) {
            this.buildScript(stringBuffer, (RawModelElement)section.getGroup(n).getGroupFooter());
        }
        this.buildScript(stringBuffer, (RawModelElement)section.getPageFooter());
        this.buildScript(stringBuffer, (RawModelElement)section.getSectionFooter());
    }

    private void buildScript(StringBuffer stringBuffer, RawModelElement rawModelElement) {
        if (rawModelElement != null) {
            this.buildScriptForHolder(stringBuffer, (PropertyHolder)rawModelElement);
            if (rawModelElement instanceof IRawElementHolder) {
                Iterator iterator = ((IRawElementHolder)rawModelElement).getRawElementIterator();
                while (iterator.hasNext()) {
                    this.buildScript(stringBuffer, (RawModelElement)iterator.next());
                }
            }
        }
    }

    private void buildScriptForHolder(StringBuffer stringBuffer, PropertyHolder propertyHolder) {
        if (propertyHolder == null) {
            return;
        }
        HashSet hashSet = new HashSet();
        propertyHolder.getPropertyNames(hashSet);
        TreeSet treeSet = new TreeSet(hashSet);
        for (Name name : treeSet) {
            Property property = propertyHolder.getProperty(name);
            if (property.getType() == PropertyTypes.SCRIPT && !this.isHide(property)) {
                this.buildScript(stringBuffer, (Object)propertyHolder, property, (Script)property.getValue());
                continue;
            }
            if (property.getType() != PropertyTypes.CONTROL_SOURCE) continue;
            this.buildScript(stringBuffer, (Object)propertyHolder, property, (ControlSource)property.getValue());
        }
    }

    private void buildScript(StringBuffer stringBuffer, Object object, Property property, ControlSource controlSource) {
        if (controlSource == null) {
            return;
        }
        if ("Script".equals(controlSource.getType())) {
            String string = controlSource.getText();
            if (string != null && string.startsWith("=")) {
                string = string.substring(1);
            }
            if (StringUtil.isEmpty(string)) {
                return;
            }
            stringBuffer.append("<h2>" + this.getName(object) + ":" + property.getShortLabel() + "</h2>");
            stringBuffer.append("<pre>");
            stringBuffer.append(this.fixup(string));
            stringBuffer.append("</pre>");
            if (object instanceof PropertyHolder) {
                PropertyHolder propertyHolder = (PropertyHolder)object;
                String string2 = "edit" + this.m_Hyperlinks.size();
                stringBuffer.append("<a href=\"" + string2 + "\">" + EDIT + "</a>");
                this.m_Hyperlinks.add(new Link(propertyHolder, property));
            }
            stringBuffer.append("<hr>");
        }
    }

    private boolean isHide(Property property) {
        return property.getName().getName().equals("RawReport.FunctionDefinitions");
    }

    private void buildScript(StringBuffer stringBuffer, Object object, Property property, Script script) {
        if (Script.isEmpty((Script)script)) {
            return;
        }
        stringBuffer.append("<h2>" + this.getName(object) + ":" + property.getShortLabel() + "</h2>");
        stringBuffer.append("<pre>");
        stringBuffer.append(this.fixup(script.getText()));
        stringBuffer.append("</pre>");
        if (object instanceof PropertyHolder) {
            PropertyHolder propertyHolder = (PropertyHolder)object;
            String string = "edit" + this.m_Hyperlinks.size();
            stringBuffer.append("<a href=\"" + string + "\">" + EDIT + "</a>");
            this.m_Hyperlinks.add(new Link(propertyHolder, property));
        }
        stringBuffer.append("<hr>");
    }

    private String getName(Object object) {
        if (object instanceof RawReport) {
            return "Report";
        }
        if (object instanceof Section) {
            return ((Section)object).getName();
        }
        if (object instanceof PageHeader) {
            return "PageHeader";
        }
        if (object instanceof GroupHeader) {
            return "GroupHeader(" + ((GroupHeader)object).getGroup().getField() + ")";
        }
        if (object instanceof Detail) {
            return "Detail";
        }
        if (object instanceof GroupFooter) {
            return "GroupFooter(" + ((GroupFooter)object).getGroup().getField() + ")";
        }
        if (object instanceof PageFooter) {
            return "PageFooter";
        }
        if (object instanceof RawElement) {
            return this.getClassName(object) + "(" + ((RawElement)object).getName() + ")";
        }
        return this.getClassName(object);
    }

    private String getClassName(Object object) {
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private String fixup(String string) {
        string = StringUtil.findAndReplace(string, "<", "&lt;");
        return string;
    }

    private class HLL
    implements HyperlinkListener {
        private HLL() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            String string;
            HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
            if (HyperlinkEvent.EventType.ACTIVATED.equals(eventType) && (string = hyperlinkEvent.getDescription()).startsWith("edit")) {
                string = string.substring(4);
                try {
                    int n = Integer.parseInt(string);
                    Link link = ScriptSummary.this.m_Hyperlinks.get(n);
                    PropertyHolder propertyHolder = link.getPropertyHolder();
                    if (propertyHolder instanceof RawReport) {
                        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
                        elixirFrame.showWizard(new ReportPropertiesWizard(ScriptSummary.this.m_Report));
                    } else if (propertyHolder instanceof Section) {
                        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
                        SectionWizard sectionWizard = new SectionWizard(ScriptSummary.this.m_Report, (Section)propertyHolder);
                        sectionWizard.showScriptTab();
                        elixirFrame.showWizard(sectionWizard);
                    } else {
                        Property property = link.getProperty();
                        if (property.getType() == PropertyTypes.CONTROL_SOURCE) {
                            UiElementBeanFactory.showPropertyDialog((RawModelElement)propertyHolder, property.getName().getName(), ScriptSummary.this.m_Panel.isReadOnly());
                        } else {
                            ScriptSummary.this.m_Panel.showFunction(propertyHolder, property);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private static class Link {
        private PropertyHolder m_Holder;
        private Property m_Property;

        public Link(PropertyHolder propertyHolder, Property property) {
            this.m_Holder = propertyHolder;
            this.m_Property = property;
        }

        public PropertyHolder getPropertyHolder() {
            return this.m_Holder;
        }

        public Property getProperty() {
            return this.m_Property;
        }
    }
}

