/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner;

import com.elixirtech.erd.reportdesigner.Ruler;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.report2.raw.model.RulerMark;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.Iterator;

public class VerticalRuler
extends Ruler {
    private ChunkPanel m_ChunkPanel;
    private static final GeneralPath POLYGON = new GeneralPath();

    public VerticalRuler(ChunkPanel chunkPanel) {
        this.m_ChunkPanel = chunkPanel;
        this.m_Markers = this.m_ChunkPanel.getChunk().getRulerMarkList();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.m_ChunkPanel.getBodySize();
        return new Dimension(15, dimension.height + 5);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        graphics2D.setColor(BACKGROUND);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        if (this.m_CurrentRange != null) {
            graphics2D.setColor(HIGHLIGHT);
            int n2 = this.inPixels(this.m_CurrentRange.start);
            n = this.inPixels(this.m_CurrentRange.stop);
            graphics2D.fillRect(0, n2, dimension.width, n - n2);
        }
        graphics2D.setFont(FONT);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        n = this.inPixels(this.getUnitLength());
        int n3 = fontMetrics.getAscent();
        int n4 = fontMetrics.getDescent();
        int n5 = dimension.height / n;
        int n6 = n / this.m_MajorScaleCnt;
        int n7 = n6 / this.m_MinorScaleCnt;
        int n8 = 0;
        for (int i = 0; i <= n5; ++i) {
            graphics2D.setColor(Color.blue);
            graphics2D.drawLine(2, n8, 15, n8);
            graphics2D.setColor(Color.black);
            int n9 = n8;
            for (int j = 0; j < this.m_MajorScaleCnt; ++j) {
                int n10 = n9;
                for (int k = 0; k < this.m_MinorScaleCnt - 1; ++k) {
                    graphics2D.drawLine(9, n10 += n7, 15, n10);
                }
                n9 += n6;
                if (j == this.m_MajorScaleCnt - 1) continue;
                graphics2D.drawLine(6, n9, 15, n9);
            }
            graphics2D.setColor(Color.blue);
            graphics2D.drawString(Integer.toString(i), 1, n8 + n4 + n3 / 2);
            n8 += n;
        }
        this.drawMarkers(graphics2D);
        graphics2D.setColor(SystemColor.controlShadow);
        graphics2D.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(15, Integer.MAX_VALUE);
    }

    public void drawMarkers(Graphics2D graphics2D) {
        graphics2D.setColor(Color.red);
        for (RulerMark rulerMark : this.m_Markers) {
            int n = this.inPixels(rulerMark.getValue());
            graphics2D.translate(14, n);
            graphics2D.fill(POLYGON);
            graphics2D.translate(-14, -n);
        }
    }

    public void drawMarkerLines(Graphics2D graphics2D, int n) {
        Iterator iterator;
        Rectangle rectangle = graphics2D.getClipBounds();
        int n2 = 0;
        int n3 = n;
        if (rectangle != null) {
            n2 = rectangle.x;
            n3 = rectangle.x + rectangle.width;
        }
        if ((iterator = this.m_Markers.iterator()).hasNext()) {
            graphics2D.setColor(StandardColor.lookup("ERD-Ruler-Line"));
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(MARKER_LINES);
            while (iterator.hasNext()) {
                RulerMark rulerMark = (RulerMark)iterator.next();
                int n4 = rulerMark.getValue();
                graphics2D.drawLine(n2, n4, n3, n4);
            }
            graphics2D.setStroke(stroke);
        }
    }

    @Override
    protected int getPos(MouseEvent mouseEvent) {
        return this.inTwips(mouseEvent.getY());
    }

    @Override
    protected int getMinMarkerPos() {
        return 0;
    }

    @Override
    protected int getMaxMarkerPos() {
        return this.inTwips(this.getSize().height);
    }

    static {
        POLYGON.moveTo(0.0f, 0.0f);
        POLYGON.lineTo(-5.0f, 4.0f);
        POLYGON.lineTo(-5.0f, -4.0f);
        POLYGON.lineTo(0.0f, 0.0f);
    }
}

