/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.chunk;

import com.elixirtech.command.Command;
import com.elixirtech.command.CommandManager;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.chunk.UiFactory;
import com.elixirtech.erd.reportdesigner.select.SelectionManager;
import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.GroupShape;
import com.elixirtech.erd.util.ClipboardUtil;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.report2.raw.model.BasicRawElementHolder;
import com.elixirtech.report2.raw.model.Cell;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.Holder;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.ShapeGroup;
import com.elixirtech.ui.tree.TreeUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ChunkManager {
    private ChunkPanel m_ChunkPanel;
    Chunk m_Chunk;
    private Chunk.MyTreeModel m_ChunkTreeModel;
    private CommandManager m_CommandManager;
    SelectionManager m_SelectionManager;

    public ChunkManager(ChunkPanel chunkPanel) {
        this.m_ChunkPanel = chunkPanel;
        this.m_Chunk = this.m_ChunkPanel.getChunk();
        this.m_ChunkTreeModel = this.m_Chunk.getTreeModel();
        this.m_CommandManager = this.m_ChunkPanel.getCommandManager();
        this.m_SelectionManager = this.m_ChunkPanel.getSelectionManager();
    }

    public void repaintChunk() {
        this.m_ChunkPanel.repaintBody();
    }

    public TreeModel getChunkTreeModel() {
        return this.m_ChunkTreeModel;
    }

    public TreePath getTreePath(RawModelElement rawModelElement) {
        return this.m_ChunkTreeModel.getTreePath(rawModelElement);
    }

    public void fireChangedEvent(List<? extends PropertyHolder> list) {
        for (PropertyHolder propertyHolder : list) {
            if (!(propertyHolder instanceof RawModelElement)) continue;
            this.m_ChunkTreeModel.fireChangedEvent(this.m_ChunkTreeModel.getTreePath((RawModelElement)propertyHolder));
        }
    }

    public void cut() {
        this.m_CommandManager.doCommand(new Cut());
        this.m_ChunkPanel.getReport().setDirty(true);
    }

    public void copy() {
        RawModelElement rawModelElement;
        List<RawModelElement> list = this.m_SelectionManager.getSelection();
        if (list.size() > 0 && !((rawModelElement = list.get(0)) instanceof Chunk)) {
            Holder holder = new Holder();
            for (RawModelElement rawModelElement2 : list) {
                holder.addContent((Object)rawModelElement2);
            }
            ClipboardUtil.setHolder(holder);
        }
    }

    public void paste() {
        this.m_CommandManager.doCommand(new Paste());
        this.m_ChunkPanel.getReport().setDirty(true);
    }

    public void group() {
        this.m_CommandManager.doCommand(new Group());
        this.m_ChunkPanel.getReport().setDirty(true);
    }

    public void ungroup() {
        this.m_CommandManager.doCommand(new Ungroup());
        this.m_ChunkPanel.getReport().setDirty(true);
    }

    public void add(BasicRawElementHolder basicRawElementHolder, RawModelElement rawModelElement, boolean bl) {
        this.m_CommandManager.doCommand(new Add(basicRawElementHolder, rawModelElement, bl));
        this.m_ChunkPanel.getReport().setDirty(true);
    }

    public void delete() {
        this.m_CommandManager.doCommand(new Remove());
        this.m_ChunkPanel.getReport().setDirty(true);
    }

    public void bringToFront() {
        this.m_CommandManager.doCommand(new BringToFront());
        this.m_ChunkPanel.getReport().setDirty(true);
    }

    public void sendToBack() {
        this.m_CommandManager.doCommand(new SendToBack());
        this.m_ChunkPanel.getReport().setDirty(true);
    }

    public void bringForward() {
        this.m_CommandManager.doCommand(new BringForward());
        this.m_ChunkPanel.getReport().setDirty(true);
    }

    public void sendBack() {
        this.m_CommandManager.doCommand(new SendBack());
        this.m_ChunkPanel.getReport().setDirty(true);
    }

    public RawModelElement getElementAt(Point point) {
        int n = this.m_Chunk.getRawElementCount();
        for (int i = n - 1; i >= 0; --i) {
            RawModelElement rawModelElement = this.m_Chunk.getRawElement(i);
            AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
            if (abstractShape == null || !abstractShape.contains(point) || !abstractShape.isSelectable()) continue;
            return rawModelElement;
        }
        return null;
    }

    public RawModelElement getInnerElementAt(Point point) {
        int n = this.m_SelectionManager.getSelectionCount();
        for (int i = n - 1; i >= 0; --i) {
            RawModelElement rawModelElement = this.m_SelectionManager.getSelection(i);
            RawModelElement rawModelElement2 = this.getFromSelection(rawModelElement, point);
            if (rawModelElement2 == null) continue;
            return rawModelElement2;
        }
        return null;
    }

    public RawModelElement getInnermostElementAt(Point point) {
        RawModelElement rawModelElement = this.getElementAt(point);
        while (rawModelElement instanceof IRawElementHolder) {
            boolean bl = false;
            IRawElementHolder iRawElementHolder = (IRawElementHolder)rawModelElement;
            int n = iRawElementHolder.getRawElementCount();
            for (int i = n - 1; i >= 0; --i) {
                RawModelElement rawModelElement2 = iRawElementHolder.getRawElement(i);
                AbstractShape abstractShape = (AbstractShape)rawModelElement2.getShape();
                if (abstractShape == null || !abstractShape.contains(point) || !abstractShape.isSelectable()) continue;
                rawModelElement = rawModelElement2;
                bl = true;
                break;
            }
            if (bl) continue;
            break;
        }
        return rawModelElement;
    }

    protected RawModelElement getFromSelection(RawModelElement rawModelElement, Point point) {
        Object object;
        if (rawModelElement instanceof IRawElementHolder) {
            object = (IRawElementHolder)rawModelElement;
            int n = object.getRawElementCount();
            for (int i = n - 1; i >= 0; --i) {
                RawModelElement rawModelElement2 = object.getRawElement(i);
                if (this.m_SelectionManager.isSelected(rawModelElement2)) {
                    return this.getFromSelection(rawModelElement2, point);
                }
                AbstractShape abstractShape = (AbstractShape)rawModelElement2.getShape();
                if (abstractShape == null || !abstractShape.contains(point) || !abstractShape.isSelectable()) continue;
                return rawModelElement2;
            }
        }
        if ((object = (AbstractShape)rawModelElement.getShape()) != null && ((AbstractShape)object).contains(point) && ((AbstractShape)object).isSelectable()) {
            return rawModelElement;
        }
        return null;
    }

    public BasicRawElementHolder getHolderAt(Point point) {
        return (BasicRawElementHolder)this.getHolderAt((IRawElementHolder)this.m_Chunk, point);
    }

    private IRawElementHolder getHolderAt(IRawElementHolder iRawElementHolder, Point point) {
        IRawElementHolder iRawElementHolder2 = null;
        if (((AbstractShape)iRawElementHolder.getShape()).isHolder()) {
            iRawElementHolder2 = iRawElementHolder;
        }
        int n = iRawElementHolder.getRawElementCount();
        for (int i = n - 1; i >= 0; --i) {
            IRawElementHolder iRawElementHolder3;
            AbstractShape abstractShape;
            RawModelElement rawModelElement = iRawElementHolder.getRawElement(i);
            if (!(rawModelElement instanceof IRawElementHolder) || (abstractShape = (AbstractShape)rawModelElement.getShape()) == null || !abstractShape.contains(point) || (iRawElementHolder3 = this.getHolderAt((IRawElementHolder)rawModelElement, point)) == null) continue;
            iRawElementHolder2 = iRawElementHolder3;
            break;
        }
        return iRawElementHolder2;
    }

    public List<RawModelElement> getElementsIn(Rectangle rectangle) {
        ArrayList<RawModelElement> arrayList = new ArrayList<RawModelElement>();
        int n = this.m_Chunk.getRawElementCount();
        for (int i = 0; i < n; ++i) {
            RawModelElement rawModelElement = this.m_Chunk.getRawElement(i);
            AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
            if (abstractShape == null) continue;
            Rectangle rectangle2 = abstractShape.getRect();
            Point point = new Point(rectangle2.x, rectangle2.y);
            Point point2 = new Point(rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
            if (!rectangle.contains(point) || !rectangle.contains(point2)) continue;
            arrayList.add(rawModelElement);
        }
        return arrayList;
    }

    public void firstElement() {
        Object object = TreeUtil.getObject((TreeModel)this.m_ChunkTreeModel, 0);
        if (object != null) {
            this.m_SelectionManager.setSelection((RawModelElement)object);
            this.repaintChunk();
        }
    }

    public void nextElement() {
        RawModelElement rawModelElement;
        int n;
        List<RawModelElement> list = this.m_SelectionManager.getSelection();
        if (list.size() == 1 && (n = TreeUtil.getRow((TreeModel)this.m_ChunkTreeModel, rawModelElement = list.get(0))) >= 0) {
            Object object = TreeUtil.getObject((TreeModel)this.m_ChunkTreeModel, n + 1);
            if (object == null) {
                object = TreeUtil.getObject((TreeModel)this.m_ChunkTreeModel, 0);
            }
            if (object != null && object != rawModelElement) {
                this.m_SelectionManager.setSelection((RawModelElement)object);
                this.repaintChunk();
            }
        }
    }

    public void previousElement() {
        RawModelElement rawModelElement;
        int n;
        List<RawModelElement> list = this.m_SelectionManager.getSelection();
        if (list.size() == 1 && (n = TreeUtil.getRow((TreeModel)this.m_ChunkTreeModel, rawModelElement = list.get(0))) >= 0) {
            Object object = TreeUtil.getObject((TreeModel)this.m_ChunkTreeModel, n - 1);
            if (object == null) {
                object = TreeUtil.getLastObject((TreeModel)this.m_ChunkTreeModel);
            }
            if (object != null && object != rawModelElement) {
                this.m_SelectionManager.setSelection((RawModelElement)object);
                this.repaintChunk();
            }
        }
    }

    public void lastElement() {
        Object object = TreeUtil.getLastObject((TreeModel)this.m_ChunkTreeModel);
        if (object != null) {
            this.m_SelectionManager.setSelection((RawModelElement)object);
            this.repaintChunk();
        }
    }

    protected ElementPosition[] getSelectedElementPositions() {
        List<RawModelElement> list = this.m_SelectionManager.getSelection();
        ElementPosition[] elementPositionArray = new ElementPosition[list.size()];
        for (int i = 0; i < elementPositionArray.length; ++i) {
            RawModelElement rawModelElement = list.get(i);
            int n = this.m_ChunkTreeModel.getIndexOfChild((Object)rawModelElement.getParent(), (Object)rawModelElement);
            elementPositionArray[i] = new ElementPosition(rawModelElement, n);
        }
        Arrays.sort(elementPositionArray, new Comparator<ElementPosition>(){

            @Override
            public int compare(ElementPosition elementPosition, ElementPosition elementPosition2) {
                if (elementPosition.position < elementPosition2.position) {
                    return -1;
                }
                if (elementPosition.position > elementPosition2.position) {
                    return 1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        return elementPositionArray;
    }

    protected List<RawModelElement> getElements(ElementPosition[] elementPositionArray) {
        ArrayList<RawModelElement> arrayList = new ArrayList<RawModelElement>();
        for (int i = 0; i < elementPositionArray.length; ++i) {
            arrayList.add(elementPositionArray[i].element);
        }
        return arrayList;
    }

    public class Cut
    implements Command {
        private ElementPosition[] m_EP;
        private BasicRawElementHolder m_Parent;

        @Override
        public void doIt() {
            this.m_EP = ChunkManager.this.getSelectedElementPositions();
            if (this.m_EP.length > 0) {
                this.m_Parent = (BasicRawElementHolder)ChunkManager.this.m_SelectionManager.getSelectionParent();
                List<RawModelElement> list = ChunkManager.this.getElements(this.m_EP);
                for (int i = 0; i < this.m_EP.length; ++i) {
                    this.m_Parent.removeRawElement(this.m_EP[i].element);
                }
                Holder holder = new Holder();
                for (RawModelElement rawModelElement : list) {
                    holder.addContent((Object)rawModelElement);
                }
                ClipboardUtil.setHolder(holder);
                ChunkManager.this.m_SelectionManager.removeAllSelections();
                ChunkManager.this.repaintChunk();
            }
        }

        @Override
        public void undoIt() {
            if (this.m_EP.length > 0) {
                for (int i = 0; i < this.m_EP.length; ++i) {
                    this.m_Parent.addRawElement(this.m_EP[i].position, this.m_EP[i].element);
                }
                ChunkManager.this.m_SelectionManager.forceSelection(ChunkManager.this.getElements(this.m_EP));
                ChunkManager.this.repaintChunk();
            }
        }

        @Override
        public void redoIt() {
            this.doIt();
        }
    }

    public class Paste
    implements Command {
        private List<RawModelElement> m_OldSelection;
        private List<RawModelElement> m_Elements;
        private BasicRawElementHolder m_Parent;

        @Override
        public void doIt() {
            this.m_OldSelection = ChunkManager.this.m_SelectionManager.getSelection();
            this.m_Elements = new ArrayList<RawModelElement>();
            Object object = ClipboardUtil.getHolder(false);
            Iterator object22 = object.getContentIterator();
            while (object22.hasNext()) {
                Object object2 = object22.next();
                if (!(object2 instanceof RawModelElement) || object2 instanceof Chunk) continue;
                RawModelElement rawModelElement = (RawModelElement)object2;
                UiFactory.current().buildShape(rawModelElement);
                this.m_Elements.add(rawModelElement);
            }
            if (this.m_Elements.size() > 0) {
                Rectangle rectangle;
                this.m_Parent = ChunkManager.this.m_Chunk;
                if (this.m_OldSelection.size() == 1 && (object = this.m_OldSelection.get(0)) instanceof BasicRawElementHolder) {
                    this.m_Parent = (BasicRawElementHolder)object;
                }
                if (!((Rectangle)(object = this.m_Parent.getShape().getChildRect())).contains(rectangle = this.getBoundingRect())) {
                    for (RawModelElement rawModelElement : this.m_Elements) {
                        if (this.m_Parent instanceof Cell) {
                            rawModelElement.getShape().setRect((Rectangle)object);
                            continue;
                        }
                        this.constrain(rawModelElement, (Rectangle)object);
                    }
                }
                this.m_Parent.addAllRawElements(this.m_Elements);
                for (RawModelElement rawModelElement : this.m_Elements) {
                    rawModelElement.loaded();
                }
                ChunkManager.this.m_SelectionManager.forceSelection(this.m_Elements);
                ChunkManager.this.repaintChunk();
            }
        }

        @Override
        public void undoIt() {
            if (this.m_Elements.size() > 0) {
                this.m_Parent.removeAllRawElements(this.m_Elements);
                ChunkManager.this.m_SelectionManager.forceSelection(this.m_OldSelection);
                ChunkManager.this.repaintChunk();
            }
        }

        @Override
        public void redoIt() {
            if (this.m_Elements.size() > 0) {
                this.m_Parent.addAllRawElements(this.m_Elements);
                ChunkManager.this.m_SelectionManager.forceSelection(this.m_Elements);
                ChunkManager.this.repaintChunk();
            }
        }

        private Rectangle getBoundingRect() {
            Iterator<RawModelElement> iterator = this.m_Elements.iterator();
            RawModelElement rawModelElement = iterator.next();
            Rectangle rectangle = new Rectangle(rawModelElement.getLeft(), rawModelElement.getTop(), rawModelElement.getWidth(), rawModelElement.getHeight());
            while (iterator.hasNext()) {
                rawModelElement = iterator.next();
                rectangle = rectangle.union(new Rectangle(rawModelElement.getLeft(), rawModelElement.getTop(), rawModelElement.getWidth(), rawModelElement.getHeight()));
            }
            return rectangle;
        }

        private void constrain(RawModelElement rawModelElement, Rectangle rectangle) {
            int n = rawModelElement.getTop();
            int n2 = rawModelElement.getLeft();
            int n3 = rectangle.x + rectangle.width;
            int n4 = rectangle.y + rectangle.height;
            if (rawModelElement.getLeft() + rawModelElement.getWidth() > n3) {
                rawModelElement.setLeft(Math.max(rectangle.x, n3 - rawModelElement.getWidth()));
            }
            if (rawModelElement.getTop() + rawModelElement.getHeight() > n4) {
                rawModelElement.setTop(Math.max(rectangle.y, n4 - rawModelElement.getHeight()));
            }
            if (rawModelElement.getLeft() < rectangle.x) {
                rawModelElement.setLeft(rectangle.x);
            }
            if (rawModelElement.getTop() < rectangle.y) {
                rawModelElement.setTop(rectangle.y);
            }
            if (rawModelElement instanceof IRawElementHolder) {
                int n5 = rawModelElement.getLeft() - n2;
                int n6 = rawModelElement.getTop() - n;
                if (n5 != 0 || n6 != 0) {
                    this.shift((IRawElementHolder)rawModelElement, n5, n6);
                }
            }
        }

        private void shift(IRawElementHolder iRawElementHolder, int n, int n2) {
            Iterator iterator = iRawElementHolder.getRawElementIterator();
            while (iterator.hasNext()) {
                RawModelElement rawModelElement = (RawModelElement)iterator.next();
                rawModelElement.setLeft(rawModelElement.getLeft() + n);
                rawModelElement.setTop(rawModelElement.getTop() + n2);
                if (!(rawModelElement instanceof IRawElementHolder)) continue;
                this.shift((IRawElementHolder)rawModelElement, n, n2);
            }
        }
    }

    public class Group
    implements Command {
        private ElementPosition[] m_EP;
        private BasicRawElementHolder m_Parent;
        private ShapeGroup m_ShapeGroup;
        private int m_TargetPos;

        @Override
        public void doIt() {
            this.m_EP = ChunkManager.this.getSelectedElementPositions();
            if (this.m_EP.length > 1) {
                this.m_Parent = (BasicRawElementHolder)ChunkManager.this.m_SelectionManager.getSelectionParent();
                this.m_TargetPos = this.m_EP[this.m_EP.length - 1].position;
                this.m_ShapeGroup = new ShapeGroup();
                UiFactory.current().buildShape((RawModelElement)this.m_ShapeGroup);
                this.m_Parent.addRawElement(this.m_TargetPos, (RawModelElement)this.m_ShapeGroup);
                this.m_Parent.removeAllRawElements(ChunkManager.this.getElements(this.m_EP));
                this.m_ShapeGroup.addAllRawElements(ChunkManager.this.getElements(this.m_EP));
                ((GroupShape)this.m_ShapeGroup.getShape()).buildBoundingBox();
                ChunkManager.this.m_SelectionManager.forceSelection((RawModelElement)this.m_ShapeGroup);
                ChunkManager.this.repaintChunk();
            }
        }

        @Override
        public void undoIt() {
            if (this.m_EP.length > 1) {
                this.m_Parent.removeRawElement((RawModelElement)this.m_ShapeGroup);
                for (int i = 0; i < this.m_EP.length; ++i) {
                    this.m_Parent.addRawElement(this.m_EP[i].position, this.m_EP[i].element);
                }
                ChunkManager.this.m_SelectionManager.forceSelection(ChunkManager.this.getElements(this.m_EP));
                ChunkManager.this.repaintChunk();
            }
        }

        @Override
        public void redoIt() {
            this.doIt();
        }
    }

    public class Ungroup
    implements Command {
        private ElementPosition[] m_EP;
        private BasicRawElementHolder m_Parent;
        private List<ElementPosition> m_Groups = new ArrayList<ElementPosition>();
        private List<RawModelElement> m_AllElements = new ArrayList<RawModelElement>();

        @Override
        public void doIt() {
            this.m_EP = ChunkManager.this.getSelectedElementPositions();
            this.m_Parent = (BasicRawElementHolder)ChunkManager.this.m_SelectionManager.getSelectionParent();
            this.m_AllElements.clear();
            for (int i = 0; i < this.m_EP.length; ++i) {
                if (this.m_EP[i].element instanceof ShapeGroup) {
                    this.m_Groups.add(this.m_EP[i]);
                    List list = ((ShapeGroup)this.m_EP[i].element).getRawElementList();
                    this.m_AllElements.addAll(list);
                    int n = this.m_EP[i].position;
                    for (RawModelElement rawModelElement : list) {
                        this.m_Parent.addRawElement(n, rawModelElement);
                        ++n;
                    }
                    this.m_Parent.removeRawElement(this.m_EP[i].element);
                    ChunkManager.this.m_SelectionManager.removeSelection(this.m_EP[i].element);
                    ChunkManager.this.m_SelectionManager.forceSelection(list);
                }
                ChunkManager.this.repaintChunk();
            }
        }

        @Override
        public void undoIt() {
            if (this.m_EP.length > 1) {
                this.m_Parent.removeAllRawElements(this.m_AllElements);
                for (ElementPosition elementPosition : this.m_Groups) {
                    this.m_Parent.addRawElement(elementPosition.position, elementPosition.element);
                }
                ChunkManager.this.repaintChunk();
            }
        }

        @Override
        public void redoIt() {
            this.doIt();
        }
    }

    private class Add
    implements Command {
        private BasicRawElementHolder m_Parent;
        private RawModelElement m_Element;
        private boolean m_ShiftPressed;
        private List<RawModelElement> m_OldSelection;

        public Add(BasicRawElementHolder basicRawElementHolder, RawModelElement rawModelElement, boolean bl) {
            assert (basicRawElementHolder != null);
            assert (rawModelElement != null);
            this.m_Parent = basicRawElementHolder;
            this.m_Element = rawModelElement;
            this.m_ShiftPressed = bl;
        }

        @Override
        public void doIt() {
            this.m_OldSelection = ChunkManager.this.m_SelectionManager.getSelection();
            this.m_Parent.addRawElement(this.m_Element);
            if (this.m_ShiftPressed) {
                ChunkManager.this.m_SelectionManager.addSelection(this.m_Element);
            } else {
                ChunkManager.this.m_SelectionManager.forceSelection(this.m_Element);
            }
            ChunkManager.this.repaintChunk();
        }

        @Override
        public void undoIt() {
            this.m_Parent.removeRawElement(this.m_Element);
            ChunkManager.this.m_SelectionManager.forceSelection(this.m_OldSelection);
            ChunkManager.this.repaintChunk();
        }

        @Override
        public void redoIt() {
            this.m_Parent.addRawElement(this.m_Element);
            if (this.m_ShiftPressed) {
                ChunkManager.this.m_SelectionManager.addSelection(this.m_Element);
            } else {
                ChunkManager.this.m_SelectionManager.forceSelection(this.m_Element);
            }
            ChunkManager.this.repaintChunk();
        }
    }

    public class Remove
    implements Command {
        private ElementPosition[] m_EP;
        private BasicRawElementHolder m_Parent;

        @Override
        public void doIt() {
            this.m_EP = ChunkManager.this.getSelectedElementPositions();
            if (this.m_EP.length > 0) {
                this.m_Parent = (BasicRawElementHolder)ChunkManager.this.m_SelectionManager.getSelectionParent();
                if (this.m_Parent != null) {
                    List<RawModelElement> list = ChunkManager.this.getElements(this.m_EP);
                    this.m_Parent.removeAllRawElements(list);
                    ChunkManager.this.m_SelectionManager.forceSelection((RawModelElement)this.m_Parent);
                    ChunkManager.this.repaintChunk();
                }
            }
        }

        @Override
        public void undoIt() {
            if (this.m_Parent != null && this.m_EP.length > 0) {
                ArrayList<RawModelElement> arrayList = new ArrayList<RawModelElement>();
                for (int i = 0; i < this.m_EP.length; ++i) {
                    ElementPosition elementPosition = this.m_EP[i];
                    this.m_Parent.addRawElement(elementPosition.position, elementPosition.element);
                    arrayList.add(elementPosition.element);
                }
                ChunkManager.this.m_SelectionManager.forceSelection(arrayList);
                ChunkManager.this.repaintChunk();
            }
        }

        @Override
        public void redoIt() {
            if (this.m_Parent != null && this.m_EP.length > 0) {
                List<RawModelElement> list = ChunkManager.this.getElements(this.m_EP);
                this.m_Parent.removeAllRawElements(list);
                ChunkManager.this.m_SelectionManager.forceSelection((RawModelElement)this.m_Parent);
                ChunkManager.this.repaintChunk();
            }
        }
    }

    public class BringToFront
    implements Command {
        private ElementPosition[] m_EP;
        private BasicRawElementHolder m_Parent;

        @Override
        public void doIt() {
            this.m_EP = ChunkManager.this.getSelectedElementPositions();
            this.m_Parent = (BasicRawElementHolder)ChunkManager.this.m_SelectionManager.getSelectionParent();
            this.m_Parent.removeAllRawElements(ChunkManager.this.getElements(this.m_EP));
            for (int i = 0; i < this.m_EP.length; ++i) {
                this.m_Parent.addRawElement(this.m_EP[i].element);
            }
            ChunkManager.this.repaintChunk();
        }

        @Override
        public void undoIt() {
            this.m_Parent.removeAllRawElements(ChunkManager.this.getElements(this.m_EP));
            for (int i = 0; i < this.m_EP.length; ++i) {
                this.m_Parent.addRawElement(this.m_EP[i].position, this.m_EP[i].element);
            }
            ChunkManager.this.repaintChunk();
        }

        @Override
        public void redoIt() {
            this.m_Parent.removeAllRawElements(ChunkManager.this.getElements(this.m_EP));
            for (int i = 0; i < this.m_EP.length; ++i) {
                this.m_Parent.addRawElement(this.m_EP[i].element);
            }
            ChunkManager.this.repaintChunk();
        }
    }

    public class SendToBack
    implements Command {
        private ElementPosition[] m_EP;
        private BasicRawElementHolder m_Parent;

        @Override
        public void doIt() {
            this.m_EP = ChunkManager.this.getSelectedElementPositions();
            this.m_Parent = (BasicRawElementHolder)ChunkManager.this.m_SelectionManager.getSelectionParent();
            this.m_Parent.removeAllRawElements(ChunkManager.this.getElements(this.m_EP));
            for (int i = 0; i < this.m_EP.length; ++i) {
                this.m_Parent.addRawElement(i, this.m_EP[i].element);
            }
            ChunkManager.this.repaintChunk();
        }

        @Override
        public void undoIt() {
            this.m_Parent.removeAllRawElements(ChunkManager.this.getElements(this.m_EP));
            for (int i = 0; i < this.m_EP.length; ++i) {
                this.m_Parent.addRawElement(this.m_EP[i].position, this.m_EP[i].element);
            }
            ChunkManager.this.repaintChunk();
        }

        @Override
        public void redoIt() {
            this.m_Parent.removeAllRawElements(ChunkManager.this.getElements(this.m_EP));
            for (int i = 0; i < this.m_EP.length; ++i) {
                this.m_Parent.addRawElement(i, this.m_EP[i].element);
            }
            ChunkManager.this.repaintChunk();
        }
    }

    public class BringForward
    implements Command {
        private ElementPosition[] m_EP;
        private BasicRawElementHolder m_Parent;
        private int m_TargetPos;

        @Override
        public void doIt() {
            this.m_EP = ChunkManager.this.getSelectedElementPositions();
            if (this.m_EP.length > 0) {
                this.m_Parent = (BasicRawElementHolder)ChunkManager.this.m_SelectionManager.getSelectionParent();
                int n = this.m_EP[this.m_EP.length - 1].position + 1;
                RawModelElement rawModelElement = null;
                if (n < this.m_Parent.getRawElementCount()) {
                    rawModelElement = this.m_Parent.getRawElement(n);
                }
                this.m_Parent.removeAllRawElements(ChunkManager.this.getElements(this.m_EP));
                this.m_TargetPos = rawModelElement != null ? this.m_Parent.indexOfRawElement(rawModelElement) + 1 : this.m_Parent.getRawElementCount();
                for (int i = 0; i < this.m_EP.length; ++i) {
                    this.m_Parent.addRawElement(this.m_TargetPos + i, this.m_EP[i].element);
                }
                ChunkManager.this.repaintChunk();
            }
        }

        @Override
        public void undoIt() {
            if (this.m_EP.length > 0) {
                this.m_Parent.removeAllRawElements(ChunkManager.this.getElements(this.m_EP));
                for (int i = 0; i < this.m_EP.length; ++i) {
                    this.m_Parent.addRawElement(this.m_EP[i].position, this.m_EP[i].element);
                }
                ChunkManager.this.repaintChunk();
            }
        }

        @Override
        public void redoIt() {
            if (this.m_EP.length > 0) {
                this.m_Parent.removeAllRawElements(ChunkManager.this.getElements(this.m_EP));
                for (int i = 0; i < this.m_EP.length; ++i) {
                    this.m_Parent.addRawElement(this.m_TargetPos + i, this.m_EP[i].element);
                }
                ChunkManager.this.repaintChunk();
            }
        }
    }

    public class SendBack
    implements Command {
        private ElementPosition[] m_EP;
        private BasicRawElementHolder m_Parent;
        private int m_TargetPos;

        @Override
        public void doIt() {
            this.m_EP = ChunkManager.this.getSelectedElementPositions();
            if (this.m_EP.length > 0) {
                this.m_Parent = (BasicRawElementHolder)ChunkManager.this.m_SelectionManager.getSelectionParent();
                int n = this.m_EP[0].position - 1;
                RawModelElement rawModelElement = null;
                if (n >= 0) {
                    rawModelElement = this.m_Parent.getRawElement(n);
                }
                this.m_Parent.removeAllRawElements(ChunkManager.this.getElements(this.m_EP));
                this.m_TargetPos = rawModelElement != null ? this.m_Parent.indexOfRawElement(rawModelElement) : 0;
                for (int i = 0; i < this.m_EP.length; ++i) {
                    this.m_Parent.addRawElement(this.m_TargetPos + i, this.m_EP[i].element);
                }
                ChunkManager.this.repaintChunk();
            }
        }

        @Override
        public void undoIt() {
            if (this.m_EP.length > 0) {
                this.m_Parent.removeAllRawElements(ChunkManager.this.getElements(this.m_EP));
                for (int i = 0; i < this.m_EP.length; ++i) {
                    this.m_Parent.addRawElement(this.m_EP[i].position, this.m_EP[i].element);
                }
                ChunkManager.this.repaintChunk();
            }
        }

        @Override
        public void redoIt() {
            if (this.m_EP.length > 0) {
                this.m_Parent.removeAllRawElements(ChunkManager.this.getElements(this.m_EP));
                for (int i = 0; i < this.m_EP.length; ++i) {
                    this.m_Parent.addRawElement(this.m_TargetPos + i, this.m_EP[i].element);
                }
                ChunkManager.this.repaintChunk();
            }
        }
    }

    private class ElementPosition {
        public RawModelElement element;
        public int position;

        public ElementPosition(RawModelElement rawModelElement, int n) {
            this.element = rawModelElement;
            this.position = n;
        }
    }
}

