/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.chunk;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.command.CommandManager;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.erd.reportdesigner.LayoutTab;
import com.elixirtech.erd.reportdesigner.RowHeader;
import com.elixirtech.erd.reportdesigner.Ruler;
import com.elixirtech.erd.reportdesigner.VerticalRuler;
import com.elixirtech.erd.reportdesigner.chunk.ChunkManager;
import com.elixirtech.erd.reportdesigner.chunk.UiFactory;
import com.elixirtech.erd.reportdesigner.dnd.DNDProvider;
import com.elixirtech.erd.reportdesigner.select.SelectionManager;
import com.elixirtech.erd.reportdesigner.shape.ChunkShape;
import com.elixirtech.erd.reportdesigner.tool.SelectionTool;
import com.elixirtech.erd.reportdesigner.tool.Tool;
import com.elixirtech.i18n.I18NBypass;
import com.elixirtech.report2.raw.IChunkPanel;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.ui.Icons;
import com.elixirtech.ui.StandardColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;

public abstract class ChunkPanel
extends JPanel
implements IChunkPanel,
ActionListener {
    public static final Font BAR_FONT = new Font("SansSerif", 0, 9);
    public static final int DRAGGER_HEIGHT = 5;
    LayoutTab m_LayoutTab;
    Chunk m_Chunk;
    ChunkShape m_ChunkShape;
    int m_ZoomPercent = 100;
    VerticalRuler m_Ruler;
    SelectionManager m_SelectionManager;
    boolean m_IsCurrent;
    private boolean m_Collapsed;
    private Bar m_Bar;
    private ChunkBody m_ChunkBody;
    private Dragger m_Dragger;
    private PlusMinusButton m_PlusMinusButton;
    private ChunkManager m_ChunkManager;
    private boolean m_RulersEnabled = true;
    private static final int[] NO_RULERS = new int[0];
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ChunkPanel.class);
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);

    public ChunkPanel(LayoutTab layoutTab, Chunk chunk) {
        assert (layoutTab != null);
        assert (chunk != null);
        assert (chunk.getSection() != null);
        this.m_LayoutTab = layoutTab;
        this.m_Chunk = chunk;
        this.m_Chunk.setChunkPanel((IChunkPanel)this);
        this.m_ChunkShape = UiFactory.current().buildShapes(this.m_Chunk);
        this.m_SelectionManager = this.m_LayoutTab.getSelectionManager();
        this.m_ChunkManager = new ChunkManager(this);
        this.setLayout(new BorderLayout());
        this.m_Bar = new Bar();
        this.m_Ruler = new VerticalRuler(this);
        this.m_ChunkBody = new ChunkBody();
        this.m_Dragger = new Dragger();
        this.m_PlusMinusButton = new PlusMinusButton();
        int n = this.m_PlusMinusButton.getPreferredSize().width;
        int n2 = this.m_Bar.getPreferredSize().height;
        this.m_PlusMinusButton.setPreferredSize(new Dimension(n, n2));
        this.add((Component)this.m_Bar, "North");
        this.add((Component)this.m_ChunkBody, "Center");
        this.add((Component)this.m_Dragger, "South");
        this.setZoomPercent(100);
        new DNDProvider(this);
        this.refresh();
    }

    public boolean isReadOnly() {
        return this.m_LayoutTab.isReadOnly();
    }

    public void refresh() {
        this.m_Ruler.setReadOnly(this.isReadOnly());
    }

    public Chunk getChunk() {
        return this.m_Chunk;
    }

    public ChunkManager getChunkManager() {
        return this.m_ChunkManager;
    }

    public RawReport getReport() {
        return this.m_LayoutTab.getReport();
    }

    public CommandManager getCommandManager() {
        return this.m_LayoutTab.getCommandManager();
    }

    public void setCurrent(boolean bl) {
        if (bl != this.m_IsCurrent) {
            this.m_IsCurrent = bl;
            if (this.m_IsCurrent) {
                this.m_ChunkBody.requestFocus();
                this.m_LayoutTab.setTreeModel((TreeModel)this.m_Chunk.getTreeModel());
                this.m_SelectionManager.setVRuler(this.m_Ruler);
                assert (this.m_SelectionManager.getSelectionCount() == 0);
            } else {
                this.m_SelectionManager.removeAllSelections();
                this.m_ChunkBody.repaint();
                this.m_Ruler.setCurrentRange(null);
            }
        }
    }

    public DataSchema getSectionSchema() {
        try {
            DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
            Section section = this.m_Chunk.getSection();
            String string = section.getDataSource();
            DataSource dataSource = section.getRawReport().getDataSource(string);
            IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, dataSource.getDataSourceName());
            return iDataSource.getSchema();
        }
        catch (Exception exception) {
            return new DataSchema();
        }
    }

    public SelectionManager getSelectionManager() {
        return this.m_SelectionManager;
    }

    public void setRulersEnabled(boolean bl) {
        this.m_RulersEnabled = bl;
    }

    public boolean isRulersEnabled() {
        return this.m_RulersEnabled;
    }

    public VerticalRuler getRuler() {
        if (this.m_Collapsed) {
            return null;
        }
        return this.m_Ruler;
    }

    public int[] getHRulers() {
        if (this.m_RulersEnabled) {
            return this.m_LayoutTab.getRuler().getPositions();
        }
        return NO_RULERS;
    }

    public int[] getVRulers() {
        if (this.m_RulersEnabled) {
            return this.m_Ruler.getPositions();
        }
        return NO_RULERS;
    }

    public JToggleButton getToggleButton() {
        return this.m_PlusMinusButton;
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.m_ChunkBody.setCursor(cursor);
    }

    public void repaintBody() {
        this.m_ChunkBody.repaint();
    }

    public void repaintBody(Rectangle rectangle) {
        rectangle.x = rectangle.x * this.m_ZoomPercent / 2000;
        rectangle.y = rectangle.y * this.m_ZoomPercent / 2000;
        rectangle.width = rectangle.width * this.m_ZoomPercent / 2000;
        rectangle.height = rectangle.height * this.m_ZoomPercent / 2000;
        this.m_ChunkBody.repaint(rectangle);
    }

    public void focusBody() {
        this.m_ChunkBody.requestFocus();
    }

    public void updateSize() {
        this.invalidate();
        this.getParent().getParent().getParent().validate();
    }

    public Graphics2D getBodyGraphics() {
        Dimension dimension = this.m_ChunkBody.getSize();
        this.m_ChunkBody.paintImmediately(0, 0, dimension.width, dimension.height);
        Graphics2D graphics2D = (Graphics2D)this.m_ChunkBody.getGraphics();
        double d = (double)this.m_ZoomPercent / 2000.0;
        graphics2D.scale(d, d);
        return graphics2D;
    }

    public void setZoomPercent(int n) {
        this.m_ZoomPercent = n;
        this.m_Ruler.setZoomPercent(n);
        this.m_Ruler.invalidate();
        this.invalidate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.m_Collapsed = !this.m_Collapsed;
        if (this.m_Collapsed) {
            this.m_PlusMinusButton.setIcon(Icons.getPlus());
            this.remove(this.m_ChunkBody);
            this.remove(this.m_Dragger);
        } else {
            this.m_PlusMinusButton.setIcon(Icons.getMinus());
            this.add((Component)this.m_ChunkBody, "Center");
            this.add((Component)this.m_Dragger, "South");
        }
        RowHeader rowHeader = this.m_LayoutTab.getRowHeader();
        rowHeader.rebuild();
        rowHeader.repaint();
        this.updateSize();
    }

    public abstract String getChunkTitle();

    public JPopupMenu getBarPopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = SelectionTool.current().getPopup(this, mouseEvent);
        return jPopupMenu;
    }

    protected PageSetup getPageSetup() {
        Section section = this.m_Chunk.getSection();
        String string = section.getPageSetup();
        if (string != null) {
            RawReport rawReport = this.m_LayoutTab.getReport();
            Iterator iterator = rawReport.getPageSetupIterator();
            while (iterator.hasNext()) {
                PageSetup pageSetup = (PageSetup)iterator.next();
                if (!string.equals(pageSetup.getName())) continue;
                return pageSetup;
            }
        }
        return null;
    }

    protected int getChunkWidth(PageSetup pageSetup) {
        int n = pageSetup.getWidth();
        n = n - pageSetup.getLeft() - pageSetup.getRight();
        return this.adjustForColumns(pageSetup, n *= pageSetup.getHorizontalPageCount());
    }

    protected int getPageWidth(PageSetup pageSetup) {
        int n = pageSetup.getWidth();
        n = n - pageSetup.getLeft() - pageSetup.getRight();
        return n;
    }

    public int getChunkWidth() {
        PageSetup pageSetup = this.getPageSetup();
        if (pageSetup != null) {
            return this.getChunkWidth(pageSetup);
        }
        return 0;
    }

    public int getPageWidth() {
        PageSetup pageSetup = this.getPageSetup();
        if (pageSetup != null) {
            return this.getPageWidth(pageSetup);
        }
        return 0;
    }

    public Dimension getBodySize() {
        return new Dimension(this.getChunkWidth() / 20 * this.m_ZoomPercent / 100, this.m_Chunk.getHeight() / 20 * this.m_ZoomPercent / 100);
    }

    public Point convertPointFromPanelToBody(Point point) {
        return SwingUtilities.convertPoint(this, point.x, point.y, this.m_ChunkBody);
    }

    public void ensureCurrent() {
        this.m_ChunkBody.ensureCurrent();
    }

    protected int adjustForColumns(PageSetup pageSetup, int n) {
        return n;
    }

    protected class Bar
    extends JPanel {
        private JLabel m_Label;

        public Bar() {
            this.setLayout(new BorderLayout());
            this.m_Label = I18NBypass.newLabel(ChunkPanel.this.getChunkTitle());
            this.m_Label.setFont(BAR_FONT);
            this.setBorder(BorderFactory.createRaisedBevelBorder());
            this.add((Component)this.m_Label, "Center");
            this.enableEvents(16L);
        }

        @Override
        public void paint(Graphics graphics) {
            this.m_Label.setText(ChunkPanel.this.getChunkTitle());
            super.paint(graphics);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu;
            super.processMouseEvent(mouseEvent);
            int n = mouseEvent.getID();
            if (n == 501 && !ChunkPanel.this.m_IsCurrent) {
                ChunkPanel.this.m_LayoutTab.setCurrentChunk(ChunkPanel.this);
                ChunkPanel.this.m_LayoutTab.setTreeModel((TreeModel)ChunkPanel.this.m_Chunk.getTreeModel());
                ChunkPanel.this.m_SelectionManager.setSelection((RawModelElement)ChunkPanel.this.m_Chunk);
            }
            if (mouseEvent.isPopupTrigger() && (jPopupMenu = ChunkPanel.this.getBarPopup(mouseEvent)) != null) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class ChunkBody
    extends JPanel
    implements Ruler.MarkerListener {
        public ChunkBody() {
            this.enableEvents(56L);
            this.setFocusTraversalKeysEnabled(false);
            this.setBackground(Color.white);
            ChunkPanel.this.m_Ruler.addMarkerListener(this);
        }

        @Override
        public void setCursor(Cursor cursor) {
            super.setCursor(cursor);
        }

        @Override
        public Dimension getPreferredSize() {
            return ChunkPanel.this.getBodySize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            this.drawBackground(graphics2D);
            double d = (double)ChunkPanel.this.m_ZoomPercent / 2000.0;
            graphics2D.scale(d, d);
            try {
                ChunkPanel.this.m_ChunkShape.draw(graphics2D);
                ChunkPanel.this.m_ChunkShape.drawGrid(graphics2D, ChunkPanel.this.m_ZoomPercent);
                ChunkPanel.this.m_ChunkShape.drawShapes(graphics2D);
                this.drawMarkers(graphics2D);
                if (ChunkPanel.this.m_IsCurrent) {
                    ChunkPanel.this.m_SelectionManager.drawHandles(graphics2D);
                    ChunkPanel.this.m_SelectionManager.drawRanges();
                }
            }
            catch (Throwable throwable) {
                m_Log.error((Object)("Error in paintComponent: " + String.valueOf(throwable)), throwable);
            }
        }

        protected void drawBackground(Graphics2D graphics2D) {
            Dimension dimension = this.getSize();
            graphics2D.setColor(SystemColor.control);
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            PageSetup pageSetup = ChunkPanel.this.getPageSetup();
            if (pageSetup != null) {
                dimension.width = ChunkPanel.this.getChunkWidth(pageSetup) / 20 * ChunkPanel.this.m_ZoomPercent / 100;
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, dimension.width, dimension.height);
                graphics2D.setColor(StandardColor.lookup("ERD-Construction-Line"));
                int n = ChunkPanel.this.getPageWidth(pageSetup) / 20 * ChunkPanel.this.m_ZoomPercent / 100;
                if (n > 0) {
                    for (int i = n; i < dimension.width; i += n) {
                        graphics2D.drawLine(i, 0, i, dimension.height);
                    }
                }
            }
        }

        protected void drawMarkers(Graphics2D graphics2D) {
            Dimension dimension = this.getSize();
            PageSetup pageSetup = ChunkPanel.this.getPageSetup();
            if (pageSetup != null) {
                dimension.width = ChunkPanel.this.getChunkWidth(pageSetup) * ChunkPanel.this.m_ZoomPercent / 100;
                dimension.height = dimension.height * 20 * ChunkPanel.this.m_ZoomPercent / 100;
                ChunkPanel.this.m_Ruler.drawMarkerLines(graphics2D, dimension.width);
                ChunkPanel.this.m_LayoutTab.getRuler().drawMarkerLines(graphics2D, dimension.height);
            }
        }

        @Override
        public void markersChanged() {
            this.repaint();
        }

        public void ensureCurrent() {
            if (!ChunkPanel.this.m_IsCurrent) {
                ChunkPanel.this.m_LayoutTab.setCurrentChunk(ChunkPanel.this);
                ChunkPanel.this.m_LayoutTab.setTreeModel((TreeModel)ChunkPanel.this.m_Chunk.getTreeModel());
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            try {
                Point point = mouseEvent.getPoint();
                int n = point.x * 20 * 100 / ChunkPanel.this.m_ZoomPercent;
                int n2 = point.y * 20 * 100 / ChunkPanel.this.m_ZoomPercent;
                int n3 = n - point.x;
                int n4 = n2 - point.y;
                mouseEvent.translatePoint(n3, n4);
                Tool tool = ChunkPanel.this.m_LayoutTab.getCurrentTool();
                switch (mouseEvent.getID()) {
                    case 501: {
                        this.ensureCurrent();
                        mouseEvent.getComponent().requestFocus();
                        tool.mousePressed(ChunkPanel.this, mouseEvent);
                        if (!mouseEvent.isPopupTrigger()) break;
                        mouseEvent.translatePoint(-n3, -n4);
                        tool.doPopup(ChunkPanel.this, mouseEvent);
                        break;
                    }
                    case 502: {
                        tool.mouseReleased(ChunkPanel.this, mouseEvent);
                        if (!mouseEvent.isPopupTrigger()) break;
                        mouseEvent.translatePoint(-n3, -n4);
                        tool.doPopup(ChunkPanel.this, mouseEvent);
                    }
                }
            }
            catch (Throwable throwable) {
                m_Log.error((Object)("Error in processMouseEvent: " + String.valueOf(throwable)), throwable);
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            super.processMouseMotionEvent(mouseEvent);
            try {
                Point point = mouseEvent.getPoint();
                int n = point.x * 20 * 100 / ChunkPanel.this.m_ZoomPercent;
                int n2 = point.y * 20 * 100 / ChunkPanel.this.m_ZoomPercent;
                int n3 = n - point.x;
                int n4 = n2 - point.y;
                mouseEvent.translatePoint(n3, n4);
                Tool tool = ChunkPanel.this.m_LayoutTab.getCurrentTool();
                switch (mouseEvent.getID()) {
                    case 503: {
                        tool.mouseMoved(ChunkPanel.this, mouseEvent);
                        break;
                    }
                    case 506: {
                        tool.mouseDragged(ChunkPanel.this, mouseEvent);
                    }
                }
            }
            catch (Throwable throwable) {
                m_Log.error((Object)("Error in processMouseMotionEvent: " + String.valueOf(throwable)), throwable);
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            try {
                KeyStroke keyStroke;
                if ((keyEvent.getID() == 401 || keyEvent.getID() == 400) && (keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent)) != null) {
                    Tool tool = ChunkPanel.this.m_LayoutTab.getCurrentTool();
                    tool.keyPressed(ChunkPanel.this, keyStroke);
                }
            }
            catch (Throwable throwable) {
                m_Log.error((Object)("Error in processKeyEvent: " + String.valueOf(throwable)), throwable);
            }
        }
    }

    public class Dragger
    extends JComponent {
        private DragBarState m_DragBarState;

        public Dragger() {
            this.enableEvents(48L);
            this.setBorder(BorderFactory.createRaisedBevelBorder());
            this.setBackground(Color.blue);
        }

        public DragBarState getDragBarState() {
            return this.m_DragBarState;
        }

        public void setLocation(int n) {
            ChunkPanel.this.m_Chunk.setHeight(ChunkPanel.this.m_Chunk.getHeight() + n * 20 * 100 / ChunkPanel.this.m_ZoomPercent);
            ChunkPanel.this.m_ChunkShape.sizeToFitChildren();
            ChunkPanel.this.m_Ruler.invalidate();
            this.invalidate();
            ChunkPanel.this.m_LayoutTab.getReport().setDirty(true);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(ChunkPanel.this.getChunkWidth() / 20 * ChunkPanel.this.m_ZoomPercent / 100, 5);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (ChunkPanel.this.m_Chunk.isLockHandles() || ChunkPanel.this.m_LayoutTab.isReadOnly()) {
                this.setCursor(DEFAULT_CURSOR);
                return;
            }
            this.setCursor(HAND_CURSOR);
            switch (mouseEvent.getID()) {
                case 501: {
                    this.m_DragBarState = new DragBarState(this);
                    this.setBackground(SystemColor.controlShadow);
                    ChunkPanel.this.m_LayoutTab.startDrag(this, mouseEvent);
                    break;
                }
                case 502: {
                    ChunkPanel.this.m_LayoutTab.endDrag(this, mouseEvent);
                    this.m_DragBarState = null;
                    this.setBackground(SystemColor.blue);
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            if (ChunkPanel.this.m_Chunk.isLockHandles() || ChunkPanel.this.m_LayoutTab.isReadOnly()) {
                this.setCursor(DEFAULT_CURSOR);
                return;
            }
            this.setCursor(HAND_CURSOR);
            switch (mouseEvent.getID()) {
                case 506: {
                    ChunkPanel.this.m_LayoutTab.drag(this, mouseEvent);
                }
            }
        }
    }

    private class PlusMinusButton
    extends JToggleButton {
        public PlusMinusButton() {
            this.setIcon(Icons.getMinus());
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setFocusPainted(false);
            this.setSelected(true);
            this.addActionListener(ChunkPanel.this);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = 16;
            return dimension;
        }
    }

    public class DragBarState {
        private Dragger m_MyDragger;
        private Point m_Offset = new Point();
        private Rectangle m_Rectangle = new Rectangle();

        public DragBarState(Dragger dragger) {
            for (Container container = this.m_MyDragger = dragger; container != ChunkPanel.this.m_LayoutTab; container = container.getParent()) {
                Point point = container.getLocation();
                this.m_Offset.x += point.x;
                this.m_Offset.y += point.y;
            }
        }

        public Point getOffset() {
            return this.m_Offset;
        }

        public Rectangle getRectangle() {
            return this.m_Rectangle;
        }
    }
}

