/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.chunk;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.erd.reportdesigner.ERDAction;
import com.elixirtech.erd.reportdesigner.LayoutTab;
import com.elixirtech.erd.reportdesigner.chunk.ColumnBasedChunkPanel;
import com.elixirtech.erd.reportdesigner.chunk.UiFactory;
import com.elixirtech.erd.reportdesigner.section.SortDialog;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.Group;
import com.elixirtech.report2.raw.model.GroupHeader;
import com.elixirtech.report2.raw.model.Section;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class GroupHeaderChunkPanel
extends ColumnBasedChunkPanel {
    public GroupHeaderChunkPanel(LayoutTab layoutTab, Chunk chunk) {
        super(layoutTab, chunk);
    }

    @Override
    public JPopupMenu getBarPopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = super.getBarPopup(mouseEvent);
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(new GroupThisAction(this.m_LayoutTab, this.m_Chunk.getSection(), this.getGroup())));
        return jPopupMenu;
    }

    @Override
    public String getChunkTitle() {
        String string = UiFactory.getI18NString("GROUP_HEADER");
        return MessageFormat.format(string, this.getGroup().getField());
    }

    private Group getGroup() {
        return ((GroupHeader)this.getChunk()).getGroup();
    }

    public static class GroupThisAction
    extends ERDAction {
        private LayoutTab m_LayoutTab;
        private Section m_Section;
        private Group m_Around;

        public GroupThisAction(LayoutTab layoutTab, Section section, Group group) {
            super("GroupThis");
            this.m_LayoutTab = layoutTab;
            this.m_Section = section;
            this.m_Around = group;
            DataSchema dataSchema = section.getSchema();
            this.setEnabled(!layoutTab.isReadOnly() && dataSchema != null && dataSchema.getColumnCount() > 0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Group group = new Group();
            group.setGroupOn("None");
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            SortDialog sortDialog = new SortDialog(elixirFrame.getFrame(), I18N.ERD.getString("GroupHeaderChunkPanel.sort-dialog.title"), this.m_Section.getSchema(), group);
            elixirFrame.showModal(sortDialog);
            if (sortDialog.isOk()) {
                if (this.m_Around == null) {
                    this.m_Section.addGroup(group);
                } else {
                    int n = this.m_Section.getGroupCount();
                    for (int i = 0; i < n; ++i) {
                        Group group2 = this.m_Section.getGroup(i);
                        if (group2 != this.m_Around) continue;
                        this.m_Section.addGroup(i, group);
                        break;
                    }
                }
                this.m_LayoutTab.setCurrent(true);
            }
        }
    }
}

