/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.chunk;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.erd.reportdesigner.shape.CellShape;
import com.elixirtech.erd.reportdesigner.shape.ChunkShape;
import com.elixirtech.erd.reportdesigner.shape.CubeHeaderShape;
import com.elixirtech.erd.reportdesigner.shape.CubeMeasureShape;
import com.elixirtech.erd.reportdesigner.shape.CubeTableShape;
import com.elixirtech.erd.reportdesigner.shape.GroupShape;
import com.elixirtech.erd.reportdesigner.shape.HBoxShape;
import com.elixirtech.erd.reportdesigner.shape.LineShape;
import com.elixirtech.erd.reportdesigner.shape.PageBreakShape;
import com.elixirtech.erd.reportdesigner.shape.TableSectionShape;
import com.elixirtech.erd.reportdesigner.shape.TableShape;
import com.elixirtech.erd.reportdesigner.shape.UiElementShape;
import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.erd.reportdesigner.shape.VBoxShape;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.ShapeBuilder;
import com.elixirtech.report2.raw.model.Cell;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.CubeColumn;
import com.elixirtech.report2.raw.model.CubeMeasure;
import com.elixirtech.report2.raw.model.CubeRow;
import com.elixirtech.report2.raw.model.CubeTable;
import com.elixirtech.report2.raw.model.HBox;
import com.elixirtech.report2.raw.model.IChunk;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.Line;
import com.elixirtech.report2.raw.model.PageBreak;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Shape;
import com.elixirtech.report2.raw.model.ShapeGroup;
import com.elixirtech.report2.raw.model.Table;
import com.elixirtech.report2.raw.model.TableBody;
import com.elixirtech.report2.raw.model.TableFooter;
import com.elixirtech.report2.raw.model.TableHeader;
import com.elixirtech.report2.raw.model.VBox;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UiFactory
implements ShapeBuilder.IShapeBuilder {
    private Map<Class, Class> m_Map;
    private static UiFactory m_Current;
    private static ElxLoggerJ m_Log;

    public static UiFactory current() {
        if (m_Current == null) {
            m_Current = new UiFactory();
            ShapeBuilder.setShapeBuilder((ShapeBuilder.IShapeBuilder)m_Current);
        }
        return m_Current;
    }

    public static String getI18NString(String string) {
        return I18N.ERD.getString(string);
    }

    protected UiFactory() {
        this.initMap();
    }

    public ChunkShape buildShapes(Chunk chunk) {
        ChunkShape chunkShape = new ChunkShape((IChunk)chunk);
        Iterator iterator = chunk.getRawElementIterator();
        while (iterator.hasNext()) {
            RawModelElement rawModelElement = (RawModelElement)iterator.next();
            this.buildShape(rawModelElement);
        }
        return chunkShape;
    }

    public Shape buildCoreShape(RawModelElement rawModelElement) {
        return this.buildShape(rawModelElement);
    }

    public UiModelElementShape buildShape(RawModelElement rawModelElement) {
        UiModelElementShape uiModelElementShape = null;
        Class clazz = this.m_Map.get(rawModelElement.getClass());
        if (clazz != null) {
            try {
                uiModelElementShape = (UiModelElementShape)clazz.newInstance();
                uiModelElementShape.setModel(rawModelElement);
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't instantiate shape for : " + rawModelElement.getClass().getName()), (Throwable)exception);
            }
        } else if (rawModelElement instanceof RawElement) {
            uiModelElementShape = new UiElementShape();
            uiModelElementShape.setModel(rawModelElement);
        }
        if (uiModelElementShape != null && rawModelElement instanceof IRawElementHolder) {
            Iterator iterator = ((IRawElementHolder)rawModelElement).getRawElementIterator();
            while (iterator.hasNext()) {
                this.buildShape((RawModelElement)iterator.next());
            }
        }
        return uiModelElementShape;
    }

    private void initMap() {
        this.m_Map = new HashMap<Class, Class>();
        this.m_Map.put(ShapeGroup.class, GroupShape.class);
        this.m_Map.put(Table.class, TableShape.class);
        this.m_Map.put(TableHeader.class, TableSectionShape.class);
        this.m_Map.put(TableBody.class, TableSectionShape.class);
        this.m_Map.put(TableFooter.class, TableSectionShape.class);
        this.m_Map.put(HBox.class, HBoxShape.class);
        this.m_Map.put(VBox.class, VBoxShape.class);
        this.m_Map.put(Cell.class, CellShape.class);
        this.m_Map.put(PageBreak.class, PageBreakShape.class);
        this.m_Map.put(Line.class, LineShape.class);
        this.m_Map.put(CubeTable.class, CubeTableShape.class);
        this.m_Map.put(CubeRow.class, CubeHeaderShape.class);
        this.m_Map.put(CubeColumn.class, CubeHeaderShape.class);
        this.m_Map.put(CubeMeasure.class, CubeMeasureShape.class);
    }

    static {
        m_Log = ElxLoggerJ.getLogger(UiFactory.class);
    }
}

