/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.component;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IApplication;
import com.elixirtech.erd.reportdesigner.UiRenderer;
import com.elixirtech.erd.reportdesigner.component.ComponentDefinition;
import com.elixirtech.erd.reportdesigner.renderer.CallbackRenderer;
import com.elixirtech.erd.reportdesigner.renderer.EmptyUiElementRenderer;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.raw.model.CallbackElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.ui.ITabComponent;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.callback.CallbackWizard;
import com.elixirtech.wizard.callback.WizardRegistry;
import java.util.List;
import javax.swing.Icon;

public class CallbackDefinition
implements ComponentDefinition {
    private Icon ICON = ERDIcons.CALLBACK;
    private UiRenderer m_Renderer = CallbackDefinition.isRemote() ? new EmptyUiElementRenderer(this.ICON, "Callback") : new CallbackRenderer();

    @Override
    public String getName() {
        return "callback";
    }

    @Override
    public Icon getIcon(RawModelElement rawModelElement) {
        return this.ICON;
    }

    @Override
    public IWizard getWizard(RawModelElement rawModelElement, boolean bl) {
        return new CallbackWizard((CallbackElement)rawModelElement, bl);
    }

    @Override
    public boolean hasProperties() {
        return true;
    }

    @Override
    public boolean hasEditableWizard() {
        return false;
    }

    @Override
    public void addTabs(RawModelElement rawModelElement, List<ITabComponent> list) {
        CallbackElement callbackElement = (CallbackElement)rawModelElement;
        WizardRegistry.CallbackType callbackType = WizardRegistry.getType(callbackElement.getType());
        if (callbackType != null) {
            callbackType.buildTabs(callbackElement, list);
        }
    }

    @Override
    public UiRenderer getRenderer() {
        return this.m_Renderer;
    }

    private static boolean isRemote() {
        return "Repertoire-Remote".equals(((IApplication)Elixir.get(IApplication.class)).getId());
    }
}

