/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.component;

import com.elixirtech.erd.reportdesigner.UiRenderer;
import com.elixirtech.erd.reportdesigner.component.BarcodeDefinition;
import com.elixirtech.erd.reportdesigner.component.CallbackDefinition;
import com.elixirtech.erd.reportdesigner.component.ChartDefinition;
import com.elixirtech.erd.reportdesigner.component.CheckBoxDefinition;
import com.elixirtech.erd.reportdesigner.component.ComponentDefinition;
import com.elixirtech.erd.reportdesigner.component.CompositeChartDefinition;
import com.elixirtech.erd.reportdesigner.component.CubeHeaderDefinition;
import com.elixirtech.erd.reportdesigner.component.CubeMeasureDefinition;
import com.elixirtech.erd.reportdesigner.component.CubeTableDefinition;
import com.elixirtech.erd.reportdesigner.component.DetailDefinition;
import com.elixirtech.erd.reportdesigner.component.FieldDefinition;
import com.elixirtech.erd.reportdesigner.component.GridDefinition;
import com.elixirtech.erd.reportdesigner.component.GroupFooterDefinition;
import com.elixirtech.erd.reportdesigner.component.GroupHeaderDefinition;
import com.elixirtech.erd.reportdesigner.component.ImageDefinition;
import com.elixirtech.erd.reportdesigner.component.LineDefinition;
import com.elixirtech.erd.reportdesigner.component.MapDefinition;
import com.elixirtech.erd.reportdesigner.component.PageBreakDefinition;
import com.elixirtech.erd.reportdesigner.component.RTFDefinition;
import com.elixirtech.erd.reportdesigner.component.RectangleDefinition;
import com.elixirtech.erd.reportdesigner.component.SVGDefinition;
import com.elixirtech.erd.reportdesigner.component.SectionFooterDefinition;
import com.elixirtech.erd.reportdesigner.component.SectionHeaderDefinition;
import com.elixirtech.erd.reportdesigner.component.SubReportDefinition;
import com.elixirtech.erd.reportdesigner.component.TableDefinition;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.ui.ITabComponent;
import com.elixirtech.ui.wizard.IWizard;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class ComponentRegistry {
    private static Map<String, ComponentDefinition> m_Definitions = new HashMap<String, ComponentDefinition>();

    public static IWizard getWizard(RawModelElement rawModelElement, boolean bl) {
        String string = rawModelElement.getTagName();
        ComponentDefinition componentDefinition = m_Definitions.get(string);
        if (componentDefinition != null) {
            return componentDefinition.getWizard(rawModelElement, bl);
        }
        return null;
    }

    public static boolean hasProperties(RawModelElement rawModelElement) {
        String string = rawModelElement.getTagName();
        ComponentDefinition componentDefinition = m_Definitions.get(string);
        if (componentDefinition != null) {
            return componentDefinition.hasProperties();
        }
        return false;
    }

    public static boolean hasEditableWizard(RawModelElement rawModelElement) {
        String string = rawModelElement.getTagName();
        ComponentDefinition componentDefinition = m_Definitions.get(string);
        if (componentDefinition != null) {
            return componentDefinition.hasEditableWizard();
        }
        return false;
    }

    public static void addTabs(RawModelElement rawModelElement, List<ITabComponent> list) {
        String string = rawModelElement.getTagName();
        ComponentDefinition componentDefinition = m_Definitions.get(string);
        if (componentDefinition != null) {
            componentDefinition.addTabs(rawModelElement, list);
        }
    }

    public static Icon getIcon(RawModelElement rawModelElement) {
        ComponentDefinition componentDefinition = m_Definitions.get(rawModelElement.getTagName());
        if (componentDefinition != null) {
            return componentDefinition.getIcon(rawModelElement);
        }
        return null;
    }

    public static UiRenderer getRenderer(RawModelElement rawModelElement) {
        String string = rawModelElement.getTagName();
        ComponentDefinition componentDefinition = m_Definitions.get(string);
        if (componentDefinition != null) {
            return componentDefinition.getRenderer();
        }
        return null;
    }

    public static void register(ComponentDefinition componentDefinition) {
        ComponentRegistry.register(componentDefinition.getName(), componentDefinition);
    }

    public static void register(String string, ComponentDefinition componentDefinition) {
        m_Definitions.put(string, componentDefinition);
    }

    static {
        ComponentRegistry.register(new BarcodeDefinition());
        ComponentRegistry.register(new CallbackDefinition());
        ComponentRegistry.register(new ChartDefinition());
        ComponentRegistry.register(new CheckBoxDefinition());
        ComponentRegistry.register(new CubeTableDefinition());
        ComponentRegistry.register(new CubeMeasureDefinition());
        ComponentRegistry.register(new CubeHeaderDefinition.Row());
        ComponentRegistry.register(new CubeHeaderDefinition.Column());
        ComponentRegistry.register(new FieldDefinition());
        ComponentRegistry.register(new GridDefinition());
        ComponentRegistry.register(new ImageDefinition());
        ComponentRegistry.register(new LineDefinition());
        ComponentRegistry.register(new MapDefinition());
        ComponentRegistry.register(new CompositeChartDefinition());
        ComponentRegistry.register(new PageBreakDefinition());
        ComponentRegistry.register(new RectangleDefinition());
        ComponentRegistry.register(new RTFDefinition());
        ComponentRegistry.register(new SubReportDefinition());
        ComponentRegistry.register(new SVGDefinition());
        ComponentRegistry.register(new TableDefinition());
        ComponentRegistry.register(new DetailDefinition());
        ComponentRegistry.register(new GroupHeaderDefinition());
        ComponentRegistry.register(new GroupFooterDefinition());
        ComponentRegistry.register(new SectionHeaderDefinition());
        ComponentRegistry.register(new SectionFooterDefinition());
    }
}

