/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.component;

import com.elixirtech.data2.DataSchema;
import com.elixirtech.erd.reportdesigner.UiRenderer;
import com.elixirtech.erd.reportdesigner.component.ComponentDefinition;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.raw.model.GroupHeader;
import com.elixirtech.report2.raw.model.IFormatHolder;
import com.elixirtech.report2.raw.model.IRenderScriptHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.TOCElementHolder;
import com.elixirtech.ui.ITabComponent;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.tab.ScriptTab;
import com.elixirtech.wizard.tab.SortTab;
import com.elixirtech.wizard.text.FormatTab;
import com.elixirtech.wizard.text.TOCTab;
import java.util.List;
import javax.swing.Icon;

public class GroupHeaderDefinition
implements ComponentDefinition {
    private Icon ICON = ERDIcons.CHUNK;

    @Override
    public String getName() {
        return "group-header";
    }

    @Override
    public Icon getIcon(RawModelElement rawModelElement) {
        return this.ICON;
    }

    @Override
    public IWizard getWizard(RawModelElement rawModelElement, boolean bl) {
        return null;
    }

    @Override
    public boolean hasProperties() {
        return true;
    }

    @Override
    public boolean hasEditableWizard() {
        return false;
    }

    @Override
    public void addTabs(RawModelElement rawModelElement, List<ITabComponent> list) {
        GroupHeader groupHeader = (GroupHeader)rawModelElement;
        DataSchema dataSchema = groupHeader.getSection().getSchema();
        list.add(new TOCTab((TOCElementHolder)groupHeader));
        list.add(new FormatTab((IFormatHolder)groupHeader));
        if (dataSchema != null && dataSchema.getColumnCount() > 0) {
            list.add(new SortTab(dataSchema, groupHeader.getGroup()));
        }
        list.add(new ScriptTab((IRenderScriptHolder)groupHeader));
    }

    @Override
    public UiRenderer getRenderer() {
        return null;
    }
}

