/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.repository.RepositoryTree;
import com.elixirtech.arch.repository.filter.TypeFilter;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.erd.reportdesigner.data.FilterPage;
import com.elixirtech.erd.reportdesigner.data.ParameterModel;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.Filter;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.util.StringUtil;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;

public class AddDataSourceWizard
extends Wizard {
    private DataSource m_OriginalDataSource;
    RawReport m_Report;
    DataSource m_DataSource;
    PageOne m_PageOne;
    FilterPage m_FilterPage;
    PageThree m_PageThree;
    boolean m_ShowFilterPage;

    public AddDataSourceWizard(RawReport rawReport, DataSource dataSource) {
        super(I18N.ERD.getString("AddDataSourceWizard.title"));
        this.m_OriginalDataSource = dataSource;
        this.m_Report = rawReport;
        this.setReadOnly(this.m_Report.getSecurity().isReadOnly());
        this.m_DataSource = dataSource.deepCopy();
        this.m_PageOne = new PageOne();
        this.m_FilterPage = new FilterPage(this);
        this.m_PageThree = new PageThree();
        this.m_Pages.add(this.m_PageOne);
        this.m_Pages.add(this.m_FilterPage);
        this.m_Pages.add(this.m_PageThree);
    }

    @Override
    public void setContainer(IWizardContainer iWizardContainer) {
        this.m_Container = iWizardContainer;
    }

    public boolean isShowFilterPage() {
        return this.m_ShowFilterPage;
    }

    public void setShowFilterPage(boolean bl) {
        this.m_ShowFilterPage = bl;
    }

    public void showFilterPage() {
        if (this.m_ShowFilterPage) {
            this.m_Container.showPage(this.m_FilterPage);
        }
    }

    @Override
    public boolean canFinish() {
        if (this.isReadOnly()) {
            return false;
        }
        return this.m_PageOne.isPageComplete();
    }

    @Override
    public boolean performFinish() {
        super.performFinish();
        this.m_PageOne.performFinish();
        this.m_PageThree.performFinish();
        this.m_FilterPage.performFinish();
        this.m_OriginalDataSource.setName(this.m_DataSource.getName());
        this.m_OriginalDataSource.setDataSourceName(this.m_DataSource.getDataSourceName());
        this.m_OriginalDataSource.setTabulate(this.m_DataSource.isTabulate());
        this.m_OriginalDataSource.setFilterList(this.m_DataSource.getFilterList());
        this.m_OriginalDataSource.setParameterMap(this.m_DataSource.getParameterMap());
        if (!this.m_Report.getDataSourceList().contains(this.m_OriginalDataSource)) {
            this.m_Report.addDataSource(this.m_OriginalDataSource);
            this.checkForSectionWithNoDataSource();
        }
        this.m_Report.setDirty(true);
        return true;
    }

    @Override
    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        IWizardPage iWizardPage2 = iWizardPage.getNextPage();
        if (iWizardPage2 == this.m_FilterPage) {
            this.m_FilterPage.refreshField();
        }
        return iWizardPage.getNextPage();
    }

    private void checkForSectionWithNoDataSource() {
        Iterator iterator = this.m_Report.getSectionIterator();
        while (iterator.hasNext()) {
            Section section = (Section)iterator.next();
            if (!StringUtil.isEmpty(section.getDataSource())) continue;
            int n = JOptionPane.showConfirmDialog(this.m_PageOne.getComponent(), I18N.ERD.getString("AddDataSourceWizard.assign-ds") + " \"" + section.getName() + "\"?", I18N.ERD.getString("AddDataSourceWizard.assign-ds.title"), 0);
            if (n != 0) break;
            section.setDataSource(this.m_DataSource.getName());
            break;
        }
    }

    private class PageOne
    extends RelativeLayoutWizardPage
    implements TreeSelectionListener {
        private boolean m_FlippedToFilter;
        private JTextField m_Name;
        private JTextField m_DSName;
        private RepositoryTree m_Tree;
        private JCheckBox m_Tabulate;

        public PageOne() {
            super("ConfigureDataSource", "Filter");
            this.setWizard(AddDataSourceWizard.this);
            boolean bl = AddDataSourceWizard.this.m_Report.getDataSourceList().contains(AddDataSourceWizard.this.m_DataSource);
            if (bl) {
                this.setTitle(I18N.ERD.getString("AddDataSourceWizard.edit.title"));
            } else {
                this.setTitle(I18N.ERD.getString("AddDataSourceWizard.add.title"));
            }
        }

        @Override
        public void setWizard(IWizard iWizard) {
            super.setWizard(iWizard);
            FieldWatcher fieldWatcher = new FieldWatcher(this.m_Wizard);
            this.m_Name = SwingFactory.newTextField("name");
            this.m_Name.setText(AddDataSourceWizard.this.m_DataSource.getName());
            this.m_Name.getDocument().addDocumentListener(fieldWatcher);
            this.m_DSName = SwingFactory.newTextField("ds");
            this.m_DSName.setText(AddDataSourceWizard.this.m_DataSource.getDataSourceName());
            this.m_DSName.getDocument().addDocumentListener(fieldWatcher);
            Repository repository = (Repository)Elixir.get(Repository.class);
            this.m_Tree = RepositoryTree.apply(I18N.ERD.getString("AddDataSourceWizard.repository-title"), repository, new TypeFilter("ds"));
            this.m_Tabulate = SwingFactory.newCheckBox("test");
            this.m_Tabulate.setSelected(AddDataSourceWizard.this.m_DataSource.isTabulate());
            this.m_Component.add(SwingFactory.newLabel("name-label"));
            this.m_Component.add("name", this.m_Name);
            this.m_Component.add(SwingFactory.newLabel("ds-label"));
            this.m_Component.add("ds", this.m_DSName);
            this.m_Component.add(SwingFactory.newScrollPane("tree", this.m_Tree));
            this.m_Component.add(this.m_Tabulate);
            this.stickTop("name");
            this.stickLeft("name-label");
            this.vCenter("name-label", "name");
            this.putRight("name", "name-label,ds-label", 10);
            this.alignBelow("ds", "name");
            this.setHeight("ds", "name");
            this.stickRight("ds");
            this.stickLeft("ds-label");
            this.vCenter("ds-label", "ds");
            this.putLeft("name", "test");
            this.stickRight("test");
            this.stickTop("test");
            this.setHeight("test", "name");
            this.putBelow("tree", "ds", 5);
            this.stickLeft("tree");
            this.stickRight("tree");
            this.stickBottom("tree");
            String string = AddDataSourceWizard.this.m_DataSource.getDataSourceName();
            if (StringUtil.notEmpty(string)) {
                string = this.stripAnyRepositoryPrefix(string);
                FileObject fileObject = repository.getFileJ(string);
                this.m_Tree.setSelectionJ(fileObject);
            }
            this.m_Tree.addTreeSelectionListener(this);
            I18N.ERD_MAP.injectComponents("AddDataSourceWizard.", this.m_Component);
            I18N.ERD_MAP.injectObject(null, this, "AddDataSourceWizard");
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            FileObject fileObject = this.m_Tree.getSelectionJ();
            this.m_DSName.setText(fileObject != null ? fileObject.getPath().toString() : "");
            this.m_Wizard.getContainer().updateButtons();
        }

        @Override
        public boolean canFlipToNextPage() {
            return this.isPageComplete();
        }

        @Override
        public boolean isPageComplete() {
            Object object;
            this.setError(null);
            boolean bl = true;
            this.m_DSName.setForeground(Color.BLACK);
            String string = this.m_Name.getText();
            string = string.trim();
            if (string.length() == 0) {
                this.setError(I18N.ERD.getString("Wizard.name-required"));
                bl = false;
            } else {
                object = AddDataSourceWizard.this.m_Report.getDataSource(string);
                if (object != null && object != AddDataSourceWizard.this.m_OriginalDataSource) {
                    this.setError(I18N.ERD.getString("Wizard.name-mustbeunique"));
                    bl = false;
                }
            }
            if (bl) {
                object = this.m_DSName.getText();
                if (StringUtil.isEmpty((String)(object = this.stripAnyRepositoryPrefix((String)object)))) {
                    this.setError(I18N.ERD.getString("Wizard.ds-required"));
                    bl = false;
                } else {
                    Repository repository = (Repository)Elixir.get(Repository.class);
                    FileObject fileObject = repository.getFileJ((String)object);
                    if (fileObject == null) {
                        this.m_DSName.setForeground(Color.RED);
                        this.setError(I18N.ERD.getString("Wizard.ds-notfound"));
                        bl = false;
                    }
                }
            }
            this.m_Wizard.getContainer().updateMessage();
            if (bl) {
                this.performFinish();
            }
            return bl;
        }

        private void performFinish() {
            AddDataSourceWizard.this.m_DataSource.setName(this.m_Name.getText());
            AddDataSourceWizard.this.m_DataSource.setDataSourceName(this.stripAnyRepositoryPrefix(this.m_DSName.getText()));
            AddDataSourceWizard.this.m_DataSource.setTabulate(this.m_Tabulate.isSelected());
        }

        @Override
        public void dispose() {
            if (this.m_Tree != null) {
                this.m_Tree.dispose();
            }
            super.dispose();
        }

        protected String getDataSourceName() {
            return this.m_DSName.getText();
        }

        private String stripAnyRepositoryPrefix(String string) {
            if (string != null && string.startsWith("repository:")) {
                string = string.substring(11);
            }
            return string;
        }
    }

    private class PageThree
    extends RelativeLayoutWizardPage {
        private ParameterModel m_Model;
        private JCheckBox m_PropagateParameters;
        private JTable m_Table;
        private boolean m_Initialized;

        public PageThree() {
            super("DataSourceProperties", null);
            this.setWizard(AddDataSourceWizard.this);
            boolean bl = AddDataSourceWizard.this.m_Report.getDataSourceList().contains(AddDataSourceWizard.this.m_DataSource);
            if (bl) {
                this.setTitle(I18N.ERD.getString("AddDataSourceWizard.edit.title"));
            } else {
                this.setTitle(I18N.ERD.getString("AddDataSourceWizard.add.title"));
            }
        }

        @Override
        public void setWizard(IWizard iWizard) {
            super.setWizard(iWizard);
            this.m_Model = new ParameterModel(null, new Properties());
            this.m_Table = SwingFactory.newTable();
            this.m_Table.setModel(this.m_Model);
            this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_Component.setLayout(new BorderLayout());
            this.m_PropagateParameters = SwingFactory.newCheckBox("propagate-parameter");
            JPanel jPanel = new JPanel(new FlowLayout(1));
            jPanel.add(this.m_PropagateParameters);
            this.m_Component.add((Component)SwingFactory.newScrollPane("table", this.m_Table), "Center");
            this.m_Component.add((Component)jPanel, "South");
            I18N.ERD_MAP.injectComponents("AddDataSourceWizard.", this.m_Component);
            I18N.ERD_MAP.injectObject(null, this, "AddDataSourceWizard");
        }

        @Override
        public void setVisible(boolean bl) {
            if (bl) {
                Object object;
                DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
                IDataSource iDataSource = null;
                String string = AddDataSourceWizard.this.m_PageOne.getDataSourceName();
                if (StringUtil.notEmpty(string)) {
                    try {
                        iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                Properties properties = new Properties();
                Iterator iterator = AddDataSourceWizard.this.m_DataSource.getParameterIterator();
                while (iterator.hasNext()) {
                    object = (com.elixirtech.report2.raw.model.Parameter)iterator.next();
                    properties.put(object.getKey(), object.getValue());
                }
                this.m_Model = new ParameterModel(iDataSource, properties);
                object = AddDataSourceWizard.this.m_DataSource.getFilterList();
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    Filter filter = (Filter)iterator2.next();
                    String string2 = filter.getValue();
                    List list = ArgumentMap.extractListofParameters((String)string2);
                    ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
                    for (Parameter parameter : list) {
                        String string3 = parameter.getName();
                        String string4 = properties.getProperty(string3);
                        if (StringUtil.isEmpty(string4)) continue;
                        arrayList.add(parameter);
                        this.m_Model.addPair(string3, string4);
                    }
                    list.removeAll(arrayList);
                    this.m_Model.addParameter(list.toArray(new Parameter[list.size()]));
                }
                this.m_Table.setModel(this.m_Model);
                this.m_PropagateParameters.setEnabled(this.canPropagateParameters());
                this.m_Initialized = true;
            } else {
                this.disposeEditor();
            }
        }

        @Override
        public boolean isPageComplete() {
            return true;
        }

        public void performFinish() {
            if (this.m_Initialized) {
                this.disposeEditor();
                if (this.m_PropagateParameters.isSelected()) {
                    this.propagateParameters();
                }
                this.m_Model.performFinish();
                Map map = AddDataSourceWizard.this.m_DataSource.getParameterMap();
                map.clear();
                Properties properties = this.m_Model.getProperties();
                for (String string : properties.keySet()) {
                    com.elixirtech.report2.raw.model.Parameter parameter = new com.elixirtech.report2.raw.model.Parameter();
                    parameter.setKey(string);
                    parameter.setValue(properties.getProperty(string));
                    map.put(string, parameter);
                }
            }
        }

        private void disposeEditor() {
            TableCellEditor tableCellEditor = this.m_Table.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
                this.m_Table.removeEditor();
            }
        }

        private void propagateParameters() {
            ArgumentMap argumentMap = new ArgumentMap();
            int n = this.m_Model.getRowCount();
            for (int i = 0; i < n; ++i) {
                String string = (String)this.m_Model.getValueAt(i, 0);
                Object object = (String)this.m_Model.getValueAt(i, 1);
                if (StringUtil.isEmpty((String)object)) {
                    this.m_Model.setDefaultAt(i);
                    if (argumentMap.contains(string)) continue;
                    argumentMap.addParameter(this.m_Model.getParameter(i));
                    continue;
                }
                argumentMap.extractParameters((String)object);
            }
            List list = argumentMap.getParameters();
            for (Object object : list) {
                String string = object.getName();
                com.elixirtech.report2.raw.model.Parameter parameter = AddDataSourceWizard.this.m_Report.getParameter(string);
                if (parameter != null) continue;
                parameter = new com.elixirtech.report2.raw.model.Parameter();
                parameter.setKey(string);
                parameter.setValue(object.getDollarSubstitution());
                parameter.setEnabled(Boolean.TRUE);
                AddDataSourceWizard.this.m_Report.addParameter(parameter);
            }
            this.m_Model.fireTableDataChanged();
        }

        private boolean canPropagateParameters() {
            int n = this.m_Model.getRowCount();
            boolean bl = false;
            ArgumentMap argumentMap = new ArgumentMap();
            for (int i = 0; i < n; ++i) {
                String string = (String)this.m_Model.getValueAt(i, 0);
                Object object = (String)this.m_Model.getValueAt(i, 1);
                if (StringUtil.isEmpty((String)object)) {
                    if (argumentMap.contains(string)) continue;
                    argumentMap.addParameter(new Parameter(string, "", ""));
                    continue;
                }
                boolean bl2 = argumentMap.extractParameters((String)object);
                if (bl2) continue;
                argumentMap.addParameter(this.m_Model.getParameter(i));
            }
            List list = argumentMap.getParameters();
            for (Object object : list) {
                com.elixirtech.report2.raw.model.Parameter parameter = AddDataSourceWizard.this.m_Report.getParameter(object.getName());
                bl |= parameter == null;
            }
            return bl;
        }
    }
}

