/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.erd.reportdesigner.data.DataTree;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

class DTL
implements DropTargetListener {
    private final DataTree m_Panel;
    private final Repository m_Repository = (Repository)Elixir.get(Repository.class);

    public DTL(DataTree dataTree) {
        this.m_Panel = dataTree;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        System.out.println("dragEnter " + this.isEditable());
        if (this.isEditable() && this.isDSFile(dropTargetDragEvent.getTransferable())) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.isEditable() && this.isDSFile(dropTargetDragEvent.getTransferable())) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (this.isEditable()) {
            try {
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                Path path = (Path)transferable.getTransferData(RepositoryExplorer.FILE_FLAVOR());
                Repository repository = (Repository)Elixir.get(Repository.class);
                FileObject fileObject = repository.getFileJ(path.toString());
                if (fileObject != null && fileObject.isData()) {
                    this.m_Panel.drop(fileObject, dropTargetDropEvent.getLocation());
                    dropTargetDropEvent.dropComplete(true);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        dropTargetDropEvent.rejectDrop();
        dropTargetDropEvent.dropComplete(false);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    private boolean isDSFile(Transferable transferable) {
        try {
            Path path = (Path)transferable.getTransferData(RepositoryExplorer.FILE_FLAVOR());
            if (!path.name().endsWith(".ds")) {
                return false;
            }
            FileObject fileObject = this.m_Repository.getFileJ(path.toString());
            return fileObject != null && fileObject.isData();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isEditable() {
        return this.m_Panel.isEditable();
    }
}

