/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.erd.reportdesigner.ReportTab;
import com.elixirtech.erd.reportdesigner.data.AddDataSourceWizard;
import com.elixirtech.erd.reportdesigner.data.DTL;
import com.elixirtech.erd.reportdesigner.data.DataField;
import com.elixirtech.erd.reportdesigner.data.DataFieldSet;
import com.elixirtech.erd.reportdesigner.data.InspectFieldAction;
import com.elixirtech.erd.reportdesigner.report.ReportTreeActions;
import com.elixirtech.erd.reportdesigner.report.ReportTreeModel;
import com.elixirtech.erd.util.ReportUtil;
import com.elixirtech.icons.FileIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.sax.ChangeListener;
import com.elixirtech.sax.ChangeNotifier;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.tree.TreeModelEx;
import com.elixirtech.ui.tree.TreeSupport;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.v2.repository.FileObject;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class DataTree
implements ChangeListener {
    final JPanel m_Panel;
    final RawReport m_Report;
    final JTree m_Tree;
    final DataTreeModel m_Model;
    Wrapper[] m_Wrappers = new Wrapper[0];
    DragSource m_DragSource;
    DGL m_DGL = new DGL();
    DSL m_DSL = new DSL();
    DTL m_DTL;
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DataTree.class);

    public DataTree(RawReport rawReport) {
        this.m_Panel = new JPanel(new BorderLayout());
        this.m_Report = rawReport;
        this.m_Model = new DataTreeModel();
        this.m_Tree = new JTree(this.m_Model);
        this.m_Tree.setMinimumSize(new Dimension(50, 50));
        this.m_Tree.setRootVisible(false);
        if (this.m_Tree.getRowCount() > 0) {
            this.m_Tree.expandRow(0);
        }
        new TreeSupport(this.m_Tree, false);
        this.m_Panel.add(new JScrollPane(this.m_Tree));
        this.m_Report.addChangeListener((ChangeListener)this);
        this.m_DragSource = new DragSource();
        this.m_DragSource.createDefaultDragGestureRecognizer(this.m_Tree, 3, this.m_DGL);
        this.m_DTL = new DTL(this);
        SwingUtil.setupDropTarget(this.m_Tree, this.m_DTL);
    }

    public JComponent getComponent() {
        return this.m_Panel;
    }

    public void beanChanged(ChangeNotifier changeNotifier, String string) {
        if ("RawReport.DataSource".equals(string)) {
            this.refresh();
        }
    }

    public void refresh() {
        this.m_Model.refresh();
    }

    public boolean isEditable() {
        return !this.m_Report.getSecurity().isReadOnly();
    }

    public void drop(FileObject fileObject, Point point) {
        Wrapper wrapper;
        DataSource dataSource = new DataSource();
        dataSource.setName(ReportUtil.getNextDataSourceName(this.m_Report));
        dataSource.setDataSourceName(fileObject.getPath().toString());
        AddDataSourceWizard addDataSourceWizard = new AddDataSourceWizard(this.m_Report, dataSource);
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.showWizard(addDataSourceWizard);
        if (addDataSourceWizard.isFinished() && (wrapper = this.getWrapper(dataSource)) != null) {
            this.m_Tree.expandPath(this.getPath(wrapper));
        }
    }

    private Wrapper getWrapper(DataSource dataSource) {
        for (int i = 0; i < this.m_Wrappers.length; ++i) {
            if (dataSource != this.m_Wrappers[i].getDataSource()) continue;
            return this.m_Wrappers[i];
        }
        return null;
    }

    private TreePath getPath(Wrapper wrapper) {
        return new TreePath(new Object[]{this.m_Report, wrapper});
    }

    private class Wrapper {
        private final DataSource m_DataSource;
        private DataField[] m_Fields;

        public Wrapper(DataSource dataSource) {
            this.m_DataSource = dataSource;
            this.refresh();
        }

        public DataSource getDataSource() {
            return this.m_DataSource;
        }

        public void refresh() {
            String string = this.m_DataSource.getDataSourceName();
            DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
            try {
                IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
                DataSchema dataSchema = iDataSource.getSchema();
                if (dataSchema != null) {
                    this.m_Fields = new DataField[dataSchema.getColumnCount()];
                    for (int i = 0; i < this.m_Fields.length; ++i) {
                        this.m_Fields[i] = new DataField(this.m_DataSource, dataSchema.getColumnName(i), dataSchema.getColumnType(i));
                    }
                } else {
                    this.m_Fields = new DataField[0];
                }
            }
            catch (Throwable throwable) {
                m_Log.error((Object)("Can't load fields for " + string));
                this.m_Fields = new DataField[0];
            }
        }

        public String toString() {
            return this.m_DataSource.getName();
        }

        public int getChildCount() {
            return this.m_Fields.length;
        }

        public Object getChild(int n) {
            return this.m_Fields[n];
        }

        public int getIndexOfChild(Object object) {
            for (int i = 0; i < this.m_Fields.length; ++i) {
                if (this.m_Fields[i] != object) continue;
                return i;
            }
            return -1;
        }
    }

    private class DGL
    implements DragGestureListener {
        private DGL() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            TreePath[] treePathArray = DataTree.this.m_Tree.getSelectionPaths();
            if (treePathArray.length == 1) {
                Object object;
                TreePath treePath = treePathArray[0];
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof Transferable) {
                    DataTree.this.m_DragSource.startDrag(dragGestureEvent, null, (Transferable)object, DataTree.this.m_DSL);
                }
            } else {
                Object object;
                ArrayList<DataField> arrayList = new ArrayList<DataField>();
                for (int i = 0; i < treePathArray.length; ++i) {
                    if (treePathArray[i] == null || !((object = treePathArray[i].getLastPathComponent()) instanceof DataField)) continue;
                    arrayList.add((DataField)object);
                }
                DataField[] dataFieldArray = new DataField[arrayList.size()];
                arrayList.toArray(dataFieldArray);
                object = new DataFieldSet(dataFieldArray);
                DataTree.this.m_DragSource.startDrag(dragGestureEvent, null, (Transferable)object, DataTree.this.m_DSL);
            }
        }
    }

    private class DSL
    implements DragSourceListener {
        private DSL() {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            this.updateCursor(dragSourceDragEvent);
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            this.updateCursor(dragSourceDragEvent);
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            this.updateCursor(dragSourceDragEvent);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
            DragSourceContext dragSourceContext = dragSourceEvent.getDragSourceContext();
            dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
        }

        protected void updateCursor(DragSourceDragEvent dragSourceDragEvent) {
            DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
            int n = dragSourceDragEvent.getDropAction();
            if ((n & 1) != 0) {
                dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
            } else if ((n & 2) != 0) {
                dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
            } else {
                dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }
    }

    public class DataTreeModel
    implements TreeModelEx {
        private List<TreeModelListener> m_Listeners = new ArrayList<TreeModelListener>();

        public DataTreeModel() {
            this.refresh();
        }

        public void refresh() {
            int n;
            HashSet<DataSource> hashSet = new HashSet<DataSource>();
            if (DataTree.this.m_Tree != null && DataTree.this.m_Tree.getRowCount() > 0) {
                for (n = 0; n < DataTree.this.m_Wrappers.length; ++n) {
                    if (!DataTree.this.m_Tree.isExpanded(DataTree.this.getPath(DataTree.this.m_Wrappers[n]))) continue;
                    hashSet.add(DataTree.this.m_Wrappers[n].getDataSource());
                }
            }
            DataTree.this.m_Wrappers = new Wrapper[DataTree.this.m_Report.getDataSourceCount()];
            for (n = 0; n < DataTree.this.m_Wrappers.length; ++n) {
                DataTree.this.m_Wrappers[n] = new Wrapper(DataTree.this.m_Report.getDataSource(n));
            }
            this.fireTreeChanged();
            if (DataTree.this.m_Tree != null && DataTree.this.m_Tree.getRowCount() > 0) {
                for (DataSource dataSource : hashSet) {
                    Wrapper wrapper = DataTree.this.getWrapper(dataSource);
                    if (wrapper == null) continue;
                    DataTree.this.m_Tree.expandPath(DataTree.this.getPath(wrapper));
                }
            }
        }

        @Override
        public Object getRoot() {
            return DataTree.this.m_Report;
        }

        @Override
        public int getChildCount(Object object) {
            if (object == DataTree.this.m_Report) {
                return DataTree.this.m_Wrappers.length;
            }
            if (object instanceof Wrapper) {
                return ((Wrapper)object).getChildCount();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object object) {
            if (object == DataTree.this.m_Report) {
                return DataTree.this.m_Wrappers.length == 0;
            }
            if (object instanceof Wrapper) {
                return ((Wrapper)object).getChildCount() == 0;
            }
            return true;
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.m_Listeners.add(treeModelListener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.m_Listeners.remove(treeModelListener);
        }

        @Override
        public Object getChild(Object object, int n) {
            if (object == DataTree.this.m_Report) {
                return DataTree.this.m_Wrappers[n];
            }
            if (object instanceof Wrapper) {
                return ((Wrapper)object).getChild(n);
            }
            return null;
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            if (object == DataTree.this.m_Report) {
                for (int i = 0; i < DataTree.this.m_Wrappers.length; ++i) {
                    if (DataTree.this.m_Wrappers[i] != object2) continue;
                    return i;
                }
                return -1;
            }
            if (object instanceof Wrapper) {
                return ((Wrapper)object).getIndexOfChild(object2);
            }
            return 0;
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        protected void fireTreeChanged() {
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new TreePath(DataTree.this.m_Report));
            for (TreeModelListener treeModelListener : this.m_Listeners) {
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        }

        @Override
        public Icon getIcon(Object object) {
            if (object instanceof Wrapper) {
                return FileIcons.DATASOURCE_FILE;
            }
            return FileIcons.DATA_FILE;
        }

        @Override
        public String getLabel(Object object) {
            return object.toString();
        }

        @Override
        public void setLabel(Object object, String string) {
        }

        @Override
        public JPopupMenu getPopupMenu(Object object) {
            if (object instanceof Wrapper) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
                ReportTab reportTab = (ReportTab)iViewModel.getCurrentView();
                ReportTreeModel reportTreeModel = reportTab.getReportPanel().getReportTreeModel();
                DataSource dataSource = ((Wrapper)object).getDataSource();
                jPopupMenu.add(new JMenuItem(new ReportTreeActions.EditDataSource(reportTreeModel, dataSource)));
                JMenuItem jMenuItem = new JMenuItem(I18N.ERD.getString("UI.refresh"));
                jMenuItem.addActionListener(new CodeBlock((Object)this, "refresh"));
                jPopupMenu.add(jMenuItem);
                jPopupMenu.add(new JMenuItem(new ReportTreeActions.Delete(reportTreeModel, dataSource)));
                jPopupMenu.addSeparator();
                jPopupMenu.add(new JMenuItem(new ReportTreeActions.OpenDataSource(reportTreeModel, dataSource)));
                return jPopupMenu;
            }
            if (object instanceof DataField) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new JMenuItem(new InspectFieldAction((DataField)object)));
                return jPopupMenu;
            }
            return null;
        }

        @Override
        public void doDoubleClick(Object object) {
            if (object instanceof DataField) {
                InspectFieldAction inspectFieldAction = new InspectFieldAction((DataField)object);
                inspectFieldAction.actionPerformed(null);
            }
        }
    }
}

