/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.data;

import com.elixirtech.data2.datasource.filter.When;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.Filter;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.util.BooleanUtil;
import java.util.ArrayList;
import java.util.List;

public class FilterModel
extends ElxTableModel {
    private static String[] COLUMNS = new String[]{"FilterModel.Field", "FilterModel.When", "FilterModel.Value", "FilterModel.Enabled"};
    private List<Filter> m_ListOfFilters;

    public FilterModel(DataSource dataSource) {
        super(I18N.ERD, COLUMNS);
        List list = dataSource.getFilterList();
        this.m_ListOfFilters = new ArrayList<Filter>(list.size());
        for (Filter filter : list) {
            Filter filter2 = filter.deepCopy();
            this.m_ListOfFilters.add(filter2);
        }
    }

    @Override
    public int getRowCount() {
        return this.m_ListOfFilters.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Filter filter = this.m_ListOfFilters.get(n);
        if (n2 == 0) {
            return filter.getField();
        }
        if (n2 == 1) {
            return When.getInstance((String)filter.getWhen());
        }
        if (n2 == 2) {
            return filter.getValue();
        }
        if (n2 == 3) {
            return BooleanUtil.value(filter.isEnabled()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Filter filter = this.m_ListOfFilters.get(n);
        if (n2 == 0) {
            filter.setField((String)object);
        } else if (n2 == 1) {
            filter.setWhen(((When)object).getName());
        } else if (n2 == 2) {
            filter.setValue((String)object);
        } else if (n2 == 3) {
            filter.setEnabled((Boolean)object);
        }
    }

    public Class getColumnClass(int n) {
        if (n == 1) {
            return When.class;
        }
        if (n == 3) {
            return Boolean.class;
        }
        return String.class;
    }

    public void addFilter(Filter filter) {
        int n = this.m_ListOfFilters.size();
        this.m_ListOfFilters.add(filter);
        this.fireTableRowsInserted(n, n);
    }

    public void removeFilter(Filter filter) {
        this.m_ListOfFilters.remove(filter);
        int n = this.m_ListOfFilters.size();
        this.fireTableRowsDeleted(n, n);
    }

    public Filter getFilter(int n) {
        return this.m_ListOfFilters.get(n);
    }

    public void moveUp(int n) {
        Filter filter = this.m_ListOfFilters.remove(n);
        this.m_ListOfFilters.add(n - 1, filter);
        this.fireTableRowsUpdated(n - 1, n);
    }

    public void moveDown(int n) {
        Filter filter = this.m_ListOfFilters.remove(n);
        this.m_ListOfFilters.add(n + 1, filter);
        this.fireTableRowsUpdated(n, n + 1);
    }

    public List<Filter> getListOfFilters() {
        return this.m_ListOfFilters;
    }
}

