/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.filter.When;
import com.elixirtech.erd.reportdesigner.data.AddDataSourceWizard;
import com.elixirtech.erd.reportdesigner.data.FilterModel;
import com.elixirtech.erd.util.ClipboardUtil;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.Filter;
import com.elixirtech.report2.raw.model.Holder;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.ui.EditableTable;
import com.elixirtech.ui.OrderedEditableTable;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.table.BasicTableEditor;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.filter.DataSetChooser;
import com.elixirtech.wizard.filter.IDataSetProviderTab;
import com.elixirtech.wizard.filter.RepositoryFieldTab;
import com.elixirtech.wizard.filter.WhenRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FilterPage
extends RelativeLayoutWizardPage
implements ActionListener {
    private DataSource m_DataSource;
    private RawReport m_RawReport;
    private FilterModel m_Model;
    private OrderedEditableTable m_Table;
    private HashMap<String, Object[]> m_Data = new HashMap();

    public FilterPage(AddDataSourceWizard addDataSourceWizard) {
        super("Filter", "DataSourceProperties");
        this.setWizard(addDataSourceWizard);
        this.m_RawReport = addDataSourceWizard.m_Report;
        boolean bl = addDataSourceWizard.m_Report.getDataSourceList().contains(addDataSourceWizard.m_DataSource);
        if (bl) {
            this.setTitle(I18N.ERD.getString("AddDataSourceWizard.edit.title"));
        } else {
            this.setTitle(I18N.ERD.getString("AddDataSourceWizard.add.title"));
        }
        this.setMessage(I18N.ERD.getString("AddDataSourceWizard.FilterPage.message"));
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_DataSource = ((AddDataSourceWizard)iWizard).m_DataSource;
        this.m_Model = new FilterModel(this.m_DataSource);
        this.m_Table = new FilterOrderedEditableTable(this.m_Model, false, true);
        this.m_Table.setModel(this.m_Model);
        this.m_Table.setAutoResizeMode(4);
        this.m_Table.addActionListener(this);
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Component.setLayout(new BorderLayout());
        this.m_Component.add((Component)this.m_Table, "Center");
        JComboBox<When> jComboBox = new JComboBox<When>(When.getAll());
        jComboBox.setSelectedItem(When.NONE);
        jComboBox.setRenderer(new WhenRenderer());
        jComboBox.setFont(UIManager.getFont("Tree.font"));
        this.m_Table.setDefaultRenderer(When.class, new WhenTableRenderer());
        this.m_Table.setDefaultEditor(When.class, new DefaultCellEditor(jComboBox));
    }

    public void refreshField() {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        String string = this.m_DataSource.getDataSourceName();
        if (StringUtil.isEmpty(string)) {
            return;
        }
        IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
        DataSchema dataSchema = iDataSource.getSchema();
        int n = dataSchema.getColumnCount();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = dataSchema.getColumnName(i);
            stringArray2[i] = I18N.getDataTypeName(dataSchema.getColumnType(i));
        }
        TableColumn tableColumn = this.m_Table.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new ComboTableCellEditor("fields", stringArray, stringArray2));
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl) {
            this.m_Table.disposeEditor();
        }
    }

    public void performFinish() {
        this.m_DataSource.setFilterList(this.m_Model.getListOfFilters());
        this.m_Data.clear();
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("plus".equals(string)) {
            Filter filter = new Filter();
            filter.setEnabled(Boolean.TRUE);
            filter.setWhen(When.NONE.getName());
            this.m_Model.addFilter(filter);
            this.m_Table.select(this.m_Model.getRowCount() - 1);
            this.m_RawReport.setDirty(true);
        } else if ("minus".equals(string)) {
            int n;
            int[] nArray = this.m_Table.getSelectedRows();
            Filter[] filterArray = new Filter[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                filterArray[n] = this.m_Model.getFilter(nArray[n]);
            }
            for (n = 0; n < filterArray.length; ++n) {
                this.m_Model.removeFilter(filterArray[n]);
            }
            this.m_RawReport.setDirty(true);
        } else if ("copy".equals(string)) {
            int[] nArray = this.m_Table.getSelectedRows();
            Holder holder = new Holder();
            for (int i = 0; i < nArray.length; ++i) {
                holder.addContent((Object)this.m_Model.getFilter(i));
            }
            ClipboardUtil.setHolder(holder);
        } else if ("paste".equals(string)) {
            Holder holder = ClipboardUtil.getHolder();
            Iterator iterator = holder.getContentIterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Filter)) continue;
                this.m_Model.addFilter(((Filter)e).deepCopy());
                this.m_RawReport.setDirty(true);
            }
        } else if ("up".equals(string)) {
            int[] nArray = this.m_Table.getSelectedRows();
            this.m_Model.moveUp(nArray[0]);
            this.m_Table.select(nArray[0] - 1);
            this.m_RawReport.setDirty(true);
        } else if ("down".equals(string)) {
            int[] nArray = this.m_Table.getSelectedRows();
            this.m_Model.moveDown(nArray[0]);
            this.m_Table.select(nArray[0] + 1);
            this.m_RawReport.setDirty(true);
        }
    }

    public DataSource getDataSource() {
        return this.m_DataSource;
    }

    public class FilterOrderedEditableTable
    extends OrderedEditableTable {
        public FilterOrderedEditableTable(TableModel tableModel, boolean bl, boolean bl2) {
            super(tableModel, bl, bl2);
        }

        @Override
        protected EditableTable.JTableEx newTable(TableModel tableModel) {
            return new JTableEx1(tableModel);
        }

        protected class JTableEx1
        extends EditableTable.JTableEx {
            private TableModel m_TableModel;
            private TableCellRenderer[] m_ColumnRenderers;

            public JTableEx1(TableModel tableModel) {
                super(tableModel);
                this.m_TableModel = tableModel;
            }

            @Override
            public void setAutoCreateColumns(boolean bl) {
                this.autoCreateColumnsFromModel = bl;
            }

            @Override
            public void setColumnRenderer(int n, TableCellRenderer tableCellRenderer) {
                if (this.m_ColumnRenderers == null) {
                    this.m_ColumnRenderers = new TableCellRenderer[this.getModel().getColumnCount()];
                }
                this.m_ColumnRenderers[n] = tableCellRenderer;
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                TableCellRenderer tableCellRenderer = null;
                if (this.m_ColumnRenderers != null) {
                    tableCellRenderer = this.m_ColumnRenderers[n2];
                }
                if (tableCellRenderer == null) {
                    tableCellRenderer = super.getCellRenderer(n, n2);
                }
                return tableCellRenderer;
            }

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                if (n2 == 2) {
                    When when = (When)this.m_TableModel.getValueAt(n, 1);
                    if (when == When.IN_DATASET || when == When.NOT_IN_DATASET) {
                        return new InDataSetEditor();
                    }
                    if (when == When.SCRIPT || when == When.NOT_SCRIPT) {
                        JTextField jTextField = new JTextField();
                        jTextField.setBorder(null);
                        jTextField.setFont(UIManager.getFont("Tree.font"));
                        return new DefaultCellEditor(jTextField);
                    }
                    if (when == When.EQUALS || when == When.NOT_EQUALS || when == When.MATCHES || when == When.MORE_THAN || when == When.LESS_THAN || when == When.NOT_MATCHES || when == When.NOT_MORE_THAN) {
                        DataSourceManager dataSourceManager;
                        String string = this.m_TableModel.getValueAt(n, 0).toString();
                        Object[] objectArray = FilterPage.this.m_Data.get(string);
                        if (objectArray == null) {
                            objectArray = new Object[]{};
                            dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
                            String string2 = FilterPage.this.m_DataSource.getDataSourceName();
                            if (StringUtil.isEmpty(string2)) {
                                return super.getCellEditor(n, n2);
                            }
                            try {
                                IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string2);
                                int n3 = iDataSource.getSchema().getColumnIndex(string);
                                DataTable dataTable = DataTable.build((IDataSource)iDataSource);
                                int n4 = dataTable.getRecordCount();
                                TreeSet<String> treeSet = new TreeSet<String>();
                                for (int i = 0; i < n4 && treeSet.size() < 100; ++i) {
                                    Object object = dataTable.getRecord(i).getData(n3);
                                    if (object == null) continue;
                                    treeSet.add(object.toString());
                                }
                                objectArray = treeSet.toArray(new Object[treeSet.size()]);
                                FilterPage.this.m_Data.put(string, objectArray);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        dataSourceManager = new JComboBox(objectArray);
                        dataSourceManager.setEditable(true);
                        return new DefaultCellEditor((JComboBox<?>)dataSourceManager);
                    }
                }
                return super.getCellEditor(n, n2);
            }
        }
    }

    public class WhenTableRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = WhenRenderer.i18n(object);
            return super.getTableCellRendererComponent(jTable, String.valueOf(object2), bl, bl2, n, n2);
        }
    }

    public class ComboTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private String[] m_Values;
        private JComboBox m_Box = new JComboBox();

        public ComboTableCellEditor(String string, String[] stringArray, String[] stringArray2) {
            this.m_Box.setName(string);
            this.m_Box.setFont(UIManager.getFont("Tree.font"));
            this.m_Values = stringArray;
            for (int i = 0; i < stringArray2.length; ++i) {
                ValuePair valuePair = new ValuePair();
                valuePair.value = stringArray[i];
                valuePair.type = stringArray2[i];
                this.m_Box.addItem(valuePair);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            int n3 = -1;
            if (object != null) {
                for (int i = 0; i < this.m_Values.length; ++i) {
                    if (!this.m_Values[i].equals(object)) continue;
                    n3 = i;
                    break;
                }
            }
            this.m_Box.setSelectedIndex(n3);
            return this.m_Box;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.m_Box.getSelectedItem() != null) {
                return ((ValuePair)this.m_Box.getSelectedItem()).value;
            }
            return null;
        }
    }

    private class InDataSetEditor
    extends BasicTableEditor
    implements ActionListener {
        protected IDataSetProviderTab[] m_DataSetProviderTabs = new IDataSetProviderTab[1];
        private JPanel m_Panel;
        private JTextField m_Text;
        private JButton m_Dots;

        public InDataSetEditor() {
            this.m_DataSetProviderTabs[0] = new RepositoryFieldTab();
            this.m_Panel = new JPanel(new BorderLayout());
            this.m_Text = new JTextField();
            this.m_Text.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.m_Dots = SwingFactory.newDotsButton(this);
            this.m_Panel.add((Component)this.m_Text, "Center");
            this.m_Panel.add((Component)this.m_Dots, "East");
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_Text.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.m_Text.setText(String.valueOf(object));
            return this.m_Panel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.m_Text.setText(String.valueOf(object));
            return this.m_Panel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            DataSetChooser dataSetChooser = new DataSetChooser(elixirFrame.getFrame(), this.m_Text.getText(), this.m_DataSetProviderTabs);
            elixirFrame.showModal(dataSetChooser);
            if (dataSetChooser.isOk()) {
                this.m_Text.setText(dataSetChooser.getSelection());
            }
        }
    }

    static class ValuePair {
        public String value;
        public String type;

        ValuePair() {
        }

        public String toString() {
            return this.value + " (" + this.type + ")";
        }
    }
}

