/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.data;

import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.function.Average;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.Max;
import com.elixirtech.data2.function.Min;
import com.elixirtech.erd.reportdesigner.data.ColumnInfo;
import java.util.Map;
import java.util.TreeMap;

public class InfoBuilder
implements DataListener2,
ColumnInfo {
    private IDataSource m_DataSource;
    private final int m_Column;
    private DataSchema m_Schema;
    private DataType m_Type;
    private Map<String, Long> m_Map;
    private long m_RecordCount;
    private long m_NullCount;
    private int m_MinLength = Integer.MAX_VALUE;
    private int m_MaxLength;
    private Function m_Average = new Average();
    private Function m_Min = new Min();
    private Function m_Max = new Max();

    public InfoBuilder(IDataSource iDataSource, int n) {
        this.m_Column = n;
        this.m_DataSource = iDataSource;
    }

    @Override
    public Map<String, Long> getValues() {
        return this.m_Map;
    }

    @Override
    public long getRecordCount() {
        return this.m_RecordCount;
    }

    @Override
    public long getNullCount() {
        return this.m_NullCount;
    }

    @Override
    public DataType getType() {
        return this.m_Type;
    }

    @Override
    public int getMinLength() {
        return this.m_MinLength;
    }

    @Override
    public int getMaxLength() {
        return this.m_MaxLength;
    }

    @Override
    public double getAverage() {
        return ((Number)this.m_Average.getResult()).doubleValue();
    }

    @Override
    public String getMin() {
        return this.m_Schema.format(this.m_Type, this.m_Min.getResult());
    }

    @Override
    public String getMax() {
        return this.m_Schema.format(this.m_Type, this.m_Max.getResult());
    }

    public void startData(IDataSource iDataSource) {
        this.m_Map = new TreeMap<String, Long>();
        this.m_Schema = iDataSource.getSchema();
        this.m_Type = this.m_Schema.getColumnType(this.m_Column);
        this.m_RecordCount = 0L;
        this.m_NullCount = 0L;
        this.m_Average.reset();
        this.m_Min.reset();
        this.m_Max.reset();
    }

    public void endData(IDataSource iDataSource) {
    }

    public void startGroup(DataGroup dataGroup) {
    }

    public void endGroup(DataGroup dataGroup) {
    }

    public boolean processRecord(DataRecord dataRecord) {
        ++this.m_RecordCount;
        Object object = dataRecord.getData(this.m_Column);
        if (object == null) {
            ++this.m_NullCount;
        } else {
            String string = this.m_Schema.format(this.m_Type, object);
            if (DataType.STRING == this.m_Type) {
                int n = string.length();
                this.m_MinLength = Math.min(this.m_MinLength, n);
                this.m_MaxLength = Math.max(this.m_MaxLength, n);
            } else if (this.m_Type.isNumeric()) {
                this.m_Average.update(object);
            }
            this.m_Min.update(object);
            this.m_Max.update(object);
            Long l = this.m_Map.get(string);
            if (l == null) {
                this.m_Map.put(string, 1L);
            } else {
                this.m_Map.put(string, l + 1L);
            }
        }
        return true;
    }

    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IDataSource.class) {
            return clazz.cast(this.m_DataSource);
        }
        return null;
    }
}

